<?php

namespace App\API_REST\Controllers;
/* require __DIR__ . '../conexion_singleton.php'; */

require_once __DIR__ . '/../function/conexion_singleton.php';

use Config;

class AsignarPVController
{
    public function getUsersEnterPrise($empresaID)
    {
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT pu.id as usuario_id ,pu.nombre  as usuario_nombre, pu.correo as usuario_correo , 
        ee.nombre  as nombre_empresa, ee.departamento as departamento_empresa
        from per_usuarios pu 
        join em_empresa ee on ee.id = pu.id_empresa 
        where pu.id_empresa = :empresa_id and pu.estado = :estado;";

        $stmt = $db->prepare($query);
        $stmt->bindParam('empresa_id', $empresaID);
        $stmt->bindParam('estado', $estado);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $usuarios = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            return $usuarios;
        }
    }

    public function getBrandsEnterPrise($empresaID)
    {
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT * from em_sucursal es where es.id_empresa = :empresa_id and es.estado =:estado ;";

        $stmt = $db->prepare($query);
        $stmt->bindParam('empresa_id', $empresaID);
        $stmt->bindParam('estado', $estado);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $brands = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            return $brands;
        }
    }

    public function getSalesPointsBrand($sucursalID)
    {
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT * from puntodeventa p where p.csucursal =:codigo_sucursal and p.estado =:estado ;";

        $stmt = $db->prepare($query);
        $stmt->bindParam('codigo_sucursal', $sucursalID);
        $stmt->bindParam('estado', $estado);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $brands = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            return $brands;
        }
    }
    
    public function getExistsAssign($userCode)
    {
        $db = Config::getConnection();
        $query = "SELECT * FROM puntos_ventas_user where user_id=:user_id";
        $stmt = $db->prepare($query);
        $stmt->bindParam('user_id', $userCode);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function assignPointSaleUser($sucursalCode,$userCode,$puntoVentaCode)
    {
        if ($this->getExistsAssign($userCode)) { 
            return ["transaccion" => false,"msg" => "El usuario ya tiene un Punto de Venta Asignado","data" => "Ninguno",];
        }
        else {
            $fechaActual = date('Y-m-d');
        $db = Config::getConnection();
        $query = "INSERT INTO puntos_ventas_user (user_id,tipo_pv,codigo_sucursal,fecha_sincronizacion)
        VALUES (:user_id,:tipo_pv,:codigo_sucursal,:fecha_sincronizacion)
        ";
        $stmt = $db->prepare($query);
        $stmt->bindParam('user_id', $userCode);
        $stmt->bindParam('tipo_pv', $puntoVentaCode);
        $stmt->bindParam('codigo_sucursal', $sucursalCode);
        $stmt->bindParam('fecha_sincronizacion', $fechaActual);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            return ["transaccion" => true,"msg" => "Asignado Con Éxito","data" => "Ninguno",];
        }else{
            return ["transaccion" => false,"msg" => "Asignado Sin Éxito","data" => "Ninguno",];
            
        }
        }

    }
}

$asignarPV = new AsignarPVController();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['metodo'] === 'getUsersEnterPrise') {
        $empresaID = $_POST['empresa_id'];
        $getUsers = $asignarPV->getUsersEnterPrise($empresaID);
        echo json_encode($getUsers);
    } else if ($_POST['metodo'] === 'getBrandsEnterprise') {
        $empresaID = $_POST['empresaID'];
        $getBrands = $asignarPV->getBrandsEnterPrise($empresaID);
        echo json_encode($getBrands);
    } else {
        if ($_POST['metodo'] === 'getSalesPointsBrand') {
            $sucursalCode = $_POST['sucursal_id'];
            $getSalePoints = $asignarPV->getSalesPointsBrand($sucursalCode);
            echo json_encode($getSalePoints);
        } else {
            if ($_POST['metodo'] === 'assignPointSaleUser') {
                $sucursalCode = $_POST['sucursal_id'];
                $userCode = $_POST['user_id'];
                $puntoVentaCode = $_POST['punto_venta_id'];
                $assignSalePoint = $asignarPV->assignPointSaleUser($sucursalCode,$userCode,$puntoVentaCode);
                echo json_encode($assignSalePoint);
            }
        }
    }
}
