<?php
//require_once('C:\xampp\htdocs\facturacion\API_REST\function\buildFacturaVaucher.php');
//require_once('C:\xampp\htdocs\facturacion\API_REST\function\builfFacturaMiddlePage.php');

require_once __DIR__ . '/buildFacturaVaucher.php';
require_once __DIR__ . '/builfFacturaMiddlePage.php';
require __DIR__ . '/../../ServiciosSiat/EmisionIndividualService.php';

use Dompdf\Dompdf;
use Dompdf\FontMetrics;
use Dompdf\Options;
use \Config as ConfiguracionDB;

function customAutoloader($nombreClase = 'EmisionIndividualService')
{
    $directorioBase = __DIR__ . '/../ServiciosSiat/';
    $prefijo = 'App\\ServiciosSiat\\';
    $longitud = strlen($prefijo);

    if (strncmp($prefijo, $nombreClase, $longitud) !== 0) {
        // La clase no coincide con el namespace especificado
        return;
    }

    $claseRelativa = substr($nombreClase, $longitud);
    $archivo = $directorioBase . str_replace('\\', '/', $claseRelativa) . '.php';

    if (file_exists($archivo)) {
        require $archivo;
    }
}

// Registrar la función autoloader
spl_autoload_register('customAutoloader');
$app->post('/enviarFacturaSiat', 'enviarFacturaSiat');

function obtenerCufd()
{

    $db = Config::getConnection();
    $sql = "SELECT *
    FROM impuestos_cufd
    ORDER BY idcufd DESC
    LIMIT 1";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $cufd = $stmt->fetch();

    return $cufd;
}

function getPuntoVenta()
{
    if (!isset($_SESSION)) {
        session_start();
    }
    $userData = json_decode($_SESSION['dataUser']);
    $userID = $userData->id;
    $empresaUser = $userData->id_empresa;
    $estado = 1;
    $db = Config::getConnection();
    $query = "SELECT * from puntodeventa p 
          join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
          where pvu.user_id = :user_id
          and p.id_empresa = :id_empresa
          and p.estado = :estado LIMIT 1; ";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $userID);
    $stmt->bindParam(':id_empresa', $empresaUser);
    $stmt->bindParam(':estado', $estado);
    $stmt->execute();

    $puntoVenta =  $stmt->fetch();

    return $puntoVenta;
}

function getPuntoVentaCuis($cuis)
{
    $db = Config::getConnection();
    $query = "SELECT * from impuestos_cufd where cuis=:cuis";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':cuis', $cuis);
    $stmt->execute();

    $getCuisCufd =  $stmt->fetch();

    return $getCuisCufd;
}

function getExistsEvent()
{
    $data = getPuntoVenta();

    $db = Config::getConnection();

    $sql = "SELECT * FROM evento_significativos
         WHERE CodigoSucursal=:CodigoSucursal AND CodigoPVenta=:CodigoPVenta";

    $stmt = $db->prepare($sql);
    $stmt->bindParam('CodigoSucursal', $data['csucursal']);
    $stmt->bindParam('CodigoPVenta', $data['cpuntoventa']);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        $eventoSignificativo =  $stmt->fetch();
        return $eventoSignificativo;
    }
    return null;
}

function verificar_caja($id_usuario, $db)
{
    try {
        $arrayEstado["estado"] = 1;
        $sql = "SELECT COUNT(*) AS count_caja
        from fi_caja u
        where u.id_usuario=:id_usuario AND u.estado=:estado";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario', $id_usuario);
        $stmt->bindParam('estado', $arrayEstado["estado"]);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            $data  = $stmt->fetch(PDO::FETCH_ASSOC);
            return $data;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}

function getPointSalee()
{

    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    $userData = json_decode($_SESSION['dataUser']);
    $userID = $userData->id;
    $empresaID = $userData->id_empresa;
    $estado = 1;
    $query = "SELECT * from puntodeventa p 
      join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
      where pvu.user_id = :user_id
      and p.id_empresa = :id_empresa
      and p.estado = :estado LIMIT 1; ";
    /*  $query = "SELECT * 
      from puntodeventa p 
      where p.id_empresa =:empresaID AND p.pc=:pc AND p.mac=:mac
      LIMIT 1"; */
    $db = Config::getConnection();
    $stmt = $db->prepare($query);


    /* $arrayData["pc"] = gethostname();
      $arrayData["mac"] = strtok(exec('getmac'), ' '); */
    $stmt->bindParam(':id_empresa', $empresaID);
    $stmt->bindParam(':user_id', $userID);
    $stmt->bindParam(':estado', $estado);
    $stmt->execute();
    if ($stmt->rowCount() > 0) {
        $puntoVenta = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        return $puntoVenta;
    } else {
        return false; /* False si aun no existe un PV0 */
    }
}


function enviarFacturaSiat()
{
    try {
        $request = Slim::getInstance()->request();
        $data =  $request->getBody();

        if (!isset($_SESSION)) {
            session_start();
        }
        $userData = json_decode($_SESSION['dataUser']);
        $userID = $userData->id;

        date_default_timezone_set('America/La_Paz');

        $get_point_sale = getPuntoVenta();

        $puntoCuisCufd = getPuntoVentaCuis($get_point_sale["ccuis"]);
        json_encode($puntoCuisCufd);

        if ($puntoCuisCufd["fechavigencia"] < date("Y-m-d H:i:s")) {
            echo json_encode([
                "res" => false,
                "transaccion" => 5,
                "msg" => "Cufd Fuera de Tolerancia, por favor actualice el Cufd"
            ]);
            exit();
        }

        $db = Config::getConnection();
        $verificandoCaja = verificar_caja($userID, $db);

        if ($verificandoCaja["count_caja"] == 0) {
            echo json_encode([
                "res" => false,
                "transaccion" => false,
                "msg" => "No tiene caja abierta"
            ]);
        } else {
            if ($data['metodo'] === 'enviarFactura') {
                $emisionIndividualService = new \App\ServiciosSiat\EmisionIndividualService();
                $eventoSignificativo = getExistsEvent();
                $codigoEvento = -1;
                if ($eventoSignificativo) {
                    
                    $codigoEvento = $eventoSignificativo['CodigoDesc'];
                    if (!$data["checkNormal"]) {
                        $codigoEvento = $eventoSignificativo['CodigoDesc'];
                    }
                }
                $dataFactura = $data['dataFactura'];
                $dataFactura['nro_factura'] = intval(getLastVenta())  + 1;
                $response = $emisionIndividualService->enviarFactura($dataFactura, $codigoEvento);
                if ($response['res'] != true || isset($response['res']->RespuestaServicioFacturacion)) {
                    $resSiat = $response['res'];
                    $factura = $response['factura'];
                    if ($resSiat->RespuestaServicioFacturacion->codigoEstado === 908) {
                        saveDataFactura($factura, $dataFactura, $resSiat->RespuestaServicioFacturacion->codigoDescripcion,$codigoEvento);
                        sendMailtoCustomer($factura, $dataFactura, $codigoEvento);
                    }
                    echo json_encode(array_merge($response, [
                        'venta' => obtenerVentaByNroFactura($factura->cabecera->numeroFactura)
                    ]));
                } else { //! Si es True es porque hubo evento 2 y no se envio a impuestos
                    $eventoSignificativo = getExistsEvent();
                    $codigoEvento = $eventoSignificativo['CodigoDesc'];
                    $factura = $response['factura'];
                    $fechaVenta = (new DateTime($factura->cabecera->fechaEmision))->format('Y-m-d H:i:s.u');
                    $fechaInicioEvento = $eventoSignificativo["FechaInicio"];
                    $fechaFinEvento = $eventoSignificativo["FechaFinal"];
                    $resSiat = -1;
                    if ($fechaVenta < $fechaInicioEvento) { //|| $fechaVenta > $fechaFinEvento
                        echo json_encode(array_merge($response, [
                            "transaccion" => -1,
                            "msg" => "La fecha venta tiene que estar dentro del rango-fecha incio= " . $fechaInicioEvento . " y fecha final= " . $fechaFinEvento
                        ]));
                        return true;
                    }
                    saveDataFactura($factura, $dataFactura, $resSiat,$codigoEvento);
                    $dataVenta = obtenerVentaByNroFactura($factura->cabecera->numeroFactura);
                    sendMailtoCustomer($factura, $dataVenta, $codigoEvento);

                    echo json_encode(array_merge($response, [
                        "transaccion" => 1,
                        "msg" => "Venta registrada"
                    ]));
                }
            }
        }
    } catch (\Throwable $th) {
        echo json_encode($th->getFile()) . '<br>';
        echo json_encode($th->getLine()) . '<br>';
        echo json_encode($th->getMessage());
    }
}

function obtenerVentaByNroFactura($nroFactura)
{
    $db = Config::getConnection();
    $sql = "SELECT * from venta WHERE nro_factura=:nro_factura LIMIT 1";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':nro_factura', $nroFactura);
    $stmt->execute();
    $venta = $stmt->fetch(PDO::FETCH_ASSOC);
    return $venta;
}

function saveDataFactura($dataFactura, $dataVenta, $codigoDescripcion,$codigoEvento)
{
    $evento_significativo_id = -1;
    $estadoEmision =  substr($codigoDescripcion, 0, 1);
    $evento_significativo_id = $codigoEvento;
    $estadoEmision = 'P';
    
    $estadoAnulacion = 0; /* Vigente */
    $cufdId = obtenerCufd();
    $montoGiftcard = 0;
    if (isset($dataFactura->cabecera->montoGiftCard)) {
        $montoGiftcard = $dataFactura->cabecera->montoGiftCard;
    }


    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $contador = cargar_contador_usuario($dataVenta['id_usuario'], $db);

        $sql = "INSERT INTO venta
                    ( id_sucursal,id_cliente,fecha_venta
                    ,tipo_venta,total,estado,saldo,nota
                    ,fecha_reg,fecha_up,id_usuario,descuento,
                    tipo_pago,tarjeta,es_paquete,cambio,merma,moneda_id, monto_giftcard,
                    cuf,leyenda,nro_factura,estado_emision,cufd_id,
                    evento_significativo_id, punto_venta_id,estado_anulacion, data_factura)
            
                    VALUES
                    ( :id_sucursal,:id_cliente,:fecha_venta
                    ,:tipo_venta,:total,:estado,:saldo,:nota
                    ,:fecha_reg,:fecha_up,:id_usuario,:descuento
                    ,:tipo_pago,:tarjeta,:es_paquete,:cambio,:merma
                    ,:moneda_id,:monto_giftcard,:cuf,:leyenda,:nro_factura,:estado_emision
                    ,:cufd_id ,:evento_significativo_id,:punto_venta_id,:estado_anulacion, :data_factura)";
        $data_factura_code["data"] = json_encode($dataFactura);
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_sucursal',   $dataVenta['id_sucursal']);
        $stmt->bindParam('fecha_venta',   $dataFactura->cabecera->fechaEmision);
        $stmt->bindParam('total',         $dataFactura->cabecera->montoTotal);
        $stmt->bindParam('fecha_reg',     $dataFactura->cabecera->fechaEmision);
        $stmt->bindParam('fecha_up',      $dataFactura->cabecera->fechaEmision);
        $stmt->bindParam('cuf',      $dataFactura->cabecera->cuf);
        $stmt->bindParam('leyenda',      $dataFactura->cabecera->leyenda);
        $stmt->bindParam('nro_factura',      $dataFactura->cabecera->numeroFactura);
        $stmt->bindParam('estado_emision', $estadoEmision);
        $stmt->bindParam('id_cliente',    $dataVenta['id_cliente']);
        $stmt->bindParam('tipo_venta',    $dataVenta['tipo_venta']);
        $stmt->bindParam('estado',        $dataVenta['estado']);
        $stmt->bindParam('saldo',         $dataVenta['saldo']);
        $stmt->bindParam('nota',          $dataVenta['nota']);
        $stmt->bindParam('id_usuario',    $dataVenta['id_usuario']);
        $stmt->bindParam('descuento',     $dataVenta['descuento']);
        $stmt->bindParam('tipo_pago',         $dataVenta['tipo_pago']);
        $stmt->bindParam('tarjeta',         $dataVenta['tarjeta']);
        $stmt->bindParam('es_paquete',         $dataVenta['es_paquete']);
        $stmt->bindParam('cambio',         $dataVenta['cambio']);
        $stmt->bindParam('merma',         $contador['contador']);
        $stmt->bindParam('moneda_id',         $dataFactura->cabecera->codigoMoneda);
        $stmt->bindParam('monto_giftcard',        $montoGiftcard);
        $stmt->bindParam('cufd_id',         $cufdId['idcufd']);
        $stmt->bindParam('punto_venta_id',         $dataFactura->cabecera->codigoPuntoVenta);
        $stmt->bindParam('evento_significativo_id',         $evento_significativo_id);
        $stmt->bindParam('estado_anulacion',         $estadoAnulacion);
        $stmt->bindParam('data_factura',         $data_factura_code["data"]);

        $stmt->execute();
        $id = $db->lastInsertId();
        $error = 0;
        if ($stmt->rowCount() > 0) {
            foreach ((array)$dataVenta['productos'] as $key => $value) {
                $cantidad = $value['cantidad'];

                while ($cantidad > 0) {
                    $producto_inventario = cargar_Inv_Producto_Cantidad($db, $value['id_producto'], $value['id_almacen'], 1, 1);
                    if ($producto_inventario) {
                        for ($i = 0; $i < count($producto_inventario); $i++) {
                            if ($cantidad >= $producto_inventario[$i]['cantidad']) {
                                $cantidad = $cantidad - $producto_inventario[$i]['cantidad'];
                                $det_ = insertar_venta_detalle($db, $value, $producto_inventario[$i]['cantidad'], $producto_inventario[$i], $id);
                                $inv_ =  actualizar_inventario($db, $value, $producto_inventario[$i]['id']);
                            } else {

                                $det_ =  insertar_venta_detalle($db, $value, $cantidad, $producto_inventario[$i], $id);
                                $inv_ =   actualizar_inventario($db, $value, $producto_inventario[$i]['id']);
                                $cantidad = 0;
                                $i = count($producto_inventario);
                            }
                        }
                        if (!$det_) {
                            $error++;
                        }
                        if (!$inv_) {
                            $error++;
                        }
                    } else {
                        $producto_inventario = cargar_Inv_Producto_Cantidad($db, $value['id_producto'], $value['id_almacen'], 1, 2);
                        $det_ =   insertar_venta_detalle($db, $value, $cantidad, $producto_inventario[0], $id);
                        $inv_ =  actualizar_inventario($db, $value, $producto_inventario[0]['id']);
                        $cantidad = 0;
                        if (!$det_) {
                            $error++;
                        }
                        if (!$inv_) {
                            $error++;
                        }
                    }
                }
            }
            $cont =   actualizar_contador($db, $dataVenta['id_usuario'], $contador['contador']);
        }
        $db->commit();

        /* $db = null; */
        $stmt = null;
    } catch (PDOException $e) {
        $db->rollback();
        $db = null;
        throw $e;
    }
}

function getLastVenta()
{
    $db = Config::getConnection();
    $sql = "SELECT IFNULL(MAX(nro_factura),0) AS nro_factura
         FROM venta";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $lastVenta = $stmt->fetch();
    return $lastVenta['nro_factura'];
}

function getClient($idCliente)
{
    $db = Config::getConnection();
    $query = "SELECT * FROM  cli_cliente c WHERE c.id=:idCliente;";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':idCliente', $idCliente);
    $stmt->execute();
    $cliente = $stmt->fetch();

    return json_encode($cliente);
}

function getEstadoAnulacion($nro_factura)
{
    $db = ConfiguracionDB::getConnection();
    $sql = "SELECT evento_significativo_id,estado_anulacion FROM venta WHERE  nro_factura=:nro_factura LIMIT 1";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':nro_factura', $nro_factura);
    $stmt->execute();

    $response = $stmt->fetch(\PDO::FETCH_ASSOC);

    return json_encode($response);
}

function getCorreosVar()
{
    if (!isset($_SESSION)) {
        session_start();
    }

    $userEmpresaID = json_decode($_SESSION['dataUser']);

    $db = Config::getConnection();
    $sql = "SELECT * FROM impuestos_correo WHERE  id_empresa =:id_empresa LIMIT 1";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':id_empresa', $userEmpresaID->id_empresa);
    $stmt->execute();
    $response = $stmt->fetch(\PDO::FETCH_ASSOC);

    return $response;
}

function sendMailtoCustomer($dataFactura, $dataVenta, $codigoEvento)
{
    // Instanciar el objeto PHPMailer
    $mail = new PHPMailer(true);
    $idCliente = $dataFactura->cabecera->codigoCliente;
    $resCodigoCliente = json_decode(getClient($idCliente));

    /* try { */
    $mail->isSMTP();

    $mail->Host = getCorreosVar()["host"];
    $mail->SMTPAuth = true;
    $mail->Username = getCorreosVar()["correo"];
    $mail->Password = getCorreosVar()["contrasena"];
    $mail->Port = getCorreosVar()["puerto"];
    $mail->SMTPSecure = getCorreosVar()["ssltls"] == 1 ? 'ssl' : 'tls';
    // Configurar el remitente y el destinatario
    $mail->setFrom(getCorreosVar()["correo"]);
    $mail->addAddress($resCodigoCliente->correo);
    $mail->addCC('rdamain@rda-consultores.com', $resCodigoCliente->correo);
    // Configurar el contenido del correo
    $mail->isHTML(true);
    $mail->Subject = "facturacion electronica en linea" ;
    $mail->Body = "le hacemos entrega de su factura digital";
    // Adjuntar un archivo
    $publicPath = $_SERVER['DOCUMENT_ROOT'] . '/facturacion';

    $getDataAnulacion = json_decode(getEstadoAnulacion($dataFactura->cabecera->numeroFactura));

    $evento_significativo = $codigoEvento == -1 ? 0 : $codigoEvento;

    $archivo = $publicPath . '/FacturasXML/factura-' . $dataFactura->cabecera->numeroDocumento . '-' . $dataFactura->cabecera->numeroFactura . '-' . $evento_significativo  . '.xml';


    //if ($getDataAnulacion->estado_anulacion != 0) {
    //EMPIEZA EL ANULADO
    $options = new Options();
    $options->set('isPhpEnabled', true);
    $options->set('isJavascriptEnabled ', true);
    $options->set('isHtml5ParserEnabled  ', true);
    $options->set('isRemoteEnabled', true);
    $options->setIsRemoteEnabled(true);
    $options->setIsHtml5ParserEnabled(true);
    $options->setIsPhpEnabled(true);
    $options->setIsJavascriptEnabled(true);
    //}
    $dompdf = new Dompdf($options);
    $dompdf->loadHtml(buildFacturaMiddlePage($dataFactura, $dataVenta));
    /* $dompdf->loadHtml(buildFacturaVaucher($dataFactura, $dataVenta)); */
    /* $dompdf->setPaper([0, 0, 950.98, 280.05], 'landscape'); */
    $dompdf->setPaper('letter', 'landscape');
    $dompdf->render();
    if ($getDataAnulacion->estado_anulacion != 0) {
        // instantiate and use the dompdf class

        $canvas = $dompdf->get_canvas();

        $fontMetrics = new FontMetrics($canvas, $options);
        $w = $canvas->get_width();
        $h = $canvas->get_height();
        $font = $fontMetrics->getFont('times');
        $text = "ANULADO";

        $txtHeight = $fontMetrics->getFontHeight($font, 75);
        $textWidth = $fontMetrics->getTextWidth($text, $font, 75);

        $x = ($w - $textWidth) / 2;
        $y = ($h - $txtHeight) / 1.4;
        $canvas->text($x, $y, $text, $font, 75, array(255, 0, 0), '', '', -30);
        //FIND DE ANULADO
    }
    // (Optional) Setup the paper size and orientation        


    //file_put_contents(__DIR__ . '/../../FacturasPDF/factura-' . $dataFactura->cabecera->numeroDocumento . '-' . $dataFactura->cabecera->numeroFactura . '.pdf', $dompdf->output());
    file_put_contents(__DIR__ . '/../../FacturasPDF/factura-' . $dataFactura->cabecera->numeroFactura . '-' . $evento_significativo . '.pdf', $dompdf->output());
    $mail->addStringAttachment($dompdf->output(), 'factura.pdf');
    $mail->addAttachment($archivo);
    // Enviar el correo
    $mail->send();
    /* } catch (Exception $e) {
        throw $e;
        
    } */
}
