<?php
/* glosario para ubicarse por tablas
tabla_dashboard
tabla_usuarios
tabla_administrador
tabla_permisos
tabla_empresa
tabla_sucursal
tabla_cliente
tabla_proveedor
tabla_almacen
tabla_colonia
tabla_campo
tabla_producto
tabla_responsable
tabla_ingreso
tabla_pago_compra
tabla_venta
tabla_proforma
tabla_cajas
tabla_tipo_ingreso_egreso
tabla_fin_ingreso_egreso
tabla_viajes
tabla_costo_viaje
tabla_tipo_costos
tabla_reportes
*/
/////////////tabla_dashboard
$app->get('/cargar_datos_dashboard/:id_empresa/:fecha_ini/:fecha_fin', 'cargar_datos_dashboard');
function cargar_datos_dashboard($id_empresa, $fecha_ini, $fecha_fin)
{
    try {
        $db = Config::getConnection();


        $array['clientes'] = cargar_clientes_dashboard($id_empresa, $db);
        $array['ventas'] = cargar_ventas_dashboard($id_empresa, $fecha_ini, $fecha_fin, $db);
        $array['compras'] = cargar_compras_dashboard($id_empresa, $fecha_ini, $fecha_fin, $db);
        $array['ventas_dash'] = cargar_ventas_d_dashboard($id_empresa, $fecha_ini, $fecha_fin, $db);
        echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';


        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_clientes_dashboard($id_empresa, $db)
{
    $sql = "SELECT count(id) as clientes
    from cli_cliente c
    where c.id_empresa=:id_empresa;";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':id_empresa', $id_empresa);
    $stmt->execute();
    $i = 0;
    if ($stmt->rowCount() > 0) {
        while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $array          = trim($data['clientes']);
            $i++;
        }
        return $array;
    } else {
        return 0;
    }
}
function cargar_ventas_dashboard($id_empresa, $fecha_ini, $fecha_fin, $db)
{
    $sql = "SELECT count(v.id) as ventas
    from venta v,em_sucursal s
    where v.id_sucursal=s.id
    and s.id_empresa=:id_empresa
    and v.estado!=0
    and date(v.fecha_venta) between :fecha_ini and :fecha_fin ;";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':id_empresa', $id_empresa);
    $stmt->bindParam(':fecha_ini', $fecha_ini);
    $stmt->bindParam(':fecha_fin', $fecha_fin);
    $stmt->execute();
    $i = 0;
    if ($stmt->rowCount() > 0) {
        while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $array          = trim($data['ventas']);
            $i++;
        }
        return $array;
    } else {
        return 0;
    }
}
function cargar_compras_dashboard($id_empresa, $fecha_ini, $fecha_fin, $db)
{
    $sql = "SELECT count(i.id) as compras
    from in_ingreso i,em_sucursal s
    where i.id_sucursal=s.id
    and s.id_empresa=:id_empresa
    and i.estado=1
    and date(i.fecha_ingreso) between :fecha_ini and :fecha_fin ;";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':id_empresa', $id_empresa);
    $stmt->bindParam(':fecha_ini', $fecha_ini);
    $stmt->bindParam(':fecha_fin', $fecha_fin);
    $stmt->execute();
    $i = 0;
    if ($stmt->rowCount() > 0) {
        while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $array          = trim($data['compras']);
            $i++;
        }
        return $array;
    } else {
        return 0;
    }
}
function cargar_ventas_d_dashboard($id_empresa, $fecha_ini, $fecha_fin, $db)
{
    $sql = "SELECT sum(v.total)as total,date(v.fecha_venta)as fecha
    from venta v,em_sucursal s
    where v.id_sucursal=s.id
    and s.id_empresa=:id_empresa
    and v.estado!=0
    and date(v.fecha_venta) between :fecha_ini and :fecha_fin 
    group by date(v.fecha_venta);";
    $stmt = $db->prepare($sql);
    $stmt->bindParam(':id_empresa', $id_empresa);
    $stmt->bindParam(':fecha_ini', $fecha_ini);
    $stmt->bindParam(':fecha_fin', $fecha_fin);
    $stmt->execute();
    $i = 0;
    if ($stmt->rowCount() > 0) {
        while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $array[$i]['venta']          = trim($data['total']);
            $array[$i]['fecha']          = trim($data['fecha']);
            $i++;
        }
        return $array;
    } else {
        return 0;
    }
}
///////////tabla_usuarios
define('subir_productos', '../img/');
$app->post('/getusuario', 'getusuario');

function getusuario()
{
    try {
        $request      = Slim::getInstance()->request();
        $datab         = ($request->getBody());
        $sql = "SELECT u.id, u.nombre,u.correo,u.pass
        ,u.telefono,u.id_empresa,u.id_rol,u.foto
        ,e.estado ,r.pagina_defecto
        from per_usuarios u,em_empresa e,rol r
        where u.estado=1
        and u.id_rol=r.id
        and u.id_empresa=e.id
        and u.correo=:correo
        and u.pass=:pass";
        $db   = Config::getConnection();
        $stmt = $db->prepare($sql);
        $stmt->bindParam('correo', $datab['correo']);
        $stmt->bindParam('pass', $datab['pass']);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']            = trim($data['id']);
                $array['nombre']        = trim($data['nombre']);
                $array['correo']         = trim($data['correo']);
                $array['telefono']      = trim($data['telefono']);
                $array['id_empresa']    = trim($data['id_empresa']);
                $array['id_rol']        = trim($data['id_rol']);
                $array['foto']          = trim($data['foto']);
                $array['estado']        = trim($data['estado']);
                $array['pagina_defecto'] = trim($data['pagina_defecto']);

                $i++;
            }
            if (!isset($_SESSION)) {
                session_start();
            }

            $_SESSION['dataUser'] =  json_encode($array);
            file_put_contents("BodyLoginArrayOtro.txt", json_encode($array));
            file_put_contents("BodyLoginOtro.txt", $_SESSION['dataUser']);
            echo  ' {
                "errorCode": 0,
                "errorMessage": "usuario. ",
                "msg": ' . json_encode($array) . '
                }';
        } else {
            echo     '{
                                "errorCode": 2,
                                "errorMessage": "No hay datos.",
                                "msg": "0"  
                        }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {

        $db = null;
        $stmt = null;
        echo '{
                    "errorCode": 3,
                    "errorMessage": "Error al ejecutar el servicio web.",
                    "msg": "' . $e . '"  
            }';
    }
}
$app->get('/cargar_usuarios/:id_empresa', 'cargar_usuarios');
function cargar_usuarios($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT u.id, u.nombre, u.correo, u.pass,u.telefono,u.id_empresa,u.id_rol,u.cargo
         ,u.salario,u.foto,u.estado
         ,r.nombre as rol
         from per_usuarios u,rol r
         where u.id_empresa=:id_empresa
         and u.id_rol=r.id
         and u.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']           = trim($data['id']);
                $array[$i]['nombre']       = trim($data['nombre']);
                $array[$i]['correo']       = trim($data['correo']);
                $array[$i]['telefono']     = trim($data['telefono']);
                $array[$i]['id_rol']       = trim($data['id_rol']);
                $array[$i]['cargo']        = trim($data['cargo']);
                $array[$i]['salario']      = trim($data['salario']);
                $array[$i]['rol']          = trim($data['rol']);
                $i++;
            }
            $roles = cargar_roles($db);
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . ',
                "roles":' . json_encode($roles) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_roles($db)
{
    $sql = "SELECT id,nombre from rol where estado=1";
    $stmt = $db->prepare($sql);
    $stmt->execute();
    $i = 0;
    if ($stmt->rowCount() > 0) {
        while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $array[$i]['id']           = trim($data['id']);
            $array[$i]['nombre']       = trim($data['nombre']);
            $i++;
        }
        return $array;
    } else {
        return 0;
    }
}
$app->post('/insertar_usuario', 'insertar_usuario');
function insertar_usuario()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());
        $correo_existente = verificar_correo($data['correo'], $db);
        if ($correo_existente == 0) {
            $fechaReg = date('Y-m-d H:i:s');
            $sql = "INSERT INTO per_usuarios
                    (nombre, correo, pass,telefono,id_empresa,id_rol,cargo
                    ,salario,fecha_nac,estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:nombre, :correo, '123456',:telefono,:id_empresa,:id_rol,:cargo
                    ,:salario,:fecha_nac,1,:fecha_reg,:fecha_up)";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('nombre',     $data['nombre']);
            $stmt->bindParam('correo',     $data['correo']);
            $stmt->bindParam('telefono',   $data['telefono']);
            $stmt->bindParam('id_empresa', $data['id_empresa']);
            $stmt->bindParam('id_rol',     $data['id_rol']);
            $stmt->bindParam('cargo',      $data['cargo']);
            $stmt->bindParam('salario',    $data['salario']);
            $stmt->bindParam('fecha_nac',  $data['fecha_nac']);
            $stmt->bindParam('fecha_reg',  $fechaReg);
            $stmt->bindParam('fecha_up',   $fechaReg);

            $stmt->execute();
            $id = $db->lastInsertId();
            $i = 0;
            if ($stmt->rowCount() > 0) {

                //  $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
            } else {
                echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
            }
        } else {
            echo ' {
                        "errorCode": 2,
                        "errorMessage": "El correo ya existe."
                    }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function verificar_correo($correo, $db)
{
    $sql = "SELECT id from per_usuarios where correo=:correo and estado=1";
    $stmt = $db->prepare($sql);
    $stmt->bindParam('correo', $correo);
    $stmt->execute();
    if ($stmt->rowCount() > 0) {
        return true;
    } else {
        return 0;
    }
}
$app->get('/cargar_usuarios_u/:id_usuario', 'cargar_usuarios_u');
function cargar_usuarios_u($id_usuario)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT u.id, u.nombre, u.correo, u.pass,u.telefono,u.id_empresa,u.id_rol,u.cargo
         ,u.salario,u.estado,foto
         ,r.nombre as rol
         from per_usuarios u,rol r
         where u.id=:id_usuario
        and u.id_rol=r.id
         and u.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario', $id_usuario);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']           = trim($data['id']);
                $array['nombre']       = trim($data['nombre']);
                $array['correo']       = trim($data['correo']);
                $array['pass']         = trim($data['pass']);
                $array['telefono']     = trim($data['telefono']);
                $array['id_rol']       = trim($data['id_rol']);
                $array['cargo']        = trim($data['cargo']);
                $array['salario']      = trim($data['salario']);
                $array['estado']       = trim($data['estado']);
                $array['foto']       = trim($data['foto']);
                $array['rol']          = trim($data['rol']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_usuario', 'actualizar_usuario');
function actualizar_usuario()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());
        $consulta = '';
        if (!isset($data["id_empresa"])) {
            $consulta = ',pass=:pass';
        }
        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE per_usuarios
                    set
                    nombre=:nombre
                    $consulta
                    ,telefono=:telefono
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',     $data['nombre']);
        $stmt->bindParam('telefono',   $data['telefono']);

        $stmt->bindParam('fecha_up',   $fechaReg);
        $stmt->bindParam('id',         $data['id']);
        if (!isset($data['id_empresa'])) {
            $stmt->bindParam('pass',     $data['pass']);
        }
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/actualizar_usuario_img', 'actualizar_usuario_img');
function actualizar_usuario_img()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE per_usuarios
                    set
                    foto=:foto
                    
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',     $data['id']);
        $imagen = imageProducto($data['foto'], $data['id_empresa'], 'usuario');
        $stmt->bindParam('foto',           $imagen);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": "' . ($imagen) . '"
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_usuario', 'eliminar_usuario');
function eliminar_usuario()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE per_usuarios
                    set
                    estado=0,
                    fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        // $stmt ->bindParam('estado',  $data['estado']);
        $stmt->bindParam('id',         $data['id']);
        $stmt->bindParam('fecha_up',   $fechaReg);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}

// tabla_administrador
$app->get('/ver_empresas_plan', 'ver_empresas_plan');
function ver_empresas_plan()
{
    try {
        $db = Config::getConnection();

        $sql = "SELECT p.id, e.nombre ,m.nombre as modalidad
        ,p.id_empresa,p.monto,p.saldo,p.fecha_inicio
        ,p.fecha_fin,DATE(NOW()) + INTERVAL -7 DAY as fecha_semanal,DATE(NOW()) as fecha_hoy
        ,e.estado
        from em_plan p,em_empresa e,em_modalidad_pago m
        where p.id_empresa=e.id
        and p.id_modalidad_pago=m.id
        and p.saldo>0
        and p.id_tipo_plan !=4
        and (date(p.fecha_fin) between DATE(NOW()) + INTERVAL -7 DAY and  DATE(NOW())
        or p.fecha_fin < date(now()));";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']           = trim($data['id_empresa']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['modalidad']           = trim($data['modalidad']);
                $array[$i]['monto']           = trim($data['monto']);
                $array[$i]['saldo']           = trim($data['saldo']);
                $array[$i]['fecha_inicio']           = trim($data['fecha_inicio']);
                $array[$i]['fecha_fin']           = trim($data['fecha_fin']);
                if ($data['estado'] == 1) {
                    $array[$i]['estado_n'] = "Activo";
                } else {
                    $array[$i]['estado_n'] = "Inactivo";
                }
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg":' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Sin empresas."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_empresas/:fecha_ini/:fecha_fin', 'cargar_empresas');
function cargar_empresas($fecha_ini, $fecha_fin)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT e.id,e.nombre,e.estado,date(p.fecha_inicio)as fecha_inicio,date(p.fecha_fin)as fecha_fin
         ,p.monto,p.saldo,p.id_modalidad_pago,m.nombre as modalidad
         from em_empresa e,em_plan p,em_modalidad_pago m
         where e.id=p.id_empresa
         and p.id_modalidad_pago=m.id
         and date(e.fecha_reg) between :fecha_ini and :fecha_fin";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->execute();
        $i = 0;
        $modalidad = cargar_modalidad($db);

        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']           = trim($data['id']);
                $array[$i]['nombre']       = trim($data['nombre']);
                $array[$i]['estado']       = trim($data['estado']);
                if ($data['estado'] == 1) {
                    $array[$i]['estado_n'] = "Activo";
                } else {
                    $array[$i]['estado_n'] = "Inactivo";
                }
                $array[$i]['fecha_inicio'] = trim($data['fecha_inicio']);
                $array[$i]['fecha_fin']    = trim($data['fecha_fin']);
                $array[$i]['monto']        = trim($data['monto']);
                $array[$i]['saldo']        = trim($data['saldo']);
                $array[$i]['id_modalidad_pago']    = trim($data['id_modalidad_pago']);
                $array[$i]['modalidad']    = trim($data['modalidad']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . ',
                "modalidad": ' . json_encode($modalidad) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio.",
                "modalidad": ' . json_encode($modalidad) . '
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_modalidad($db)
{
    try {
        $sql = "SELECT id,nombre from em_modalidad_pago";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']           = trim($data['id']);
                $array[$i]['nombre']       = trim($data['nombre']);
                $i++;
            }
            return $array;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        return 0;
    }
}
$app->get('/cargar_pagos_empresa/:id', 'cargar_pagos_empresa');
function cargar_pagos_empresa($id)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, date(p.fecha_pago)as fecha_pago,p.pago,p.estado
         from em_pagos p
         where id_empresa=:id_empresa
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {

                $array[$i]['id']           = trim($data['id']);
                $array[$i]['fecha_pago']           = trim($data['fecha_pago']);
                $array[$i]['pago']       = trim($data['pago']);
                $array[$i]['estado']       = trim($data['estado']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/insertar_pago_empresa', 'insertar_pago_empresa');
function insertar_pago_empresa()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO em_pagos
                    (fecha_pago,pago,id_empresa, estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:fecha_pago,:pago,:id_empresa,1,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_pago',         $data['fecha_pago']);
        $stmt->bindParam('pago',         $data['pago']);
        $stmt->bindParam('id_empresa',         $data['id_empresa']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            actualizar_saldo_empresa($data['id_empresa'], $data['pago'], $db, 1);
            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function actualizar_saldo_empresa($id_empresa, $monto, $db, $tipo)
{

    try {
        $fechaReg = date('Y-m-d H:i:s');

        if ($tipo == 1) {
            $sql = "UPDATE em_plan
                SET saldo=saldo-:monto
                ,fecha_up=:fecha_up
                WHERE id_empresa=:id";
        } else {
            $sql = "UPDATE em_plan
                set
               
                saldo=saldo+:monto
                ,fecha_up=:fecha_up
                where
                id_empresa=:id 
                ";
        }

        $stmt = $db->prepare($sql);
        $stmt->bindParam('monto',            $monto);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $id_empresa);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            return true;
        } else {
            return false;
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                "errorCode": 3,
                "errorMessage": "Error al ejecutar el servicio web.",
                "msg": 0
            }';
    }
}
$app->post('/eliminar_pago_empresa', 'eliminar_pago_empresa');
function eliminar_pago_empresa()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_pagos
                    set
                    estado=0
                    
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            actualizar_saldo_empresa($data['id_empresa'], $data['monto'], $db, 2);
            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}

$app->post('/insertar_empresa', 'insertar_empresa');
function insertar_empresa()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO em_empresa
                    (nombre, estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:nombre, 1,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            nuevo_plan($id, $data['fecha_inicio'], $data['fecha_fin'], $data['monto'], $data['id_modalidad'], $db);
            $id_sucursal = nueva_sucursal($id, $db);
            // nuevo_almacen($id_sucursal,$db);
            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function nuevo_plan($id_empresa, $fecha_ini, $fecha_fin, $monto, $id_modalidad, $db)
{
    try {


        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO em_plan
        (id_empresa,id_tipo_plan, estado,id_modalidad_pago,fecha_inicio,fecha_fin,monto,saldo,fecha_reg,fecha_up)

        VALUES 
        (:id_empresa,1  , 1  ,:id_modalidad_pago,:fecha_ini,:fecha_fin,:monto,:saldo,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa',         $id_empresa);
        $stmt->bindParam('id_modalidad_pago',  $id_modalidad);
        $stmt->bindParam('fecha_ini',      $fecha_ini);
        $stmt->bindParam('fecha_fin',      $fecha_fin);
        $stmt->bindParam('monto',          $monto);
        $stmt->bindParam('saldo',          $monto);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            return $id;
        } else {
            return false;
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                "errorCode": 3,
                "errorMessage": "Error al ejecutar el servicio web.",
                "msg": 0
            }';
    }
}
function nueva_sucursal($id_empresa, $db)
{
    try {


        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO em_sucursal
            (id_empresa, estado,nombre,fecha_reg,fecha_up)
    
            VALUES 
            (:id_empresa, 1,'central',:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa',         $id_empresa);


        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            return $id;
        } else {
            return false;
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                    "errorCode": 3,
                    "errorMessage": "Error al ejecutar el servicio web.",
                    "msg": 0
                }';
    }
}
$app->post('/actualizar_plan', 'actualizar_plan');
function actualizar_plan()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_plan
                    set
                    fecha_inicio=:fecha_ini
                    ,fecha_fin=:fecha_fin
                    ,monto=:monto
                    ,id_modalidad_pago=:id_modalidad_pago
                    ,fecha_up=:fecha_up
                    where
                    id_empresa=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini',      $data['fecha_inicio']);
        $stmt->bindParam('fecha_fin',      $data['fecha_fin']);
        $stmt->bindParam('monto',          $data['monto']);
        $stmt->bindParam('id_modalidad_pago',   $data['id_modalidad']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/insertar_usuario_emp', 'insertar_usuario_emp');
function insertar_usuario_emp()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());
        $correo_existente = verificar_correo($data['correo'], $db);
        if ($correo_existente == 0) {
            $fechaReg = date('Y-m-d H:i:s');
            $sql = "INSERT INTO per_usuarios
                    (nombre, correo, pass,id_empresa,id_rol,estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:nombre, :correo, :pass,:id_empresa,2,1,:fecha_reg,:fecha_up)";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('nombre',     $data['nombre']);
            $stmt->bindParam('correo',     $data['correo']);
            $stmt->bindParam('pass',       $data['pass']);
            $stmt->bindParam('id_empresa', $data['id_empresa']);
            $stmt->bindParam('fecha_reg',  $fechaReg);
            $stmt->bindParam('fecha_up',   $fechaReg);

            $stmt->execute();
            $id = $db->lastInsertId();
            $i = 0;
            if ($stmt->rowCount() > 0) {

                //  $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
            } else {
                echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
            }
        } else {
            echo ' {
                        "errorCode": 2,
                        "errorMessage": "El correo ya existe."
                    }';
        }


        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}

$app->post('/desactivar_empresa', 'desactivar_empresa');
function desactivar_empresa()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_empresa
                    set
                    estado=:estado
                    
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('estado',         $data['estado']);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
////////tabla_permisos
$app->post('/verificar_permiso', 'verificar_permiso');
function verificar_permiso()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $sql = "SELECT r.nombre,e.estado
                    from per_usuarios u,permiso_rol r,em_empresa e
                    where u.id_rol=r.id_rol
                    and r.estado=1
                    and u.id_empresa=e.id
                    and u.id=:id_usuario
                    and r.formulario=:formulario
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario',         $data['usuario']);
        $stmt->bindParam('formulario',      $data['pagina']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['estado']               = trim($data['estado']);

                $i++;
            }
            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . json_encode($array) . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
///////////tabla_empresa

$app->get('/ver_plan_empresa_id/:id_empresa', 'ver_plan_empresa_id');
function ver_plan_empresa_id($id_empresa)
{
    try {
        $db = Config::getConnection();

        $sql = "SELECT p.id, e.nombre ,m.nombre as modalidad
        ,p.id_empresa,p.monto,p.saldo,p.fecha_inicio
        ,p.fecha_fin,DATE(NOW()) + INTERVAL -7 DAY as fecha_semanal,DATE(NOW()) as fecha_hoy
        ,e.estado
        from em_plan p,em_empresa e,em_modalidad_pago m
        where p.id_empresa=e.id
        and p.id_modalidad_pago=m.id
        and p.id_empresa=:id_empresa
        and p.saldo>0
        and p.id_tipo_plan !=4
        and (date(p.fecha_fin) between DATE(NOW()) + INTERVAL -7 DAY and  DATE(NOW())
        or p.fecha_fin < date(now()));";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']           = trim($data['id_empresa']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['modalidad']           = trim($data['modalidad']);
                $array[$i]['monto']           = trim($data['monto']);
                $array[$i]['saldo']           = trim($data['saldo']);
                $array[$i]['fecha_inicio']           = trim($data['fecha_inicio']);
                $array[$i]['fecha_fin']           = trim($data['fecha_fin']);
                if ($data['estado'] == 1) {
                    $array[$i]['estado_n'] = "Activo";
                } else {
                    $array[$i]['estado_n'] = "Inactivo";
                }
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg":' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Sin empresas."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_empresa_u/:id_empresa', 'cargar_empresa_u');
function cargar_empresa_u($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT e.id, e.nombre, e.nit, e.foto
         ,e.descripcion,e.rubro
         ,e.foto
         ,e.tipo_impresion
         from em_empresa e
         where e.id=:id_empresa
         and e.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['nombre']           = trim($data['nombre']);
                $array['nit']              = trim($data['nit']);
                $array['foto']             = trim($data['foto']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['rubro']            = trim($data['rubro']);
                $array['foto']             = trim($data['foto']);
                $array['tipo_impresion']             = trim($data['tipo_impresion']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->post('/actualizar_empresa', 'actualizar_empresa');
function actualizar_empresa()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_empresa
                    set
                    nombre=:nombre, nit=:nit, descripcion=:descripcion
                    ,rubro=:rubro
                    ,tipo_impresion=:tipo_impresion
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nit',            $data['nit']);
        $stmt->bindParam('descripcion',    $data['descripcion']);
        $stmt->bindParam('rubro',          $data['rubro']);
        $stmt->bindParam('tipo_impresion', $data['tipo_impresion']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}

$app->post('/actualizar_empresa_img', 'actualizar_empresa_img');
function actualizar_empresa_img()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_empresa
                    set
                    foto=:foto
                    
                    ,fecha_up=:fecha_up
                    where
                    id=:id_empresa 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id_empresa',     $data['id_empresa']);
        $imagen = imageProducto($data['foto'], $data['id_empresa'], 'empresa');
        $stmt->bindParam('foto',           $imagen);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
///////////tabla_sucursal
$app->post('/insertar_sucursal', 'insertar_sucursal');
function insertar_sucursal()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO em_sucursal
                    (id_empresa,nombre, nombre_factura, direccion,estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:id_empresa,:nombre, :nombre_factura, :direccion,1,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa',     $data['id_empresa']);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nombre_factura', $data['nombre_factura']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_sucursal/:id_empresa', 'cargar_sucursal');
function cargar_sucursal($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT s.id,s.id_empresa,s.nombre,s.nombre_factura
         ,s.direccion,s.latitud,s.longitud,s.estado
         from em_sucursal s
         where s.id_empresa=:id_empresa
         and s.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_empresa']       = trim($data['id_empresa']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['nombre_factura']   = trim($data['nombre_factura']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['latitud']          = trim($data['latitud']);
                $array[$i]['longitud']         = trim($data['longitud']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_sucursal_u/:id_sucursal', 'cargar_sucursal_u');
function cargar_sucursal_u($id_sucursal)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT s.id,s.id_empresa,s.nombre,s.nombre_factura
         ,s.direccion,s.latitud,s.longitud,s.estado
         from em_sucursal s
         where s.id=:id_sucursal
         and s.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_sucursal', $id_sucursal);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['id_empresa']       = trim($data['id_empresa']);
                $array['nombre']           = trim($data['nombre']);
                $array['nombre_factura']   = trim($data['nombre_factura']);
                $array['direccion']        = trim($data['direccion']);
                $array['latitud']          = trim($data['latitud']);
                $array['longitud']         = trim($data['longitud']);
                $array['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_sucursal', 'actualizar_sucursal');
function actualizar_sucursal()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_sucursal
                    set
                    nombre=:nombre, nombre_factura=:nombre_factura, direccion=:direccion
                    
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nombre_factura',            $data['nombre_factura']);
        $stmt->bindParam('direccion',    $data['direccion']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_sucursal', 'eliminar_sucursal');
function eliminar_sucursal()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_sucursal
                    set
                    estado=0
                    
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////// tabla_cliente
$app->post('/subir_clientes', 'subir_clientes');
function subir_clientes()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $hora = date('H:i:s');
        // $fecha_=$data['fecha_ingreso'].' '.$hora;
        $fechaReg = date('Y-m-d H:i:s');
        $error = 0;
        foreach ($data['detalle'] as $key => $value) {

            $sql = "INSERT INTO cli_cliente
                        (nombre, nit,correo, telefono,direccion,estado,fecha_reg,fecha_up,id_empresa)
                
                        VALUES 
                        (:nombre,:nit,:correo, :telefono, :direccion,1,:fecha_reg,:fecha_up,:id_empresa)";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('nombre',         $value['nombre']);
            $stmt->bindParam('nit',            $value['nit']);
            $stmt->bindParam('correo',         $value['correo']);
            $stmt->bindParam('telefono',       $value['telefono']);
            $stmt->bindParam('direccion',      $value['direccion']);
            $stmt->bindParam('id_empresa',      $data['id_empresa']);

            $stmt->bindParam('fecha_reg',      $fechaReg);
            $stmt->bindParam('fecha_up',       $fechaReg);

            $stmt->execute();
            $id = $db->lastInsertId();
            if ($stmt->rowCount() > 0) {
            } else {
                $error++;
            }
        }




        // $id=$db->lastInsertId();

        if ($error == 0) {
            $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            $db->rollBack();
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                            }';
        }



        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}



$app->post('/insertar_cliente', 'insertar_cliente');
function insertar_cliente()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO cli_cliente
                    (nombre, nit,correo, telefono,direccion,estado,fecha_reg,fecha_up,id_empresa)
            
                    VALUES 
                    (:nombre,:nit,:correo, :telefono, :direccion,1,:fecha_reg,:fecha_up,:id_empresa)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nit',            $data['nit']);
        $stmt->bindParam('correo',         $data['correo']);
        $stmt->bindParam('telefono',       $data['telefono']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id_empresa', $data['id_empresa']);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_cliente_chofer/:id_empresa', 'cargar_cliente_chofer');
function cargar_cliente_chofer($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre, nit, telefono,direccion,estado
         ,id_tipo_cliente,correo
         from cli_cliente 
         where  id_empresa=:id_empresa
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['nit']              = trim($data['nit']);
                $array[$i]['telefono']         = trim($data['telefono']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['id_tipo_cliente']  = trim($data['id_tipo_cliente']);
                $array[$i]['correo']           = trim($data['correo']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_cliente_chofer_u/:id_cliente', 'cargar_cliente_chofer_u');
function cargar_cliente_chofer_u($id_cliente)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre, nit, telefono,direccion,estado
         ,id_tipo_cliente
         from cli_cliente 
         where id=:id_cliente
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_cliente', $id_cliente);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['nombre']           = trim($data['nombre']);
                $array['nit']              = trim($data['nit']);
                $array['telefono']         = trim($data['telefono']);
                $array['direccion']        = trim($data['direccion']);
                $array['estado']           = trim($data['estado']);
                $array['id_tipo_cliente']  = trim($data['id_tipo_cliente']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_cliente_chofer', 'actualizar_cliente_chofer');
function actualizar_cliente_chofer()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE cli_cliente
                    set
                    nombre=:nombre, nit=:nit, telefono=:telefono
                    ,direccion=:direccion
                    ,correo=:correo
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nit',            $data['nit']);
        $stmt->bindParam('telefono',       $data['telefono']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('correo',         $data['correo']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_cliente_chofer', 'eliminar_cliente_chofer');
function eliminar_cliente_chofer()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE cli_cliente
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////tabla_proveedor
$app->post('/subir_proveedor', 'subir_proveedor');
function subir_proveedor()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $hora = date('H:i:s');
        // $fecha_=$data['fecha_ingreso'].' '.$hora;
        $fechaReg = date('Y-m-d H:i:s');
        $error = 0;
        foreach ($data['detalle'] as $key => $value) {

            $sql = "INSERT INTO in_proveedor
                        (nombre, nit,correo, telefono,direccion,estado,fecha_reg,fecha_up,id_empresa)
                
                        VALUES 
                        (:nombre,:nit,:correo, :telefono, :direccion,1,:fecha_reg,:fecha_up,:id_empresa)";
            $stmt = $db->prepare($sql);
            $stmt->bindParam('nombre',         $value['nombre']);
            $stmt->bindParam('nit',            $value['nit']);
            $stmt->bindParam('correo',         $value['correo']);
            $stmt->bindParam('telefono',       $value['telefono']);
            $stmt->bindParam('direccion',      $value['direccion']);
            $stmt->bindParam('id_empresa',      $data['id_empresa']);

            $stmt->bindParam('fecha_reg',      $fechaReg);
            $stmt->bindParam('fecha_up',       $fechaReg);

            $stmt->execute();
            $id = $db->lastInsertId();
            if ($stmt->rowCount() > 0) {
            } else {
                $error++;
            }
        }




        // $id=$db->lastInsertId();

        if ($error == 0) {
            $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            $db->rollBack();
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                            }';
        }



        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}

$app->post('/insertar_proveedor', 'insertar_proveedor');
function insertar_proveedor()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO in_proveedor
                    (nombre, nit,correo, telefono,direccion,estado,fecha_reg,fecha_up,id_empresa)
            
                    VALUES 
                    (:nombre,:nit,:correo, :telefono, :direccion,1,:fecha_reg,:fecha_up,:id_empresa)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nit',            $data['nit']);
        $stmt->bindParam('correo',         $data['correo']);
        $stmt->bindParam('telefono',       $data['telefono']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('id_empresa',      $data['id_empresa']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_proveedor/:id_empresa', 'cargar_proveedor');
function cargar_proveedor($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre, nit, telefono,direccion,estado
         ,correo
         from in_proveedor 
         where 
         id_empresa=:id_empresa
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['nit']              = trim($data['nit']);
                $array[$i]['telefono']         = trim($data['telefono']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['correo']           = trim($data['correo']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_proveedor_u/:id_pro', 'cargar_proveedor_u');
function cargar_proveedor_u($id_pro)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre, nit, telefono,direccion,estado
         from in_proveedor 
         where id=:id_pro
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_pro', $id_pro);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['nombre']           = trim($data['nombre']);
                $array['nit']              = trim($data['nit']);
                $array['telefono']         = trim($data['telefono']);
                $array['direccion']        = trim($data['direccion']);
                $array['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_proveedor', 'actualizar_proveedor');
function actualizar_proveedor()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE in_proveedor
                    set
                    nombre=:nombre, nit=:nit, telefono=:telefono
                    ,direccion=:direccion
                    ,fecha_up=:fecha_up
                    ,correo=:correo
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nit',            $data['nit']);
        $stmt->bindParam('telefono',       $data['telefono']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('correo',         $data['correo']);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_proveedor', 'eliminar_proveedor');
function eliminar_proveedor()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE in_proveedor
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////// tabla_almacen
$app->post('/insertar_almacen', 'insertar_almacen');
function insertar_almacen()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO em_almacen
                    (id_sucursal,nombre, descripcion, estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:id_sucursal,:nombre, :descripcion, 1,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_sucursal',         $data['id_sucursal']);
        $stmt->bindParam('nombre',            $data['nombre']);
        $stmt->bindParam('descripcion',       $data['descripcion']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_almacen/:id_sucursal', 'cargar_almacen');
function cargar_almacen($id_sucursal)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT a.id, a.nombre, a.descripcion,a.estado,a.id_sucursal
         ,s.nombre as sucursal
         from em_almacen a,em_sucursal s
         where a.id_sucursal=s.id 
         and s.id=:id_sucursal 
         and a.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_sucursal', $id_sucursal);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_almacen_todos/:id_empresa', 'cargar_almacen_todos');
function cargar_almacen_todos($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT a.id, a.nombre, a.descripcion,a.estado,a.id_sucursal
        ,s.nombre as sucursal
        from em_almacen a,em_sucursal s
        where a.id_sucursal=s.id 
        and s.id_empresa=:id_empresa
        and a.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_almacen_u/:id_almacen', 'cargar_almacen_u');
function cargar_almacen_u($id_almacen)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre, descripcion,estado
         from em_almacen
         where id=:id_almacen
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_almacen', $id_almacen);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']            = trim($data['id']);
                $array['nombre']        = trim($data['nombre']);
                $array['descripcion']   = trim($data['descripcion']);
                $array['estado']        = trim($data['estado']);




                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_almacen', 'actualizar_almacen');
function actualizar_almacen()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_almacen
                    set
                    nombre=:nombre, descripcion=:descripcion
                    ,id_sucursal=:id_sucursal
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('descripcion',    $data['descripcion']);
        $stmt->bindParam('id_sucursal',    $data['id_sucursal']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_almacen', 'eliminar_almacen');
function eliminar_almacen()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE em_almacen
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////// tabla_colonia
$app->post('/insertar_colonia', 'insertar_colonia');
function insertar_colonia()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO colonia
                    (id_campo,nombre,direccion, descripcion, estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:id_campo,:nombre,:direccion, :descripcion, 1,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_campo',         $data['id_campo']);
        $stmt->bindParam('nombre',            $data['nombre']);
        $stmt->bindParam('direccion',          $data['direccion']);
        $stmt->bindParam('descripcion',       $data['descripcion']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_colonias', 'cargar_colonias');
function cargar_colonias()
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT c.id,c.id_campo, c.nombre,c.direccion, c.descripcion,c.estado
         ,ca.nombre as campo
         from colonia c,campo ca
         where c.id_campo=ca.id
         and ca.estado=1
         and c.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_campo', $id_campo);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_campo']         = trim($data['id_campo']);
                $array[$i]['campo']            = trim($data['campo']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_colonia/:id_campo', 'cargar_colonia');
function cargar_colonia($id_campo)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id,id_campo, nombre,direccion, descripcion,estado
         from colonia
         where id_campo=:id_campo
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_campo', $id_campo);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_campo']         = trim($data['id_campo']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_colonia_u/:id', 'cargar_colonia_u');
function cargar_colonia_u($id)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id,id_campo, nombre,direccion, descripcion,estado
         from colonia
         where id=:id
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['id_campo']         = trim($data['id_campo']);
                $array['nombre']           = trim($data['nombre']);
                $array['direccion']        = trim($data['direccion']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['estado']           = trim($data['estado']);




                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_colonia', 'actualizar_colonia');
function actualizar_colonia()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE colonia
                    set
                    nombre=:nombre,direccion=:direccion, descripcion=:descripcion
                    ,id_campo=:id_campo
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('descripcion',    $data['descripcion']);
        $stmt->bindParam('id_campo',    $data['id_campo']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_colonia', 'eliminar_colonia');
function eliminar_colonia()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE colonia
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////// tabla_campo
$app->post('/insertar_campo', 'insertar_campo');
function insertar_campo()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO campo
                    (nombre,direccion, descripcion, estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:nombre,:direccion, :descripcion, 1,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',            $data['nombre']);
        $stmt->bindParam('direccion',          $data['direccion']);
        $stmt->bindParam('descripcion',       $data['descripcion']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_campo', 'cargar_campo');
function cargar_campo()
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre,direccion, descripcion,estado
         from campo
         where 
         estado=1";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_campo_u/:id', 'cargar_campo_u');
function cargar_campo_u($id)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre,direccion, descripcion,estado
         from campo
         where id=:id
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['nombre']           = trim($data['nombre']);
                $array['direccion']        = trim($data['direccion']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['estado']           = trim($data['estado']);




                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_campo', 'actualizar_campo');
function actualizar_campo()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE campo
                    set
                    nombre=:nombre,direccion=:direccion, descripcion=:descripcion
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('descripcion',    $data['descripcion']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_campo', 'eliminar_campo');
function eliminar_campo()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE campo
                    
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////// tabla_producto
$app->post('/insertar_producto', 'insertar_producto');
function insertar_producto()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());
        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO pro_producto
                    (codigo,nombre, descripcion,tamano,peso,precio,foto
                    ,precio_2,precio_paquete,cod_barra,marca,caracteristica
                    ,grupo_familia,costo,stock_min,fecha_vencimiento
                    ,id_empresa
                    ,estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:codigo,:nombre, :descripcion,:tamano,:peso,:precio,:foto
                    ,:precio_2,:precio_paquete,:cod_barra,:marca,:caracteristica
                    ,:grupo_familia,:costo,:stock_min,:fecha_vencimiento
                    ,:id_empresa
                    ,1,:fecha_reg,:fecha_up)
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('codigo',             $data['codigo']);
        $stmt->bindParam('nombre',             $data['nombre']);
        $stmt->bindParam('descripcion',        $data['descripcion']);
        // $stmt ->bindParam('id_subcategoria',    $data['id_subcategoria']);
        $stmt->bindParam('tamano',             $data['tamano']);
        $stmt->bindParam('peso',               $data['peso']);
        $stmt->bindParam('precio',             $data['precio']);
        $stmt->bindParam('precio_2',           $data['precio_mayor']);
        $stmt->bindParam('precio_paquete',     $data['precio_paquete']);
        $stmt->bindParam('cod_barra',          $data['cod_barra']);
        $stmt->bindParam('marca',              $data['marca']);
        $stmt->bindParam('caracteristica',     $data['caracteristica']);
        $stmt->bindParam('grupo_familia',      $data['grupo_familia']);
        $stmt->bindParam('costo',              $data['costo']);
        $stmt->bindParam('stock_min',          $data['stock_min']);
        $stmt->bindParam('fecha_vencimiento',  $data['fecha_vencimiento']);
        $stmt->bindParam('id_empresa',         $data['id_empresa']);
        $stmt->bindParam('fecha_reg',          $fechaReg);
        $stmt->bindParam('fecha_up',           $fechaReg);
        if ($data['foto'] != 'sin_imagen') {
            $imagen = imageProducto($data['foto'], $data['id_empresa'], 'producto');
            $stmt->bindParam('foto',           $imagen);
        } else {
            $stmt->bindParam('foto',  $data['foto']);
        }
        //echo $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            if ($data['foto'] != 'sin_imagen') {
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . ',
                            "imagen": "' . $imagen . '"
                        }';
            } else {
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . ',
                            "imagen": "sin_imagen"
                        }';
            }
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/subir_productos', 'subir_productos');
function subir_productos()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $hora = date('H:i:s');
        // $fecha_=$data['fecha_ingreso'].' '.$hora;
        $sql = "INSERT INTO in_ingreso
                    (fecha_ingreso, id_sucursal,id_proveedor,costo,id_tipo_ingreso
                    ,estado,fecha_reg
                    ,id_usuario)
            
                    VALUES 
                    (:fecha_ingreso, :id_sucursal,0,:costo,1
                    ,1,:fecha_reg
                    ,:id_usuario)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ingreso',  $fechaReg);
        $stmt->bindParam('id_sucursal',    $data['id_sucursal']);
        $stmt->bindParam('costo',          $data['costo']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('id_usuario',     $data['id_usuario']);

        $stmt->execute();
        $id = $db->lastInsertId();
        $error = 0;


        // $id=$db->lastInsertId();
        $error = 0;
        if ($stmt->rowCount() > 0) {
            foreach ($data['detalle'] as $key => $value) {
                # code...

                $id_producto = crear_productos($data['id_empresa'], $value, $db);
                if (!$id_producto) {
                    $error++;
                }

                //  echo json_encode($value);

                if (!$value['lote']) {
                    throw new PDOException('Falta lote', 403);
                }
                if (!$value['fecha_vencimiento']) {
                    throw new PDOException('Falta fecha vencimiento', 403);
                }
                if (!$value['costo_lote']) {
                    throw new PDOException('Falta costo lote', 403);
                }
                if (!$value['stock']) {
                    throw new PDOException('Falta stock', 403);
                }
                $id_det_ingreso = crear_det_ingreso($id, $id_producto, $value['costo_lote'], $value['stock'], $value['lote'], $value['fecha_vencimiento'], $data['id_almacen'], $db);
                if (!$id_det_ingreso) {
                    $error++;
                }
                $inv = crear_inventario($id_producto, $value['stock'], $id_det_ingreso, $data['id_almacen'], $db);
                if (!$inv) {
                    $error++;
                }
            }

            if ($error == 0) {
                $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
            } else {
                $db->rollBack();
                echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                            }';
            }
        } else {
            $db->rollBack();

            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo ' {
                    "errorCode": 3,
                    "errorMessage": "Error al ejecutar el servicio web.",
                    "msg": "' . $e->getMessage() . '"
                }';
    }
}
function crear_inventario($id_producto, $stock, $id_detalle, $id_almacen, $db)
{
    try {

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO in_inventario
        (id_det_ingreso, id_producto,id_almacen, cantidad, estado, fecha_reg,fecha_up)

        VALUES 
        (:id_det_ingreso, :id_producto,:id_almacen, :cantidad,1,  :fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_det_ingreso', $id_detalle);
        $stmt->bindParam('id_producto',    $id_producto);
        $stmt->bindParam('id_almacen',     $id_almacen);
        $stmt->bindParam('cantidad',       $stock);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
function crear_det_ingreso($id_ingreso, $id_producto, $costo, $cantidad, $lote, $fecha_v, $id_almacen, $db)
{

    try {
        // echo json_encode($data);
        $date = new DateTime($fecha_v);
        $fechaReg = $date->format('Y-m-d');
        $sql = "INSERT INTO in_det_ingreso
            (id_ingreso,lote, id_producto, cantidad, costo, fecha_vencimiento,id_almacen)
    
            VALUES 
            (:id_ingreso,:lote, :id_producto, :cantidad, :costo, :fecha_vencimiento,:id_almacen)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_ingreso',     $id_ingreso);
        $stmt->bindParam('lote',           $lote);
        $stmt->bindParam('id_producto',    $id_producto);
        $stmt->bindParam('cantidad',       $cantidad);
        $stmt->bindParam('costo',          $costo);
        $stmt->bindParam('fecha_vencimiento',  $fechaReg);
        $stmt->bindParam('id_almacen',     $id_almacen);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return $id;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
function crear_productos($id_empresa, $value, $db)
{
    try {


        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO pro_producto
            (codigo,nombre, descripcion,tamano,peso,precio
            ,precio_2,precio_paquete,cod_barra,marca,caracteristica
            ,grupo_familia,costo,stock_min
            ,id_empresa
            ,estado,fecha_reg,fecha_up)
    
            VALUES 
            (:codigo,:nombre, :descripcion, :tamano,:peso,:precio
            ,:precio_2,:precio_paquete,:cod_barra,:marca,:caracteristica
            ,:grupo_familia,:costo,:stock_min
            ,:id_empresa
            ,1,:fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('codigo',             $value['codigo']);
        $stmt->bindParam('nombre',             $value['nombre']);
        $stmt->bindParam('descripcion',        $value['descripcion']);
        // $stmt ->bindParam('id_subcategoria',    $data['id_subcategoria']);
        $stmt->bindParam('tamano',             $value['tamahno']);
        $stmt->bindParam('peso',               $value['peso']);
        $stmt->bindParam('precio',             $value['precio']);
        $stmt->bindParam('fecha_reg',          $fechaReg);
        $stmt->bindParam('fecha_up',           $fechaReg);

        $stmt->bindParam('precio_2',           $value['precio_2']);
        $stmt->bindParam('precio_paquete',     $value['precio_paquete']);
        $stmt->bindParam('cod_barra',          $value['codigo_barra']);
        $stmt->bindParam('marca',              $value['marca']);
        $stmt->bindParam('caracteristica',     $value['caracteristica']);
        $stmt->bindParam('grupo_familia',      $value['grupo_familia']);
        $stmt->bindParam('costo',              $value['costo']);

        $stmt->bindParam('stock_min',          $value['stock_min']);

        $stmt->bindParam('id_empresa',         $id_empresa);
        // echo $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
        $stmt->execute();
        $id = $db->lastInsertId();
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            return $id;
        } else {
            return false;
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                "errorCode": 3,
                "errorMessage": "Error al ejecutar el servicio web.",
                "msg": 0
            }';
    }
}
$app->get('/cargar_productos/:id_empresa', 'cargar_productos');
function cargar_productos($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, codigo,nombre, descripcion
         ,id_tipo,id_subcategoria,tamano,peso,precio
         ,precio_2,precio_paquete,cod_barra,marca,caracteristica
         ,grupo_familia,costo,costo_paquete,stock_min,fecha_vencimiento
         ,foto
         ,estado
         from pro_producto
         where
         id_empresa=:id_empresa 
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['codigo']           = trim($data['codigo']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['id_tipo']          = trim($data['id_tipo']);
                $array[$i]['id_subcategoria']  = trim($data['id_subcategoria']);
                $array[$i]['tamano']           = trim($data['tamano']);
                $array[$i]['peso']             = trim($data['peso']);
                $array[$i]['precio']           = trim($data['precio']);
                $array[$i]['precio_2']         = trim($data['precio_2']);
                $array[$i]['precio_paquete']   = trim($data['precio_paquete']);
                $array[$i]['cod_barra']        = trim($data['cod_barra']);
                $array[$i]['marca']            = trim($data['marca']);
                $array[$i]['caracteristica']   = trim($data['caracteristica']);
                $array[$i]['grupo_familia']    = trim($data['grupo_familia']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['costo_paquete']    = trim($data['costo_paquete']);
                $array[$i]['stock_min']        = trim($data['stock_min']);
                $array[$i]['fecha_vencimiento'] = trim($data['fecha_vencimiento']);
                $array[$i]['foto']             = trim($data['foto']);
                $i++;
            }
            $almacen = cargar_almacen_productos($id_empresa, $db);
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . ',
                "almacen": ' . json_encode($almacen) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_almacen_productos($id_empresa, $db)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT a.id, a.nombre, a.descripcion,a.estado,a.id_sucursal
         ,s.nombre as sucursal
         from em_almacen a,em_sucursal s
         where a.id_sucursal=s.id 
         and s.id_empresa=:id_empresa 
         and a.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            return $array;
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_producto_u/:id', 'cargar_producto_u');
function cargar_producto_u($id)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, codigo,nombre, descripcion, id_tipo,id_subcategoria,tamano,peso,precio
         ,precio_2,precio_paquete,cod_barra,marca,caracteristica
        ,grupo_familia,costo,costo_paquete,stock_min,fecha_vencimiento
         ,estado
         from pro_producto
         where id=:id
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['codigo']           = trim($data['codigo']);
                $array['nombre']           = trim($data['nombre']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['id_tipo']          = trim($data['id_tipo']);
                $array['id_subcategoria']  = trim($data['id_subcategoria']);
                $array['tamano']           = trim($data['tamano']);
                $array['peso']             = trim($data['peso']);
                $array['precio']           = trim($data['precio']);
                $array['precio_2']         = trim($data['precio_2']);
                $array['precio_paquete']   = trim($data['precio_paquete']);
                $array['cod_barra']        = trim($data['cod_barra']);
                $array['marca']            = trim($data['marca']);
                $array['caracteristica']   = trim($data['caracteristica']);
                $array['grupo_familia']    = trim($data['grupo_familia']);
                $array['costo']            = trim($data['costo']);
                $array['costo_paquete']    = trim($data['costo_paquete']);
                $array['stock_min']        = trim($data['stock_min']);
                $array['fecha_vencimiento'] = trim($data['fecha_vencimiento']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_producto', 'actualizar_producto');
function actualizar_producto()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());
        $imagen = '';
        if ($data['foto'] != "sin_imagen") {
            $imagen = ',foto=:foto';
        }
        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE pro_producto
                    set
                    codigo=:codigo,nombre=:nombre
                    ,descripcion=:descripcion
                    ,id_subcategoria=:id_subcategoria,tamano=:tamano
                    ,peso=:peso,precio=:precio
                    ,precio_2=:precio_2,precio_paquete=:precio_paquete
                    ,cod_barra=:cod_barra,marca=:marca
                    ,caracteristica=:caracteristica
                    ,grupo_familia=:grupo_familia,costo=:costo
                    ,stock_min=:stock_min
                    ,fecha_vencimiento=:fecha_vencimiento

                    $imagen
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('codigo',             $data['codigo']);
        $stmt->bindParam('nombre',             $data['nombre']);
        $stmt->bindParam('descripcion',        $data['descripcion']);
        $stmt->bindParam('id_subcategoria',    $data['id_subcategoria']);
        $stmt->bindParam('tamano',             $data['tamano']);
        $stmt->bindParam('peso',               $data['peso']);
        $stmt->bindParam('precio',             $data['precio']);
        $stmt->bindParam('precio_2',           $data['precio_2']);
        $stmt->bindParam('precio_paquete',     $data['precio_paquete']);
        $stmt->bindParam('cod_barra',          $data['cod_barra']);
        $stmt->bindParam('marca',              $data['marca']);
        $stmt->bindParam('caracteristica',     $data['caracteristica']);
        $stmt->bindParam('grupo_familia',      $data['grupo_familia']);
        $stmt->bindParam('costo',              $data['costo']);
        $stmt->bindParam('stock_min',          $data['stock_min']);
        $stmt->bindParam('fecha_vencimiento',  $data['fecha_vencimiento']);
        $stmt->bindParam('fecha_up',           $fechaReg);
        $stmt->bindParam('id',                 $data['id']);
        if ($data['foto'] != 'sin_imagen') {
            $imagen = imageProducto($data['foto'], $data['id_empresa'], 'producto');
            $stmt->bindParam('foto',           $imagen);
        }
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            if ($data['foto'] == 'sin_imagen') {
                echo ' {
                                "errorCode": 0,
                                "errorMessage": "Servicio ejecutado correctamente.",
                                "msg": "' . $data['foto'] . '"
                            }';
            } else {
                echo ' {
                                "errorCode": 0,
                                "errorMessage": "Servicio ejecutado correctamente.",
                                "msg": "' . $imagen . '"
                            }';
            }

            //  $db->commit();

        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_producto', 'eliminar_producto');
function eliminar_producto()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE pro_producto
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////tabla_responsable
$app->post('/insertar_responsable', 'insertar_responsable');
function insertar_responsable()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO responsable_colonia
                    (id_colonia,nombre, nit,direccion, telefono,correo,estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:id_colonia,:nombre,:nit,:direccion,:telefono,:correo,1,:fecha_reg,:fecha_up)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_colonia',     $data['id_colonia']);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nit',            $data['nit']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('telefono',       $data['telefono']);
        $stmt->bindParam('correo',         $data['correo']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_responsable', 'cargar_responsable');
function cargar_responsable()
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT r.id, r.id_colonia,r.nombre, r.nit,r.direccion, r.telefono,r.correo,r.estado
         ,c.nombre as colonia
         from responsable_colonia r,colonia c
         where r.id_colonia=c.id
            and r.estado=1
            ";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_colonia']       = trim($data['id_colonia']);
                $array[$i]['colonia']          = trim($data['colonia']);

                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['nit']              = trim($data['nit']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['telefono']         = trim($data['telefono']);
                $array[$i]['correo']           = trim($data['correo']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_responsable_colonia/:id_colonia', 'cargar_responsable_colonia');
function cargar_responsable_colonia($id_colonia)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT r.id, r.id_colonia,r.nombre, r.nit,r.direccion, r.telefono,r.correo,r.estado
         ,c.nombre as colonia
         from responsable_colonia r,colonia c
         where r.id_colonia=c.id
            and r.estado=1
            and c.id_campo=:id_colonia";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_colonia', $id_colonia);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_colonia']       = trim($data['id_colonia']);
                $array[$i]['colonia']          = trim($data['colonia']);

                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['nit']              = trim($data['nit']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['telefono']         = trim($data['telefono']);
                $array[$i]['correo']           = trim($data['correo']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_responsable_u/:id_pro', 'cargar_responsable_u');
function cargar_responsable_u($id_pro)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, id_colonia,nombre, nit, telefono,direccion,correo,estado
         from responsable_colonia 
         where id=:id_pro
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_pro', $id_pro);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['id_colonia']       = trim($data['id_colonia']);
                $array['nombre']           = trim($data['nombre']);
                $array['nit']              = trim($data['nit']);
                $array['telefono']         = trim($data['telefono']);
                $array['direccion']        = trim($data['direccion']);
                $array['correo']           = trim($data['correo']);
                $array['estado']           = trim($data['estado']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_responsable', 'actualizar_responsable');
function actualizar_responsable()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE responsable_colonia
                    set
                    nombre=:nombre, nit=:nit, telefono=:telefono
                    ,direccion=:direccion
                    ,correo=:correo
                    ,id_colonia=:id_colonia
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('nit',            $data['nit']);
        $stmt->bindParam('telefono',       $data['telefono']);
        $stmt->bindParam('direccion',      $data['direccion']);
        $stmt->bindParam('correo',         $data['correo']);
        $stmt->bindParam('id_colonia',     $data['id_colonia']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_responsable', 'eliminar_responsable');
function eliminar_responsable()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE responsable_colonia
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
///tabla_ingreso
$app->post('/insertar_ingreso', 'insertar_ingreso');
function insertar_ingreso()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $hora = date('H:i:s');
        $fecha_ = $data['fecha_ingreso'] . ' ' . $hora;
        $almacen = $data['id_almacen'];
        $sucursal = $data['id_sucursal'];
        if (!$almacen || $almacen == 0 && !$sucursal || $sucursal == 0) {
            throw new PDOException('Faltan parametros', 400);
        }
        $sql = "INSERT INTO in_ingreso
                    (fecha_ingreso, id_sucursal,id_proveedor,costo,id_tipo_ingreso,descripcion
                    ,estado,fecha_reg
                    ,id_usuario
                    ,saldo)
            
                    VALUES 
                    (:fecha_ingreso, :id_sucursal,:id_proveedor,:costo,:id_tipo_ingreso,:descripcion
                    ,1,:fecha_reg
                    ,:id_usuario
                    ,:saldo)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ingreso',  $fecha_);
        $stmt->bindParam('id_sucursal',    $data['id_sucursal']);
        $stmt->bindParam('id_proveedor',   $data['id_proveedor']);
        $stmt->bindParam('costo',          $data['costo']);
        $stmt->bindParam('id_tipo_ingreso',    $data['id_tipo_ingreso']);
        $stmt->bindParam('descripcion',    $data['descripcion']);
        $stmt->bindParam('fecha_reg',      $fecha_);
        $stmt->bindParam('id_usuario',     $data['id_usuario']);
        $stmt->bindParam('saldo',          $data['saldo']);
        $stmt->execute();
        $id = $db->lastInsertId();
        $error = 0;
        if ($stmt->rowCount() > 0) {
            foreach ($data['productos'] as $key => $value) {

                $id_detalle = insertar_ingreso_detalle($db, $value, $id);
                if (!$id_detalle) {
                    $error++;
                } else {
                    $inventario = insertar_inventario($db, $value, $id_detalle, $value['id_almacen']);
                    if (!$inventario) {
                        $error++;
                    }
                }
            }
            if ($error == 0) {
                $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '

                        }';
            } else {
                $db->rollback();
                echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
            }
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db->rollback();
        $db = null;
        $stmt = null;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": ' . json_encode($e) . '
                    }';
    }
}
function insertar_ingreso_detalle($db, $data, $id_ingreso)
{

    try {
        // echo json_encode($data);
        $fechaReg = date('Y-m-d H:i:s');
        $costo_uni = $data['costo'] / $data['cantidad'];
        $sql = "INSERT INTO in_det_ingreso
                    (id_ingreso,lote, id_producto, cantidad, costo,costo_uni, fecha_vencimiento,id_almacen)
            
                    VALUES 
                    (:id_ingreso,:lote, :id_producto, :cantidad,:costo,:costo_uni, :fecha_vencimiento,:id_almacen)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_ingreso',     $id_ingreso);
        $stmt->bindParam('lote',           $data['lote']);
        $stmt->bindParam('id_producto',    $data['id_producto']);
        $stmt->bindParam('cantidad',       $data['cantidad']);
        $stmt->bindParam('costo',          $data['costo']);
        $stmt->bindParam('costo_uni',          $costo_uni);
        $stmt->bindParam('fecha_vencimiento',  $data['fecha_vencimiento']);
        $stmt->bindParam('id_almacen',     $data['id_almacen']);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return $id;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
function insertar_inventario($db, $data, $id_detalle, $id_almacen)
{
    try {

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO in_inventario
        (id_det_ingreso, id_producto,id_almacen, cantidad, estado, fecha_reg,fecha_up)

        VALUES 
        (:id_det_ingreso, :id_producto,:id_almacen, :cantidad,1,  :fecha_reg,:fecha_up)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_det_ingreso', $id_detalle);
        $stmt->bindParam('id_producto',    $data['id_producto']);
        $stmt->bindParam('id_almacen',     $id_almacen);
        $stmt->bindParam('cantidad',       $data['cantidad']);
        $stmt->bindParam('fecha_reg',      $fechaReg);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
//funciones_ingreso
$app->get('/cargar_compras/:id_empresa/:fecha_ini/:fecha_fin/:tipo_ingreso', 'cargar_compras');
function cargar_compras($id_empresa, $fecha_ini, $fecha_fin, $tipo_ingreso)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT i.id,i.fecha_ingreso,i.id_sucursal,s.nombre as sucursal,i.costo
         ,i.descripcion
         ,u.nombre as usuario
         ,i.saldo
         from in_ingreso i,em_sucursal s,per_usuarios u
         where i.id_sucursal=s.id
         and s.id_empresa=:id_empresa
         and i.id_usuario=u.id
         and i.estado=1
         and i.id_tipo_ingreso=:tipo_ingreso
         and date(i.fecha_ingreso) between :fecha_ini  and :fecha_fin
         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->bindParam('tipo_ingreso', $tipo_ingreso);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['fecha_ingreso']    = trim($data['fecha_ingreso']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['saldo']            = trim($data['saldo']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['usuario']          = trim($data['usuario']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_compras_id/:id', 'cargar_compras_id');
function cargar_compras_id($id)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT i.id, i.fecha_ingreso, i.id_sucursal,i.id_proveedor
                ,i.id_viaje,i.costo,i.descripcion,i.estado
                ,s.nombre as sucursal,p.nombre as proveedor
                ,i.nro_facturacion,i.nro_deposito,i.fecha_reg
                FROM in_ingreso i,em_sucursal s,in_proveedor p
                WHERE i.id_sucursal=s.id 
                AND i.id_proveedor=p.id
                AND i.estado=1 
                AND i.id=:id";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['fecha_ingreso']    = trim($data['fecha_ingreso']);
                $array['id_sucursal']      = trim($data['id_sucursal']);
                $array['id_proveedor']     = trim($data['id_proveedor']);
                $array['id_viaje']         = trim($data['id_viaje']);
                $array['costo']            = trim($data['costo']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['estado']           = trim($data['estado']);
                $array['sucursal']         = trim($data['sucursal']);
                $array['proveedor']        = trim($data['proveedor']);
                $array['nro_facturacion']  = trim($data['nro_facturacion']);
                $array['nro_deposito']     = trim($data['nro_deposito']);
                $array['fecha_reg']        = trim($data['fecha_reg']);

                $array['detalle']          = cargar_detalle_compra($id, $db);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_detalle_compra($id_ingreso, $db)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT di.id, di.id_producto,di.costo,di.cantidad
         ,p.codigo,p.nombre
         ,a.nombre as almacen
         from in_det_ingreso di,pro_producto p,em_almacen a
         where  di.id_producto=p.id
         and di.id_almacen=a.id
        AND di.id_ingreso=:id_ingreso";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_ingreso', $id_ingreso);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_producto']    = trim($data['id_producto']);
                $array[$i]['codigo']         = trim($data['codigo']);
                $array[$i]['nombre']         = trim($data['nombre']);
                $array[$i]['costo']          = trim($data['costo']);
                $array[$i]['cantidad']       = trim($data['cantidad']);
                $array[$i]['almacen']        = trim($data['almacen']);
                $i++;
            }
            return $array;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
$app->post('/eliminar_compra', 'eliminar_compra');
function eliminar_compra()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE in_ingreso
                    set
                    
                    estado=0
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('id',             $data['id']);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            $eliminar_detalle = inventario_eliminar_compra($db, $data['id']);
            if ($eliminar_detalle) {
                $db->commit();
                echo ' {
                                "errorCode": 0,
                                "errorMessage": "Servicio ejecutado correctamente."
                            }';
            } else {
                $db->rollBack();
                echo ' {
                                "errorCode": 2,
                                "errorMessage": "error eliminar detalle."
                            }';
            }
        } else {
            $db->rollBack();

            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function inventario_eliminar_compra($db, $id_ingreso)
{

    try {
        // echo json_encode($data);
        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE in_inventario inv
            join in_det_ingreso di
            on di.id=inv.id_det_ingreso
            and di.id_almacen=inv.id_almacen
            and di.id_ingreso=:id_ingreso
            set inv.cantidad=inv.cantidad-di.cantidad
            ,inv.estado=0;";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_ingreso',     $id_ingreso);


        $stmt->execute();

        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
//tabla_pago_compra
$app->get('/cargar_pago_compra/:id_compra', 'cargar_pago_compra');
function cargar_pago_compra($id_compra)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT pv.id,pv.id_compra,pv.fecha_pago,pv.monto,pv.nombre
         ,pv.ci,pv.nota,v.saldo
         from pagos_compra pv,in_ingreso v
         where pv.id_compra=:id_compra
         and pv.id_compra=v.id
         and pv.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_compra', $id_compra);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_compra']         = trim($data['id_compra']);
                $array[$i]['fecha_pago']       = trim($data['fecha_pago']);
                $array[$i]['monto']            = trim($data['monto']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['ci']               = trim($data['ci']);
                $array[$i]['nota']             = trim($data['nota']);
                $array[$i]['saldo']            = trim($data['saldo']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_pago_compra_id/:id_venta', 'cargar_pago_compra_id');
function cargar_pago_compra_id($id_compra)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "  SELECT pv.id,pv.fecha_pago,pv.monto,pv.nombre,.pv.ci,pv.nota
         ,v.costo,v.saldo,v.fecha_ingreso,v.id as id_venta
         
         from pagos_compra pv,in_ingreso v
         where pv.id_compra=v.id
         and pv.id=:id_compra";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_compra', $id_compra);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']                = trim($data['id']);
                $array['fecha_pago']        = trim($data['fecha_pago']);
                $array['monto']             = trim($data['monto']);
                $array['nombre']            = trim($data['nombre']);
                $array['ci']                = trim($data['ci']);
                $array['nota']              = trim($data['nota']);
                $array['total']             = trim($data['costo']);
                $array['saldo']             = trim($data['saldo']);
                $array['fecha_venta']       = trim($data['fecha_ingreso']);
                $array['id_venta']          = trim($data['id_venta']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/guardar_pago_compra', 'guardar_pago_compra');
function guardar_pago_compra()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $horaReg = $data['fecha_pago'] . ' ' . date('H:i:s');
        $sql = "INSERT INTO pagos_compra
            (id_usuario,id_compra,fecha_pago,monto,nombre, ci, nota,estado,fecha_reg,fecha_up)
    
            VALUES 
            (:id_usuario,:id_venta,:fecha_pago,:monto,:nombre,:ci,:nota,1,:fecha_reg,:fecha_up)";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario',          $data['id_usuario']);
        $stmt->bindParam('id_venta',          $data['id_venta']);
        $stmt->bindParam('fecha_pago',        $horaReg);
        $stmt->bindParam('monto',             $data['monto']);
        $stmt->bindParam('nombre',            $data['nombre']);
        $stmt->bindParam('ci',                $data['ci']);
        $stmt->bindParam('nota',              $data['nota']);
        $stmt->bindParam('fecha_reg',              $fechaReg);
        $stmt->bindParam('fecha_up',               $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            actualizar_saldo_compra($db, $data['monto'], $data['id_venta'], 1);
            //  $db->commit();
            echo ' {
                    "errorCode": 0,
                    "errorMessage": "Servicio ejecutado correctamente.",
                    "msg": ' . $id . '
                }';
        } else {
            echo ' {
                    "errorCode": 2,
                    "errorMessage": "Error de servicio."
                }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                "errorCode": 3,
                "errorMessage": "Error al ejecutar el servicio web.",
                "msg": 0
            }';
    }
}

$app->post('/eliminar_pago_compra', 'eliminar_pago_compra');
function eliminar_pago_compra()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE pagos_compra
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            actualizar_saldo_compra($db, $data['monto'], $data['id_venta'], 2);

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function actualizar_saldo_compra($db, $monto, $id_venta, $tipo)
{
    try {


        $fechaReg = date('Y-m-d H:i:s');
        if ($tipo == 1) {
            $sql = "UPDATE  in_ingreso
            set
            saldo=saldo-:monto,
            fecha_up=:fecha_up
            where id=:id_venta";
        } else {
            $sql = "UPDATE  in_ingreso
            set
            saldo=saldo+:monto,
            fecha_up=:fecha_up
            where id=:id_venta";
        }


        $stmt = $db->prepare($sql);
        $stmt->bindParam('monto',             $monto);
        $stmt->bindParam('fecha_up',              $fechaReg);
        $stmt->bindParam('id_venta',              $id_venta);
        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}

///tabla_venta
$app->get('/cargar_funciones_ventas/:id_empresa', 'cargar_funciones_ventas');
function cargar_funciones_ventas($id_empresa)
{
    $db = Config::getConnection();
    $array['sucursal'] = cargar_sucursal_ventas($id_empresa, $db);
    $array['cliente'] = cargar_cliente($id_empresa, $db);
    echo '{
        "errorCode": 0,
        "errorMessage": "Servicio ejecutado con exito",
        "msg": ' . json_encode($array) . '
    }';
}
function cargar_sucursal_ventas($id_empresa, $db)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT s.id,s.id_empresa,s.nombre,s.nombre_factura
         ,s.direccion,s.latitud,s.longitud,s.estado
         from em_sucursal s
         where s.id_empresa=:id_empresa
         and s.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_empresa']       = trim($data['id_empresa']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['nombre_factura']   = trim($data['nombre_factura']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['latitud']          = trim($data['latitud']);
                $array[$i]['longitud']         = trim($data['longitud']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['almacenes']            = cargar_almacen_venta($data['id'], $db);


                $i++;
            }
            return ($array);
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_almacen_venta($id_sucursal, $db)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT a.id, a.nombre, a.descripcion,a.estado,a.id_sucursal
         ,s.nombre as sucursal
         from em_almacen a,em_sucursal s
         where a.id_sucursal=s.id 
         and s.id=:id_sucursal 
         and a.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_sucursal', $id_sucursal);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);



                $i++;
            }
            return ($array);
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_cliente($id_empresa, $db)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre, nit, telefono,direccion,estado
         ,correo
         from cli_cliente 
         where  id_empresa=:id_empresa
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['nit']              = trim($data['nit']);
                $array[$i]['telefono']         = trim($data['telefono']);
                $array[$i]['direccion']        = trim($data['direccion']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['correo']           = trim($data['correo']);



                $i++;
            }
            return ($array);
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/insertar_venta', 'insertar_venta');
function insertar_venta()
{
    $eventoRegistrado = new \App\ServiciosSiat\EventoSignificativoService();
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $res = $eventoRegistrado->getEventExists(false);
        print_r(json_encode($res));
        $evento_significativo_id = -1;
        if (isset($res['CodigoDesc'])) {
            $evento_significativo_id = $res['codigoDesc'];
        }
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $hora = date('H:i:s');
        $fecha_ = $data['fecha_venta'] . ' ' . $hora;

        $sql = "INSERT INTO venta
                    ( id_sucursal,id_cliente,fecha_venta
                    ,tipo_venta,total,estado,saldo,nota
                    ,fecha_reg,fecha_up,id_usuario,descuento,tipo_pago,tarjeta,es_paquete,cambio)
            
                    VALUES
                    ( :id_sucursal,:id_cliente,:fecha_venta
                    ,:tipo_venta,:total,:estado,:saldo,:nota
                    ,:fecha_reg,:fecha_up,:id_usuario,:descuento,:tipo_pago,:tarjeta,:es_paquete,:cambio)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_sucursal',   $data['id_sucursal']);
        $stmt->bindParam('id_cliente',    $data['id_cliente']);
        $stmt->bindParam('fecha_venta',   $fecha_);
        $stmt->bindParam('tipo_venta',    $data['tipo_venta']);
        $stmt->bindParam('total',         $data['total']);
        $stmt->bindParam('estado',        $data['estado']);
        $stmt->bindParam('saldo',         $data['saldo']);
        $stmt->bindParam('nota',          $data['nota']);
        $stmt->bindParam('fecha_reg',     $fecha_);
        $stmt->bindParam('fecha_up',      $fecha_);
        $stmt->bindParam('id_usuario',    $data['id_usuario']);
        $stmt->bindParam('descuento',     $data['descuento']);
        $stmt->bindParam('tipo_pago',         $data['tipo_pago']);
        $stmt->bindParam('tarjeta',         $data['tarjeta']);
        $stmt->bindParam('es_paquete',         $data['es_paquete']);
        $stmt->bindParam('cambio',         $data['cambio']);
        $stmt->bindParam('evento_significativo_id',         $evento_significativo_id);

        $stmt->execute();
        $id = $db->lastInsertId();
        $error = 0;
        if ($stmt->rowCount() > 0) {
            foreach ($data['productos'] as $key => $value) {
                $cantidad = $value['cantidad'];
                while ($cantidad > 0) {
                    $producto_inventario = cargar_Inv_Producto_Cantidad($db, $value['id_producto'], $value['id_almacen'], 1, 1);
                    if ($producto_inventario) {
                        for ($i = 0; $i < count($producto_inventario); $i++) {
                            if ($cantidad >= $producto_inventario[$i]['cantidad']) {
                                $cantidad = $cantidad - $producto_inventario[$i]['cantidad'];
                                $det_ = insertar_venta_detalle($db, $value, $producto_inventario[$i]['cantidad'], $producto_inventario[$i], $id);
                                $inv_ =  actualizar_inventario($db, $value, $producto_inventario[$i]['id']);
                            } else {

                                $det_ =  insertar_venta_detalle($db, $value, $cantidad, $producto_inventario[$i], $id);
                                $inv_ =   actualizar_inventario($db, $value, $producto_inventario[$i]['id']);
                                $cantidad = 0;
                                $i = count($producto_inventario);
                            }
                        }
                        if (!$det_) {
                            $error++;
                        }
                        if (!$inv_) {
                            $error++;
                        }
                    } else {
                        $producto_inventario = cargar_Inv_Producto_Cantidad($db, $value['id_producto'], $value['id_almacen'], 1, 2);
                        $det_ =   insertar_venta_detalle($db, $value, $cantidad, $producto_inventario[0], $id);
                        $inv_ =  actualizar_inventario($db, $value, $producto_inventario[0]['id']);
                        $cantidad = 0;
                        if (!$det_) {
                            $error++;
                        }
                        if (!$inv_) {
                            $error++;
                        }
                    }
                }
            }
            if ($error == 0) {
                $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id;
                ';

                        }';
            } else {
                $db->rollback();
                echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
            }
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function insertar_venta_detalle($db, $data, $cantidad, $data_ingreso, $id_venta)
{
    echo 'entra';
    try {
        // echo json_encode($data);
        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO det_venta
                    (id_venta,id_almacen, id_producto, cantidad,precio, costo, id_det_ingreso,descuento_item)
            
                    VALUES
                    (:id_venta,:id_almacen, :id_producto, :cantidad,:precio,:costo,:id_det_ingreso, :descuento_item)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_venta',      $id_venta);
        $stmt->bindParam('id_almacen',    $data['id_almacen']);
        $stmt->bindParam('id_producto',   $data['id_producto']);
        $stmt->bindParam('cantidad',      $cantidad);
        $stmt->bindParam('precio',        $data['precio']);
        $stmt->bindParam('costo',         $data_ingreso['costo']);
        $stmt->bindParam('id_det_ingreso', $data_ingreso['id_det_ingreso']);
        $stmt->bindParam('descuento_item',   $data['desc']);
        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return $id;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
function actualizar_inventario($db, $data, $id_detalle)
{
    try {

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE  in_inventario
        set
        cantidad=cantidad - :cantidad,
        fecha_up=:fecha_up
        where id=:id
        ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id_detalle);
        $stmt->bindParam('cantidad',       $data['cantidad']);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
function cargar_Inv_Producto_Cantidad($db, $id_producto, $id_almacen, $configuracion, $cantidad_mayor)
{
    // 1 = mayor a 0, 2 = menor a 0
    try {
        $asc = ' asc ';
        $ordenar = ' and i.cantidad>0';
        $limite = ' limit 1 ';
        if ($configuracion == 2) {
            $asc = ' desc ';
        }
        if ($cantidad_mayor == 2) {
            $ordenar = ' and i.cantidad<=0 ';
        }
        $sql = "SELECT i.id,i.id_det_ingreso,i.id_producto,i.id_almacen,i.cantidad
        ,di.costo,round(di.costo/di.cantidad,3) as costo_un
        from in_inventario i,in_det_ingreso di
        where i.id_det_ingreso=di.id
        and i.id_producto=:id_producto
        and i.id_almacen=:id_almacen
        $ordenar
        order by i.fecha_reg $asc
        $limite ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_producto', $id_producto);
        $stmt->bindParam('id_almacen',  $id_almacen);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']                = trim($data['id']);
                $array[$i]['id_det_ingreso']    = trim($data['id_det_ingreso']);
                $array[$i]['id_producto']       = trim($data['id_producto']);
                $array[$i]['id_almacen']        = trim($data['id_almacen']);
                $array[$i]['cantidad']          = trim($data['cantidad']);
                $array[$i]['costo']             = trim($data['costo']);
                $array[$i]['costo_un']          = trim($data['costo_un']);

                $i++;
            }
            return $array;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
$app->get('/cargar_pago_venta/:id_venta', 'cargar_pago_venta');
function cargar_pago_venta($id_venta)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT pv.id,pv.id_venta,pv.fecha_pago,pv.monto,pv.nombre
         ,pv.ci,pv.nota,v.saldo
         from pagos_venta pv,venta v
         where pv.id_venta=:id_venta
         and pv.id_venta=v.id
         and pv.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_venta', $id_venta);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_venta']         = trim($data['id_venta']);
                $array[$i]['fecha_pago']       = trim($data['fecha_pago']);
                $array[$i]['monto']            = trim($data['monto']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['ci']               = trim($data['ci']);
                $array[$i]['nota']             = trim($data['nota']);
                $array[$i]['saldo']            = trim($data['saldo']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/guardar_pago_venta', 'guardar_pago_venta');
function guardar_pago_venta()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $horaReg = $data['fecha_pago'] . ' ' . date('H:i:s');
        $sql = "INSERT INTO pagos_venta
            (id_usuario,id_venta,fecha_pago,monto,nombre, ci, nota,estado,fecha_reg,fecha_up)
    
            VALUES 
            (:id_usuario,:id_venta,:fecha_pago,:monto,:nombre,:ci,:nota,1,:fecha_reg,:fecha_up)";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario',          $data['id_usuario']);
        $stmt->bindParam('id_venta',          $data['id_venta']);
        $stmt->bindParam('fecha_pago',        $horaReg);
        $stmt->bindParam('monto',             $data['monto']);
        $stmt->bindParam('nombre',            $data['nombre']);
        $stmt->bindParam('ci',                $data['ci']);
        $stmt->bindParam('nota',              $data['nota']);
        $stmt->bindParam('fecha_reg',              $fechaReg);
        $stmt->bindParam('fecha_up',               $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            actualizar_saldo($db, $data['monto'], $data['id_venta'], 1);
            //  $db->commit();
            echo ' {
                    "errorCode": 0,
                    "errorMessage": "Servicio ejecutado correctamente.",
                    "msg": ' . $id . '
                }';
        } else {
            echo ' {
                    "errorCode": 2,
                    "errorMessage": "Error de servicio."
                }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                "errorCode": 3,
                "errorMessage": "Error al ejecutar el servicio web.",
                "msg": 0
            }';
    }
}
$app->post('/eliminar_venta', 'eliminar_venta');
function eliminar_venta()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE venta
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id_venta 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id_venta',             $data['id_venta']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            $contador = 0;
            $elimino = actualizar_inventario_venta($db, $data['id_venta']);
            if (!$elimino) {
                $contador++;
            }


            if ($contador == 0) {
                $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
            } else {
                $db->rollback();
                echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
            }
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function actualizar_inventario_venta($db, $id_venta)
{
    try {


        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE in_inventario i 
            join det_venta d
            on i.id_producto=d.id_producto
            and i.id_det_ingreso=d.id_det_ingreso
            and i.id_almacen=d.id_almacen
            and d.id_venta=:id_venta
             set i.cantidad=i.cantidad+d.cantidad";



        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_venta',              $id_venta);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}


$app->post('/eliminar_pago', 'eliminar_pago');
function eliminar_pago()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE pagos_venta
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            actualizar_saldo($db, $data['monto'], $data['id_venta'], 2);

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function actualizar_saldo($db, $monto, $id_venta, $tipo)
{
    try {


        $fechaReg = date('Y-m-d H:i:s');
        if ($tipo == 1) {
            $sql = "UPDATE  venta
            set
            saldo=saldo-:monto,
            fecha_up=:fecha_up
            where id=:id_venta";
        } else {
            $sql = "UPDATE  venta
            set
            saldo=saldo+:monto,
            fecha_up=:fecha_up
            where id=:id_venta";
        }


        $stmt = $db->prepare($sql);
        $stmt->bindParam('monto',             $monto);
        $stmt->bindParam('fecha_up',              $fechaReg);
        $stmt->bindParam('id_venta',              $id_venta);
        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}

$app->get('/cargar_ventas_fecha/:fecha_ini/:fecha_fin/:id_empresa', 'cargar_ventas_fecha');
function cargar_ventas_fecha($fecha_ini, $fecha_fin, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.fecha_venta,v.tipo_venta,v.total,v.descuento,v.nombre,v.ci
         ,v.estado,v.saldo,v.nota,v.tipo_pago as id_tipo_pago
         ,tp.nombre as tipo_pago
         ,v.tarjeta,v.es_paquete
         ,(v.total-v.descuento) as total_neto
         ,s.nombre as sucursal,u.nombre as usuario,c.nombre as cliente
         from venta v,em_sucursal s,per_usuarios u
         ,cli_cliente c,tipo_pago_venta tp
         where v.id_sucursal=s.id
         and v.id_usuario=u.id
         and v.tipo_pago=tp.id
         and v.id_cliente=c.id
         and s.id_empresa=:id_empresa
         and date(v.fecha_venta) between :fecha_ini and :fecha_fin
         and v.tipo_venta=1
         and v.estado!=0";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']                = trim($data['id']);
                $array[$i]['fecha_venta']       = trim($data['fecha_venta']);
                $array[$i]['tipo_venta']        = trim($data['tipo_venta']);
                $array[$i]['total']             = trim($data['total']);
                $array[$i]['descuento']         = trim($data['descuento']);
                $array[$i]['nombre']            = trim($data['nombre']);
                $array[$i]['ci']                = trim($data['ci']);
                $array[$i]['estado']            = trim($data['estado']);
                $array[$i]['saldo']             = trim($data['saldo']);
                $array[$i]['nota']              = trim($data['nota']);
                $array[$i]['id_tipo_pago']      = trim($data['id_tipo_pago']);
                $array[$i]['tipo_pago']         = trim($data['tipo_pago']);
                $array[$i]['tarjeta']           = trim($data['tarjeta']);
                $array[$i]['es_paquete']        = trim($data['es_paquete']);
                $array[$i]['total_neto']        = trim($data['total_neto']);
                $array[$i]['sucursal']          = trim($data['sucursal']);
                $array[$i]['usuario']           = trim($data['usuario']);
                $array[$i]['cliente']           = trim($data['cliente']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_ventas_credito_fecha/:fecha_ini/:fecha_fin/:id_empresa', 'cargar_ventas_credito_fecha');
function cargar_ventas_credito_fecha($fecha_ini, $fecha_fin, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.fecha_venta,v.tipo_venta,v.total,v.descuento,v.nombre,v.ci
         ,v.estado,v.saldo,v.nota,v.tipo_pago,v.tarjeta,v.es_paquete
         ,(v.total-v.descuento) as total_neto
         ,s.nombre as sucursal,u.nombre as usuario,c.nombre as cliente
         from venta v,em_sucursal s,per_usuarios u
         ,cli_cliente c
         where v.id_sucursal=s.id
         and v.id_usuario=u.id
         and v.id_cliente=c.id
         and s.id_empresa=:id_empresa
         and date(v.fecha_venta) between :fecha_ini and :fecha_fin
         and v.tipo_venta=2
         and v.estado!=0";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']                = trim($data['id']);
                $array[$i]['fecha_venta']       = trim($data['fecha_venta']);
                $array[$i]['tipo_venta']        = trim($data['tipo_venta']);
                $array[$i]['total']             = trim($data['total']);
                $array[$i]['descuento']         = trim($data['descuento']);
                $array[$i]['nombre']            = trim($data['nombre']);
                $array[$i]['ci']                = trim($data['ci']);
                $array[$i]['estado']            = trim($data['estado']);
                $array[$i]['saldo']             = trim($data['saldo']);
                $array[$i]['nota']              = trim($data['nota']);
                $array[$i]['tipo_pago']         = trim($data['tipo_pago']);
                $array[$i]['tarjeta']           = trim($data['tarjeta']);
                $array[$i]['es_paquete']        = trim($data['es_paquete']);
                $array[$i]['total_neto']        = trim($data['total_neto']);
                $array[$i]['sucursal']          = trim($data['sucursal']);
                $array[$i]['usuario']           = trim($data['usuario']);
                $array[$i]['cliente']           = trim($data['cliente']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_productos_venta/:id_almacen', 'cargar_productos_venta');
function cargar_productos_venta($id_almacen)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT p.id, p.codigo,cod_barra,p.nombre, p.descripcion
         , p.id_tipo,p.id_subcategoria,p.tamano,p.peso,p.precio,p.precio_2
         ,p.foto
         ,p.estado
         ,sum(i.cantidad)as cantidad
         from pro_producto p ,in_inventario i
         where p.id=i.id_producto
         and i.id_almacen=:id_almacen
         and i.estado=1
         and p.estado=1
         group by p.id";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_almacen', $id_almacen);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['codigo']           = trim($data['codigo']);
                $array[$i]['cod_barra']        = trim($data['cod_barra']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['id_tipo']          = trim($data['id_tipo']);
                $array[$i]['id_subcategoria']  = trim($data['id_subcategoria']);
                $array[$i]['tamano']           = trim($data['tamano']);
                $array[$i]['peso']             = trim($data['peso']);
                $array[$i]['precio']           = trim($data['precio']);
                $array[$i]['precio_2']         = trim($data['precio_2']);
                $array[$i]['cantidad']         = trim($data['cantidad']);
                $array[$i]['foto']             = trim($data['foto']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_ventas_id/:id_venta', 'cargar_ventas_id');
function cargar_ventas_id($id_venta)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $sql = "SELECT v.id,v.id_viaje,v.fecha_venta,v.total,tipo_venta
         ,v.saldo,v.nota,v.id_cliente,v.tipo_venta
         ,s.nombre as sucursal
         ,v.descuento
         ,v.cuf
         ,cambio
         ,c.nombre as cliente
         ,c.nit
         ,e.foto
         ,s.id_empresa
         ,e.nombre as empresa
         ,e.tipo_impresion
         from venta v,em_sucursal s,cli_cliente c, em_empresa e
         where v.id_sucursal=s.id
         and s.id_empresa=e.id
         and v.id_cliente=c.id
         and v.id=:id_venta";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_venta', $id_venta);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']                = trim($data['id']);
                $array['id_viaje']          = trim($data['id_viaje']);
                $array['fecha_venta']       = trim($data['fecha_venta']);
                $array['total']             = trim($data['total']);
                $array['tipo_venta']        = trim($data['tipo_venta']);
                $array['saldo']             = trim($data['saldo']);
                $array['nota']              = trim($data['nota']);
                $array['sucursal']          = trim($data['sucursal']);
                $array['descuento']         = trim($data['descuento']);
                $array['cambio']            = trim($data['cambio']);
                $array['cliente']           = trim($data['cliente']);
                $array['nit']           = trim($data['nit']);
                $array['cuf']           = trim($data['cuf']);
                $array['tipo_venta']        = trim($data['tipo_venta']);
                $array['id_cliente']        = trim($data['id_cliente']);
                $array['id_empresa']        = trim($data['id_empresa']);
                $array['foto']              = trim($data['foto']);
                $array['empresa']           = trim($data['empresa']);
                $array['tipo_impresion']    = trim($data['tipo_impresion']);
                $array['detalle']        = cargar_detalle_venta($db, $id_venta);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_detalle_venta($db, $id_venta)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT d.id,d.id_producto,d.cantidad,d.precio,d.costo,p.nombre
         from det_venta d,pro_producto p
         where d.id_producto=p.id
         and d.id_venta=:id_venta";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_venta', $id_venta);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']                = trim($data['id']);
                $array[$i]['id_producto']       = trim($data['id_producto']);
                $array[$i]['cantidad']          = trim($data['cantidad']);
                $array[$i]['precio']            = trim($data['precio']);
                $array[$i]['costo']             = trim($data['costo']);
                $array[$i]['nombre']            = trim($data['nombre']);
                $i++;
            }
            return $array;
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
    }
}

$app->get('/cargar_pago_id/:id_venta', 'cargar_pago_id');
function cargar_pago_id($id_venta)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT pv.id,pv.fecha_pago,pv.monto,pv.nombre,.pv.ci,pv.nota
         ,v.total,v.saldo,v.fecha_venta,v.id as id_venta
         ,v.id_cliente,v.id_responsable
         from pagos_venta pv,venta v
         where pv.id_venta=v.id
         and pv.id=:id_venta";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_venta', $id_venta);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']                = trim($data['id']);
                $array['fecha_pago']        = trim($data['fecha_pago']);
                $array['monto']             = trim($data['monto']);
                $array['nombre']            = trim($data['nombre']);
                $array['ci']                = trim($data['ci']);
                $array['nota']              = trim($data['nota']);
                $array['total']             = trim($data['total']);
                $array['saldo']             = trim($data['saldo']);
                $array['fecha_venta']       = trim($data['fecha_venta']);
                $array['id_venta']          = trim($data['id_venta']);
                $array['id_cliente']        = trim($data['id_cliente']);
                $array['id_responsable']    = trim($data['id_responsable']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
//tabla_proforma
$app->get('/cargar_proformas_fecha/:fecha_ini/:fecha_fin/:id_empresa', 'cargar_proformas_fecha');
function cargar_proformas_fecha($fecha_ini, $fecha_fin, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.fecha_venta,v.total,v.descuento,v.nombre,v.ci
         ,v.estado,v.nota
         ,(v.total-v.descuento) as total_neto
         ,s.nombre as sucursal,u.nombre as usuario,c.nombre as cliente
         from venta_proforma v,em_sucursal s,per_usuarios u
         ,cli_cliente c
         where v.id_sucursal=s.id
         and v.id_usuario=u.id
         
         and v.id_cliente=c.id
         and s.id_empresa=:id_empresa
         and date(v.fecha_venta) between :fecha_ini and :fecha_fin
         and v.estado!=0";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']                = trim($data['id']);
                $array[$i]['fecha_venta']       = trim($data['fecha_venta']);
                $array[$i]['total']             = trim($data['total']);
                $array[$i]['descuento']         = trim($data['descuento']);
                $array[$i]['nombre']            = trim($data['nombre']);
                $array[$i]['ci']                = trim($data['ci']);
                $array[$i]['estado']            = trim($data['estado']);
                $array[$i]['nota']              = trim($data['nota']);
                $array[$i]['total_neto']        = trim($data['total_neto']);
                $array[$i]['sucursal']          = trim($data['sucursal']);
                $array[$i]['usuario']           = trim($data['usuario']);
                $array[$i]['cliente']           = trim($data['cliente']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/insertar_proforma', 'insertar_proforma');
function insertar_proforma()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $hora = date('H:i:s');
        $fecha_ = $data['fecha_venta'] . ' ' . $hora;

        $sql = "INSERT INTO venta_proforma
                    ( id_usuario,id_sucursal,id_cliente,fecha_venta
                    ,total,descuento,nombre,ci,estado,nota
                    ,fecha_reg,fecha_up)
            
                    VALUES
                    ( :id_usuario,:id_sucursal,:id_cliente,:fecha_venta
                    ,:total,:descuento,:nombre,:ci,:estado,:nota
                    ,:fecha_reg,:fecha_up)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario',    $data['id_usuario']);
        $stmt->bindParam('id_sucursal',   $data['id_sucursal']);
        $stmt->bindParam('id_cliente',    $data['id_cliente']);
        $stmt->bindParam('fecha_venta',   $fecha_);
        $stmt->bindParam('total',         $data['total']);
        $stmt->bindParam('descuento',     $data['descuento']);
        $stmt->bindParam('nombre',         $data['nombre']);
        $stmt->bindParam('ci',             $data['ci']);
        $stmt->bindParam('estado',        $data['estado']);
        $stmt->bindParam('nota',          $data['nota']);
        $stmt->bindParam('fecha_reg',     $fecha_);
        $stmt->bindParam('fecha_up',      $fecha_);
        $stmt->execute();
        $id = $db->lastInsertId();
        $error = 0;
        if ($stmt->rowCount() > 0) {
            foreach ($data['productos'] as $key => $value) {
                $det_ =   insertar_proforma_detalle($db, $value, $id);
                if (!$det_) {
                    $error++;
                }
            }
            if ($error == 0) {
                $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '

                        }';
            } else {
                $db->rollback();
                echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
            }
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function insertar_proforma_detalle($db, $data, $id_proforma)
{

    try {
        // echo json_encode($data);
        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO det_proforma
                    (id_proforma, id_producto, cantidad,precio)
            
                    VALUES
                    (:id_proforma, :id_producto, :cantidad,:precio)";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_proforma',      $id_proforma);
        $stmt->bindParam('id_producto',   $data['id_producto']);
        $stmt->bindParam('cantidad',      $data['cantidad']);
        $stmt->bindParam('precio',        $data['precio']);
        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            return $id;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return $e;
    }
}
$app->get('/cargar_proforma_id/:id_venta', 'cargar_proforma_id');
function cargar_proforma_id($id_venta)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.fecha_venta,v.total
         ,v.nota,v.id_cliente,v.nombre,v.ci
         ,s.nombre as sucursal
         ,v.descuento
         ,c.nombre as cliente
         ,e.foto
         ,s.id_empresa
         ,e.nombre as empresa
         from venta_proforma v,em_sucursal s,cli_cliente c, em_empresa e
         where v.id_sucursal=s.id
         and s.id_empresa=e.id
         and v.id_cliente=c.id
         and v.id=:id_venta";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_venta', $id_venta);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']                = trim($data['id']);
                $array['fecha_venta']       = trim($data['fecha_venta']);
                $array['total']             = trim($data['total']);
                $array['nota']              = trim($data['nota']);
                $array['sucursal']          = trim($data['sucursal']);
                $array['descuento']         = trim($data['descuento']);
                $array['cliente']           = trim($data['cliente']);
                $array['nombre']            = trim($data['nombre']);
                $array['ci']                = trim($data['ci']);
                $array['id_cliente']        = trim($data['id_cliente']);
                $array['id_empresa']        = trim($data['id_empresa']);
                $array['foto']              = trim($data['foto']);
                $array['empresa']              = trim($data['empresa']);
                $array['detalle']        = cargar_detalle_proforma($db, $id_venta);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_detalle_proforma($db, $id_proforma)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT d.id,d.id_producto,d.cantidad,d.precio,p.nombre
         from det_proforma d,pro_producto p
         where d.id_producto=p.id
         and d.id_proforma=:id_proforma";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_proforma', $id_proforma);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']                = trim($data['id']);
                $array[$i]['id_producto']       = trim($data['id_producto']);
                $array[$i]['cantidad']          = trim($data['cantidad']);
                $array[$i]['precio']            = trim($data['precio']);
                $array[$i]['nombre']            = trim($data['nombre']);
                $i++;
            }
            return $array;
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
    }
}

$app->post('/eliminar_proforma', 'eliminar_proforma');
function eliminar_proforma()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE venta_proforma
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id_venta 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id_venta',             $data['id_venta']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            $db->rollback();

            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////tabla_cajas
$app->post('/insertar_caja', 'insertar_caja');
function insertar_caja()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO fi_caja
                    (id_usuario,id_sucursal, monto_apertura, fecha_reg,fecha_up,estado)
            
                    VALUES 
                    (:id_usuario,:id_sucursal, :monto_apertura, :fecha_reg,:fecha_up,1)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario',      $data['id_usuario']);
        $stmt->bindParam('id_sucursal',     $data['id_sucursal']);
        $stmt->bindParam('monto_apertura',  $data['monto_apertura']);
        $stmt->bindParam('fecha_reg',       $fechaReg);
        $stmt->bindParam('fecha_up',        $fechaReg);
        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_caja_id/:id_usuario/:id_sucursal', 'cargar_caja_id');
function cargar_caja_id($id_usuario, $id_sucursal)
{
    //try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d H:i:s');

        $sql = "SELECT id, monto_apertura, fecha_reg
         from fi_caja 
         where id_usuario=:id_usuario
         and id_sucursal=:id_sucursal
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario', $id_usuario);
        $stmt->bindParam('id_sucursal', $id_sucursal);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['monto_apertura']   = trim($data['monto_apertura']);
                $array['fecha_reg']        = trim($data['fecha_reg']);
                $array['monto_tarjeta'] = 0;
                $array['monto_qr'] = 0;
                $array['montos_ventas'] = cargar_montos($id_usuario, $id_sucursal, trim($data['fecha_reg']), $fecha, $db);
                $i++;
            }
            $montos = cargar_montos_qr_tarjeta($id_usuario, $id_sucursal, $array['fecha_reg'], $fecha, $db);
            if ($montos) {
                $array['monto_tarjeta'] = $montos['tarjeta'];
                $array['monto_qr'] = $montos['qr'];
            }
            $obtenerMontos = cargar_montos($id_usuario, $id_sucursal, trim($data['fecha_reg']), $fecha, $db);
                echo json_encode([
                    "mesaje" => "resultado :;D",
                    "data" => $obtenerMontos
                    ]);
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    /*} catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }*/
}

function cargar_montos_qr_tarjeta($id_usuario, $id_sucursal, $fecha_ini, $fecha_fin, $db)
{
    try {


        $sql = "SELECT v.id,v.tipo_venta,v.tipo_pago,sum(v.total)as total,tv.nombre
         from venta v,tipo_pago_venta tv
         where v.tipo_pago=tv.id
         and v.id_usuario=:id_usuario
         and v.id_sucursal=:id_sucursal
         and v.estado!=0
         and v.tipo_pago!=1
         and fecha_venta between :fecha_ini and :fecha_fin
         group by v.tipo_pago";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario', $id_usuario);
        $stmt->bindParam('id_sucursal', $id_sucursal);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['tipo_pago']        = trim($data['tipo_pago']);
                $array[$i]['total']        = trim($data['total']);
                $array[$i]['nombre']        = trim($data['nombre']);
                $i++;
            }
            $nuevo['tarjeta'] = 0;
            $nuevo['qr'] = 0;
            $tipo_pagos = array_column($array, 'tipo_pago');
            $tarjeta = array_search('2', $tipo_pagos);
            if ($tarjeta !== false) {
                $nuevo['tarjeta'] = $array[$tarjeta]['total'];
            }

            $qr = array_search('3', $tipo_pagos);
            if ($qr !== false) {
                $nuevo['qr'] = $array[$qr]['total'];
            }
            return $nuevo;
        } else {
            return 0;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": ' . json_encode($e) . '
        }';
    }
}

function cargar_montos($id_usuario, $id_sucursal, $fecha_ini, $fecha_fin, $db)
{
    try {


        $sql = "SELECT v.id,v.tipo_venta,v.tipo_pago,sum(v.total)as total,tv.nombre
         ,v.fecha_venta,v.estado,v.id_usuario,v.id_sucursal
        from venta v,tipo_pago_venta tv
        where v.tipo_pago=tv.id
        and v.tipo_pago=1
        
        and v.id_usuario=:id_usuario
        and v.id_sucursal=:id_sucursal
        and v.estado!=0
        and fecha_venta between :fecha_ini and :fecha_fin
        group by v.tipo_pago";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario', $id_usuario);
        $stmt->bindParam('id_sucursal', $id_sucursal);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['tipo_venta']);
                $array['tipo_pago']        = trim($data['tipo_pago']);
                $array['total']        = trim($data['total']);
                $array['nombre']        = trim($data['nombre']);
                $i++;
            }
            return $array['total'];
        } else {
            return 0;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->post('/actualizar_caja', 'actualizar_caja');
function actualizar_caja()
{
    $db = Config::getConnection();
    $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());
        $fechaReg = date('Y-m-d H:i:s');
        $montos = cargar_montos($data['id_usuario'], $data['id_sucursal'], $data['fecha'], $fechaReg, $db);
        $sql = "UPDATE fi_caja
                    set
                    monto_cierre=:monto_cierre, monto_tarjeta=:monto_tarjeta
                    ,monto_qr=:monto_qr
                    ,descripcion=:descripcion
                    ,fecha_cierre=:fecha_cierre
                    ,fecha_up=:fecha_up
                    ,monto_cierre_pc=:monto_cierre_pc
                    
                    ,estado=2
                    where
                     id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('monto_cierre',             $data['monto_cierre']);
        $stmt->bindParam('monto_tarjeta',            $data['monto_tarjeta']);
        $stmt->bindParam('monto_qr',                 $data['monto_qr']);
        $stmt->bindParam('descripcion',              $data['descripcion']);
        $stmt->bindParam('fecha_cierre',             $fechaReg);
        $stmt->bindParam('fecha_up',                 $fechaReg);
        $stmt->bindParam('id',                       $data['id']);
        $stmt->bindParam('monto_cierre_pc',       $montos);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            $insertar_det_caja = insertar_det_caja($data['id'], $data['id_usuario'], $data['id_sucursal'], $data['fecha'], $db);
            // echo 'sssssssss'.$insertar_det_caja;
            if ($insertar_det_caja) {
                $db->commit();
                echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
            } else {
                $db->rollback();
                echo ' {
                                "errorCode": 2,
                                "errorMessage": "Error al insertar caja."
                            }';
            }
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicioss."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //   $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
function insertar_det_caja($id, $id_usuario, $id_sucursal, $fecha, $db)
{
    try {


        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT into fi_det_caja (id_movimiento,monto,id_tipo,fecha_reg,id_caja)
            select t1.id,t1.monto,t1.id_tipo,t1.fecha,t1.id_caja
            from (
                select v.id,v.total as monto,1 as id_tipo,v.fecha_venta as fecha,:id_caja as id_caja,v.id_usuario,v.id_sucursal
                from venta v
                where v.estado=1
                and v.tipo_pago=1
        
                union all
                select v.id,v.total as monto,5 as id_tipo,v.fecha_venta as fecha,:id_caja as id_caja,v.id_usuario,v.id_sucursal
                from venta v
                where v.estado=1
                and v.tipo_pago=2
                
                union all
                select v.id,v.total as monto,6 as id_tipo,v.fecha_venta as fecha,:id_caja as id_caja,v.id_usuario,v.id_sucursal
                from venta v
                where v.estado=1
                and v.tipo_pago=3
                
                union all
                select c.id,c.costo as monto,2 as id_tipo,c.fecha_ingreso as fecha,:id_caja as id_caja,c.id_usuario,c.id_sucursal
                from in_ingreso c
                where c.estado=1
                
                union all
                select i.id,monto ,3 as id_tipo,i.fecha_reg as fecha,:id_caja as id_caja,i.id_usuario,i.id_sucursal
                from fi_ingreso_egreso i,fi_tipo_inen t
                where i.id_tipo_fi_in=t.id
                and id_tipo_categoria=1
                
                and i.estado=1
                
                union all
                select i.id,monto, 4 as id_tipo,i.fecha_reg as fecha,:id_caja as id_caja,i.id_usuario,i.id_sucursal
                from fi_ingreso_egreso i,fi_tipo_inen t
                where i.id_tipo_fi_in=t.id
                and id_tipo_categoria=2
                union all
                select p.id,p.monto,7 as id_tipo,p.fecha_pago as fecha,:id_caja as id_caja,p.id_usuario,v.id_sucursal
                from pagos_venta p,venta v
                where p.estado=1
                and p.id_venta=v.id
                and v.estado=1
                and p.estado=1
                        )t1
                        where t1.id_usuario=:id_usuario
                        and t1.id_sucursal=:id_sucursal
                        and t1.fecha between :fecha_ini and :fecha_fin";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario',      $id_usuario);
        $stmt->bindParam('id_sucursal',      $id_sucursal);
        $stmt->bindParam('fecha_ini',       $fecha);
        $stmt->bindParam('fecha_fin',        $fechaReg);
        $stmt->bindParam('id_caja',          $id);
        $stmt->execute();
        // $id=$db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            return $id;
        } else {

            return false;
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                "errorCode": 3,
                "errorMessage": "Error al ejecutar el servicio web.",
                "msg": 0
            }';
    }
}
$app->get('/cargar_cajas/:id_empresa/:fecha_ini/:fecha_fin', 'cargar_cajas');
function cargar_cajas($fecha_ini, $fecha_fin, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT c.id,c.monto_apertura,c.monto_cierre,c.monto_tarjeta,c.monto_qr
         ,c.descripcion,c.fecha_reg,c.fecha_cierre,s.nombre as sucursal,u.nombre as usuario
         ,c.monto_cierre_pc,monto_tarjeta_pc,monto_qr_pc
         ,c.estado
         from fi_caja c,em_sucursal s
         ,per_usuarios u
         where c.id_sucursal=s.id
         and s.id_empresa=:id_empresa
         and c.id_usuario=u.id
         and date(c.fecha_reg) between :fecha_ini and :fecha_fin";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['monto_apertura']   = trim($data['monto_apertura']);
                $array[$i]['monto_cierre']     = trim($data['monto_cierre']);
                $array[$i]['monto_tarjeta']    = trim($data['monto_tarjeta']);
                $array[$i]['monto_qr']         = trim($data['monto_qr']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['fecha_reg']        = trim($data['fecha_reg']);
                $array[$i]['fecha_cierre']     = trim($data['fecha_cierre']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['usuario']          = trim($data['usuario']);
                $array[$i]['monto_cierre_pc']  = trim($data['monto_cierre_pc']);
                $array[$i]['monto_tarjeta_pc'] = trim($data['monto_tarjeta_pc']);
                $array[$i]['monto_qr_pc']      = trim($data['monto_qr_pc']);
                $array[$i]['estado']           = trim($data['estado']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_cajas_usuario/:id', 'cargar_cajas_usuario');
function cargar_cajas_usuario($id)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT c.id,c.monto_apertura,c.monto_cierre,c.monto_tarjeta,c.monto_qr
         ,c.descripcion,c.fecha_reg,c.fecha_cierre,s.nombre as sucursal,u.nombre as usuario
         ,c.estado
         from fi_caja c,em_sucursal s
         ,per_usuarios u
         where c.id_sucursal=s.id
         and c.id=:id
         and c.id_usuario=u.id
         ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['monto_apertura']   = trim($data['monto_apertura']);
                $array['monto_cierre']     = trim($data['monto_cierre']);
                $array['monto_tarjeta']    = trim($data['monto_tarjeta']);
                $array['monto_qr']         = trim($data['monto_qr']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['fecha_reg']        = trim($data['fecha_reg']);
                $array['fecha_cierre']     = trim($data['fecha_cierre']);
                $array['sucursal']         = trim($data['sucursal']);
                $array['usuario']          = trim($data['usuario']);
                $array['estado']           = trim($data['estado']);
                $array['detalle']            = cargar_det_caja($data['id'], $db);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_det_caja($id, $db)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT dc.id,dc.id_movimiento,dc.monto,dc.fecha_reg,t.nombre,t.descripcion
         from fi_det_caja dc,fi_tipo t
         where dc.id_caja=:id
         and dc.id_tipo=t.id";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_movimiento']   = trim($data['id_movimiento']);
                $array[$i]['monto']           = trim($data['monto']);
                $array[$i]['fecha_reg']       = trim($data['fecha_reg']);
                $array[$i]['nombre']          = trim($data['nombre']);
                $array[$i]['descripcion']     = trim($data['descripcion']);
                $i++;
            }
            return $array;
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
/////tabla_tipo_ingreso_egreso
$app->post('/insertar_tipo_ingreso_egreso', 'insertar_tipo_ingreso_egreso');
function insertar_tipo_ingreso_egreso()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO fi_tipo_inen
                    (id_tipo_categoria,nombre,descripcion,id_empresa, estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:id_tipo_categoria,:nombre,:descripcion,:id_empresa,1,:fecha_reg,:fecha_up)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_tipo_categoria',          $data['id_tipo_categoria']);
        $stmt->bindParam('nombre',             $data['nombre']);
        $stmt->bindParam('descripcion',        $data['descripcion']);
        $stmt->bindParam('id_empresa',         $data['id_empresa']);
        $stmt->bindParam('fecha_reg',              $fechaReg);
        $stmt->bindParam('fecha_up',               $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_tipo_ingreso_egreso/:id_empresa', 'cargar_tipo_ingreso_egreso');
function cargar_tipo_ingreso_egreso($id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, id_tipo_categoria,nombre,descripcion, estado
         from fi_tipo_inen 
         where 
         id_empresa=:id_empresa
          and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_tipo_categoria']    = trim($data['id_tipo_categoria']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_tipo_ingreso_egreso_tipo/:id_tipo/:id_empresa', 'cargar_tipo_ingreso_egreso_tipo');
function cargar_tipo_ingreso_egreso_tipo($id_tipo, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, id_tipo_categoria,nombre,descripcion, estado
         from fi_tipo_inen 
         where 
         id_tipo_categoria=:id_tipo
         and id_empresa=:id_empresa
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_tipo', $id_tipo);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_tipo_categoria']    = trim($data['id_tipo_categoria']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_tipo_ingreso_egreso_id/:id_pro', 'cargar_tipo_ingreso_egreso_id');
function cargar_tipo_ingreso_egreso_id($id_pro)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, id_tipo_categoria,nombre,descripcion, estado
         from fi_tipo_inen 
         where id_tipo_categoria=:id 
         and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id_pro);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['id_tipo_categoria']    = trim($data['id_tipo_categoria']);
                $array['nombre']           = trim($data['nombre']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['estado']           = trim($data['estado']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_tipo_ingreso_egreso', 'actualizar_tipo_ingreso_egreso');
function actualizar_tipo_ingreso_egreso()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE fi_tipo_inen
                    set
                    id_tipo_categoria=:id_tipo_categoria, nombre=:nombre, descripcion=:descripcion
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_tipo_categoria', $data['id_tipo_categoria']);
        $stmt->bindParam('nombre', $data['nombre']);
        $stmt->bindParam('descripcion', $data['descripcion']);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_tipo_ingreso_egreso', 'eliminar_tipo_ingreso_egreso');
function eliminar_tipo_ingreso_egreso()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE fi_tipo_inen
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////tabla_fin_ingreso_egreso
$app->post('/insertar_fin_ingreso_egreso', 'insertar_fin_ingreso_egreso');
function insertar_fin_ingreso_egreso()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO fi_ingreso_egreso
                    (id_tipo_fi_in,id_sucursal,id_usuario, monto, descripcion,fecha,estado,fecha_reg,fecha_up)
            
                    VALUES 
                    (:id_tipo_fi_in,:id_sucursal,:id_usuario, :monto, :descripcion,:fecha,1,:fecha_reg,:fecha_up)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_tipo_fi_in',          $data['id_tipo_fi_in']);
        $stmt->bindParam('id_sucursal',            $data['id_sucursal']);
        $stmt->bindParam('id_usuario',             $data['id_usuario']);
        $stmt->bindParam('monto',                  $data['monto']);
        $stmt->bindParam('descripcion',            $data['descripcion']);
        $stmt->bindParam('fecha',                  $data['fecha']);
        $stmt->bindParam('fecha_reg',              $fechaReg);
        $stmt->bindParam('fecha_up',               $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_ingreso_egreso', 'cargar_ingreso_egreso');
function cargar_ingreso_egreso()
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT ie.id, ie.id_tipo_fi_in,ie.id_sucursal,ie.id_usuario, ie.monto, ie.descripcion,ie.fecha,ie.estado
         ,s.nombre as sucursal
         ,ti.nombre as tipo_ingreso
         from fi_ingreso_egreso ie,em_sucursal s,fi_tipo_inen ti
         where ie.id_sucursal=s.id
            and ie.id_tipo_fi_in=ti.id
         and ie.estado=1
         ";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_tipo_fi_in']    = trim($data['id_tipo_fi_in']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['id_usuario']       = trim($data['id_usuario']);
                $array[$i]['monto']            = trim($data['monto']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['fecha']            = trim($data['fecha']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['tipo_ingreso']     = trim($data['tipo_ingreso']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_ingreso_egreso_tipo/:tipo/:id_empresa', 'cargar_ingreso_egreso_tipo');
function cargar_ingreso_egreso_tipo($tipo, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT ie.id, ie.id_tipo_fi_in,ie.id_sucursal,ie.id_usuario, ie.monto, ie.descripcion,ie.fecha,ie.estado
         ,s.nombre as sucursal
         ,ti.nombre as tipo_ingreso
         from fi_ingreso_egreso ie,em_sucursal s,fi_tipo_inen ti
         where ie.id_sucursal=s.id
            and ie.id_tipo_fi_in=ti.id
            and ti.id_tipo_categoria=:tipo
            and s.id_empresa=:id_empresa
         and ie.estado=1
         ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('tipo', $tipo);
        $stmt->bindParam('id_empresa', $id_empresa);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_tipo_fi_in']    = trim($data['id_tipo_fi_in']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['id_usuario']       = trim($data['id_usuario']);
                $array[$i]['monto']            = trim($data['monto']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['fecha']            = trim($data['fecha']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['tipo_ingreso']     = trim($data['tipo_ingreso']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_ingreso_egreso_u/:id_usuario', 'cargar_ingreso_egreso_u');
function cargar_ingreso_egreso_u($id_usuario)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, id_tipo_fi_in,id_sucursal,id_usuario, monto, descripcion,fecha,estado
         from fi_ingreso_egreso 
         where id_usuario=:id_usuario and estado=1";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_usuario', $id_usuario);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_tipo_fi_in']    = trim($data['id_tipo_fi_in']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['id_usuario']       = trim($data['id_usuario']);
                $array[$i]['monto']            = trim($data['monto']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['fecha']            = trim($data['fecha']);
                $array[$i]['estado']           = trim($data['estado']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_ingreso_egreso_id/:id_pro', 'cargar_ingreso_egreso_id');
function cargar_ingreso_egreso_id($id_pro)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT i.id, i.id_tipo_fi_in,i.id_sucursal,i.id_usuario, i.monto, i.descripcion,i.fecha,i.estado
            ,u.nombre
         from fi_ingreso_egreso i,per_usuarios u
         where i.id_usuario=u.id 
         and i.id=:id and i.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id_pro);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['id_tipo_fi_in']    = trim($data['id_tipo_fi_in']);
                $array['id_sucursal']      = trim($data['id_sucursal']);
                $array['id_usuario']       = trim($data['id_usuario']);
                $array['monto']            = trim($data['monto']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['fecha']            = trim($data['fecha']);
                $array['estado']           = trim($data['estado']);
                $array['nombre']           = trim($data['nombre']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_ingreso_egreso', 'actualizar_ingreso_egreso');
function actualizar_ingreso_egreso()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE fi_ingreso_egreso
                    set
                    id_tipo_fi_in=:id_tipo_fi_in, monto=:monto, descripcion=:descripcion
                    ,fecha=:fecha
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_tipo_fi_in', $data['id_tipo_fi_in']);
        $stmt->bindParam('monto', $data['monto']);
        $stmt->bindParam('descripcion', $data['descripcion']);
        $stmt->bindParam('fecha', $data['fecha']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_ingreso_egreso', 'eliminar_ingreso_egreso');
function eliminar_ingreso_egreso()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE fi_ingreso_egreso
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/reporte_ingreso_egreso_id/:fecha_ini/:fecha_fin/:id_tipo_fi_in/:id_usuario/:id_sucursal/:id_empresa', 'reporte_ingreso_egreso_id');
function reporte_ingreso_egreso_id($fecha_ini, $fecha_fin, $id_tipo_fi_in, $id_usuario, $id_sucursal, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = '';
        if ($id_tipo_fi_in != 0) {
            $consulta .= " and ti.id_tipo_categoria=:id_tipo_categoria";
        }
        if ($id_usuario != 0) {
            $consulta .= " and i.id_usuario=:id_usuario";
        }
        if ($id_sucursal != 0) {
            $consulta .= " and i.id_sucursal=:id_sucursal";
        }
        $sql = "SELECT i.id, i.id_tipo_fi_in,i.id_sucursal,i.id_usuario
         , if(ti.id_tipo_categoria=1,i.monto,-i.monto)as monto
         , i.descripcion,i.fecha,i.estado
         ,ti.nombre as tipo,ti.id_tipo_categoria
         ,u.nombre as usuario
         ,s.nombre as sucursal
      from fi_ingreso_egreso i,per_usuarios u,em_sucursal s,fi_tipo_inen ti
      where i.id_usuario=u.id
      and i.id_sucursal=s.id 
      and i.id_tipo_fi_in=ti.id
      and i.estado=1
      and s.id_empresa=:id_empresa
      and i.fecha between :fecha_ini and :fecha_fin
         $consulta";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        if ($id_tipo_fi_in != 0) {
            $stmt->bindParam('id_tipo_categoria', $id_tipo_fi_in);
        }
        if ($id_usuario != 0) {
            $stmt->bindParam('id_usuario', $id_usuario);
        }
        if ($id_sucursal != 0) {
            $stmt->bindParam('id_sucursal', $id_sucursal);
        }
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_tipo_fi_in']    = trim($data['id_tipo_fi_in']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['id_usuario']       = trim($data['id_usuario']);
                $array[$i]['monto']            = trim($data['monto']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['fecha']            = trim($data['fecha']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['tipo']             = trim($data['tipo']);
                if ($data['id_tipo_categoria'] == 1) {
                    $array[$i]['tipo_in'] = 'Ingreso';
                } else {
                    $array[$i]['tipo_in'] = 'Egreso';
                }
                // $array[$i]['ti.id_tipo_categoria'] = trim($data['id_tipo_categoria']);
                $array[$i]['usuario']          = trim($data['usuario']);
                $array[$i]['sucursal']         = trim($data['sucursal']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
/////tabla_viajes
$app->post('/insertar_viaje', 'insertar_viaje');
function insertar_viaje()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO ne_viaje
                    (origen,destino,id_chofer, id_vehiculo
                    , id_sucursal,costo,id_tipo_viaje,fecha_origen,fecha_destino,estado,fecha_reg,fecha_up
                    ,id_usuario)
            
                    VALUES 
                    (:origen,:destino,:id_chofer, :id_vehiculo
                    , :id_sucursal,:costo,:id_tipo_viaje,:fecha_origen,:fecha_destino,1,:fecha_reg,:fecha_up
                    ,:id_usuario)";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('origen',          $data['origen']);
        $stmt->bindParam('destino',         $data['destino']);
        $stmt->bindParam('id_chofer',       $data['id_chofer_t']);
        $stmt->bindParam('id_vehiculo',     $data['id_vehiculo_t']);
        $stmt->bindParam('id_sucursal',     $data['id_sucursal_t']);
        $stmt->bindParam('costo',           $data['costo']);
        $stmt->bindParam('id_tipo_viaje',   $data['id_tipo_viaje']);
        $stmt->bindParam('fecha_origen',    $data['fecha_origen']);
        $stmt->bindParam('fecha_destino',   $data['fecha_destino']);
        $stmt->bindParam('fecha_reg',       $fechaReg);
        $stmt->bindParam('fecha_up',        $fechaReg);
        $stmt->bindParam('id_usuario',      $data['id_usuario']);


        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_viaje/:id_tipo_viaje', 'cargar_viaje');
function cargar_viaje($id_tipo)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.origen,v.destino
         ,v.id_chofer, v.id_vehiculo, v.id_sucursal
         ,(select sum(costo)from costos_viaje where id_viaje=v.id and estado=1)as costo
         ,v.id_tipo_viaje,v.fecha_origen
         ,v.fecha_destino,v.estado
            ,c.nombre as chofer,c.nit
            ,vh.placa,vh.marca,vh.modelo,vh.nombre as vehiculo,vh.descripcion
         ,s.nombre as sucursal
         from ne_viaje v,cli_cliente c,veh_vehiculo vh
         ,em_sucursal s
         where v.id_chofer=c.id
         and v.id_sucursal=s.id
         and v.id_vehiculo=vh.id
         and v.id_tipo_viaje=:id_tipo_viaje
         and v.estado!=0
        
        
         ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_tipo_viaje', $id_tipo);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['origen']           = trim($data['origen']);
                $array[$i]['destino']          = trim($data['destino']);
                $array[$i]['id_chofer_t']        = trim($data['id_chofer']);
                $array[$i]['id_vehiculo_t']      = trim($data['id_vehiculo']);
                $array[$i]['id_sucursal_t']      = trim($data['id_sucursal']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['id_tipo_viaje']    = trim($data['id_tipo_viaje']);
                $array[$i]['fecha_origen']     = trim($data['fecha_origen']);
                $array[$i]['fecha_destino']    = trim($data['fecha_destino']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['chofer']           = trim($data['chofer']);
                $array[$i]['nit']              = trim($data['nit']);
                $array[$i]['placa']            = trim($data['placa']);
                $array[$i]['marca']            = trim($data['marca']);
                $array[$i]['modelo']           = trim($data['modelo']);
                $array[$i]['vehiculo']         = trim($data['vehiculo']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['sucursal']         = trim($data['sucursal']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_viaje_fecha/:id_tipo_viaje/:fecha_ini/:fecha_fin', 'cargar_viaje_fecha');
function cargar_viaje_fecha($id_tipo, $fecha_ini, $fecha_fin)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.origen,v.destino
         ,v.id_chofer, v.id_vehiculo, v.id_sucursal
         ,ifnull((select sum(costo)from costos_viaje where id_viaje=v.id and estado=1),0)as costo
         ,v.id_tipo_viaje,v.fecha_origen
         ,v.fecha_destino,v.estado
            ,c.nombre as chofer,c.nit
            ,vh.placa,vh.marca,vh.modelo,vh.nombre as vehiculo,vh.descripcion
         ,s.nombre as sucursal
         from ne_viaje v,cli_cliente c,veh_vehiculo vh
         ,em_sucursal s
         where v.id_chofer=c.id
         and v.id_sucursal=s.id
         and v.id_vehiculo=vh.id
         and v.id_tipo_viaje=:id_tipo_viaje
         and date(v.fecha_reg) between :fecha_ini and :fecha_fin
         and v.estado!=0
        
        
         ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_tipo_viaje', $id_tipo);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['origen']           = trim($data['origen']);
                $array[$i]['destino']          = trim($data['destino']);
                $array[$i]['id_chofer_t']        = trim($data['id_chofer']);
                $array[$i]['id_vehiculo_t']      = trim($data['id_vehiculo']);
                $array[$i]['id_sucursal_t']      = trim($data['id_sucursal']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['id_tipo_viaje']    = trim($data['id_tipo_viaje']);
                $array[$i]['fecha_origen']     = trim($data['fecha_origen']);
                $array[$i]['fecha_destino']    = trim($data['fecha_destino']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['chofer']           = trim($data['chofer']);
                $array[$i]['nit']              = trim($data['nit']);
                $array[$i]['placa']            = trim($data['placa']);
                $array[$i]['marca']            = trim($data['marca']);
                $array[$i]['modelo']           = trim($data['modelo']);
                $array[$i]['vehiculo']         = trim($data['vehiculo']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['sucursal']         = trim($data['sucursal']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_viaje_u/:id_viaje', 'cargar_viaje_u');
function cargar_viaje_u($id_viaje)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.origen,v.destino
         ,v.id_chofer, v.id_vehiculo, v.id_sucursal
         ,(select sum(costo)from costos_viaje where id_viaje=v.id and estado=1)as costo
         ,v.id_tipo_viaje,v.fecha_origen
         ,v.fecha_destino,v.estado
            ,c.nombre as chofer,c.nit
            ,vh.placa,vh.marca,vh.modelo,vh.nombre as vehiculo,vh.descripcion
         ,s.nombre as sucursal
         from ne_viaje v,cli_cliente c,veh_vehiculo vh
         ,em_sucursal s
         where v.id_chofer=c.id
         and v.id_sucursal=s.id
         and v.id_vehiculo=vh.id
         and v.id=:id_viaje
         and v.estado!=0";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_viaje', $id_viaje);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id'] = trim($data['id']);
                $array['origen'] = trim($data['origen']);
                $array['destino'] = trim($data['destino']);
                $array['id_chofer_t'] = trim($data['id_chofer']);
                $array['id_vehiculo_t'] = trim($data['id_vehiculo']);
                $array['id_sucursal_t'] = trim($data['id_sucursal']);
                $array['costo'] = trim($data['costo']);
                $array['id_tipo_viaje'] = trim($data['id_tipo_viaje']);
                $array['fecha_origen'] = trim($data['fecha_origen']);
                $array['fecha_destino'] = trim($data['fecha_destino']);
                $array['estado'] = trim($data['estado']);
                $array['chofer'] = trim($data['chofer']);
                $array['nit'] = trim($data['nit']);
                $array['placa'] = trim($data['placa']);
                $array['marca'] = trim($data['marca']);
                $array['modelo'] = trim($data['modelo']);
                $array['vehiculo'] = trim($data['vehiculo']);
                $array['descripcion'] = trim($data['descripcion']);
                $array['sucursal'] = trim($data['sucursal']);
                $i++;
            }
            $gastos = cargar_gastos_viaje($id_viaje, $db);
            $compras = cargar_ventas_viaje($id_viaje, $db);
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . ',
                "gastos": ' . json_encode($gastos) . ',
                "ventas": ' . json_encode($compras) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
function cargar_gastos_viaje($id_viaje, $db)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT c.id, c.costo,c.id_viaje,c.descripcion, c.id_tipo_costos, c.estado
         ,tc.nombre as tipo_costo
         from costos_viaje c,tipo_costos tc
         where c.id_tipo_costos=tc.id
         and c.id_viaje=:id_viaje
         and  c.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_viaje', $id_viaje);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['id_viaje']         = trim($data['id_viaje']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['id_tipo_costos']   = trim($data['id_tipo_costos']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['tipo_costo']       = trim($data['tipo_costo']);
                $i++;
            }
            return $array;
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return false;
    }
}
function cargar_ventas_viaje($id_viaje, $db)
{
    try {

        $fecha = date('Y-m-d');

        $sql = "SELECT v.id,v.id_viaje,v.fecha_venta,v.total,v.nombre,v.ci
         ,v.saldo,v.nota
         ,s.nombre as sucursal
         ,(select nombre from responsable_colonia where id=v.id_responsable) as responsable
         ,(select nombre from cli_cliente where id=v.id_cliente) as cliente
         from venta v,em_sucursal s
   
         where v.id_sucursal=s.id
         and v.id_viaje=:id_viaje
         and v.estado!=0";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_viaje', $id_viaje);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['id_viaje']         = trim($data['id_viaje']);
                $array[$i]['fecha_venta']      = trim($data['fecha_venta']);
                $array[$i]['total']            = trim($data['total']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['ci']               = trim($data['ci']);
                $array[$i]['saldo']            = trim($data['saldo']);
                $array[$i]['nota']             = trim($data['nota']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['responsable']      = trim($data['responsable']);
                $array[$i]['cliente']          = trim($data['cliente']);

                $i++;
            }
            return $array;
        } else {
            return false;
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        return false;
    }
}
$app->post('/actualizar_viaje', 'actualizar_viaje');
function actualizar_viaje()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE ne_viaje
                    set
                    origen=:origen, destino=:destino, id_chofer=:id_chofer
                    ,id_vehiculo=:id_vehiculo,id_sucursal=:id_sucursal,fecha_origen=:fecha_origen
                    ,fecha_destino=:fecha_destino
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id',             $data['id']);
        $stmt->bindParam('origen',         $data['origen']);
        $stmt->bindParam('destino',        $data['destino']);
        $stmt->bindParam('id_chofer',      $data['id_chofer']);
        $stmt->bindParam('id_vehiculo',    $data['id_vehiculo']);
        $stmt->bindParam('id_sucursal',    $data['id_sucursal']);
        $stmt->bindParam('fecha_origen',   $data['fecha_origen']);
        $stmt->bindParam('fecha_destino',  $data['fecha_destino']);
        $stmt->bindParam('fecha_up',       $fechaReg);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/finalizar_viaje', 'finalizar_viaje');
function finalizar_viaje()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE ne_viaje
                    set
                    fecha_destino=:fecha_destino
                    ,estado=2
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);
        $stmt->bindParam('fecha_destino',  $data['fecha_destino']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_viaje', 'eliminar_viaje');
function eliminar_viaje()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE ne_viaje
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}

/////tabla_costo_viaje
$app->post('/insertar_costos_viaje', 'insertar_costos_viaje');
function insertar_costos_viaje()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO costos_viaje
                    (costo,id_viaje,descripcion, id_tipo_costos, estado,fecha_reg,fecha_up)
            
                    VALUES 
                    
                    (:costo,:id_viaje,:descripcion, :id_tipo_costos, :estado,:fecha_reg,:fecha_up)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('costo',          $data['costo']);
        $stmt->bindParam('id_viaje',       $data['id_viaje']);
        $stmt->bindParam('descripcion',    $data['descripcion']);
        $stmt->bindParam('id_tipo_costos', $data['id_tipo_costos']);
        $stmt->bindParam('estado',         $data['estado']);

        $stmt->bindParam('fecha_reg',              $fechaReg);
        $stmt->bindParam('fecha_up',               $fechaReg);

        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_costos', 'cargar_costos');
function cargar_costos()
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT c.id, c.costo,c.id_viaje,c.descripcion, c.id_tipo_costos, c.estado
         ,tc.nombre as tipo_costo
         from costos_viaje c,tipo_costos tc
         where c.id_tipo_costos=tc.id
         and  c.estado=1";
        $stmt = $db->prepare($sql);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['id_viaje']         = trim($data['id_viaje']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['id_tipo_costos']   = trim($data['id_tipo_costos']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['tipo_costo']       = trim($data['tipo_costo']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/cargar_costos_viaje/:id_viaje', 'cargar_costos_viaje');
function cargar_costos_viaje($id_viaje)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT c.id, c.costo,c.id_viaje,c.descripcion, c.id_tipo_costos, c.estado
         ,tc.nombre as tipo_costo
         from costos_viaje c,tipo_costos tc
         where c.id_tipo_costos=tc.id
         and c.id_viaje=:id_viaje
         and  c.estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_viaje', $id_viaje);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['id_viaje']         = trim($data['id_viaje']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['id_tipo_costos']   = trim($data['id_tipo_costos']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['tipo_costo']       = trim($data['tipo_costo']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_costos_viaje_id/:id_pro', 'cargar_costos_viaje_id');
function cargar_costos_viaje_id($id_pro)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, costo,id_viaje,descripcion, id_tipo_costos, estado
         from costos_viaje 
         where id=:id and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id_pro);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['costo']            = trim($data['costo']);
                $array['id_viaje']         = trim($data['id_viaje']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['id_tipo_costos']   = trim($data['id_tipo_costos']);
                $array['estado']           = trim($data['estado']);


                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_costos_viaje', 'actualizar_costos_viaje');
function actualizar_costos_viaje()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE costos_viaje
                    set
                    id_tipo_costos=:id_tipo_costos,
                    costo=:costo,  descripcion=:descripcion
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('costo', $data["costo"]);
        $stmt->bindParam('id_tipo_costos', $data["id_tipo_costos"]);
        $stmt->bindParam('descripcion', $data['descripcion']);
        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_costos_viaje', 'eliminar_costos_viaje');
function eliminar_costos_viaje()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE costos_viaje
                    set
                    
                    estado=0
                    ,fecha_up=:fecha_up
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);

        $stmt->bindParam('fecha_up',       $fechaReg);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
/////tabla_tipo_costos
$app->post('/insertar_tipo_costos', 'insertar_tipo_costos');
function insertar_tipo_costos()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "INSERT INTO tipo_costos
                    (nombre,descripcion,estado)
            
                    VALUES 
                    (:nombre,:descripcion,1)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre',          $data['nombre']);
        $stmt->bindParam('descripcion',     $data['descripcion']);


        $stmt->execute();
        $id = $db->lastInsertId();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente.",
                            "msg": ' . $id . '
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->get('/cargar_tipo_costos', 'cargar_tipo_costos');
function cargar_tipo_costos()
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre,descripcion,estado
         from tipo_costos
         where 
          estado=1";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/cargar_tipo_costos_id/:id_pro', 'cargar_tipo_costos_id');
function cargar_tipo_costos_id($id_pro)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT id, nombre,descripcion,estado
         from tipo_costos 
         where id=:id and estado=1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id', $id_pro);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array['id']               = trim($data['id']);
                $array['nombre']           = trim($data['nombre']);
                $array['descripcion']      = trim($data['descripcion']);
                $array['estado']           = trim($data['estado']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->post('/actualizar_tipo_costos', 'actualizar_tipo_costos');
function actualizar_tipo_costos()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE tipo_costos
                    set
                    nombre=:nombre,  descripcion=:descripcion
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('nombre', $data['nombre']);
        $stmt->bindParam('descripcion', $data['descripcion']);
        $stmt->bindParam('id',             $data['id']);

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
$app->post('/eliminar_tipo_costos', 'eliminar_tipo_costos');
function eliminar_tipo_costos()
{
    $db = Config::getConnection();
    //  $db->beginTransaction();
    try {
        $request = Slim::getInstance()->request();
        $data = ($request->getBody());

        $fechaReg = date('Y-m-d H:i:s');
        $sql = "UPDATE tipo_costos
                    set
                    
                    estado=0
                    where
                    id=:id 
                    ";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('id',             $data['id']);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {

            //  $db->commit();
            echo ' {
                            "errorCode": 0,
                            "errorMessage": "Servicio ejecutado correctamente."
                        }';
        } else {
            echo ' {
                            "errorCode": 2,
                            "errorMessage": "Error de servicio."
                        }';
        }

        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        //  $db->rollback();
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
                        "errorCode": 3,
                        "errorMessage": "Error al ejecutar el servicio web.",
                        "msg": 0
                    }';
    }
}
//tabla_reportes
$app->get('/cargar_ventas_reporte/:fecha_ini/:fecha_fin/:id_sucursal/:id_cliente/:id_empresa/:estado', 'cargar_ventas_reporte');
function cargar_ventas_reporte($fecha_ini, $fecha_fin, $id_sucursal, $id_cliente, $id_empresa, $estado)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = " and v.estado!=0 ";

        if ($estado == 0) {
            $consulta = " and v.estado=0 ";
        }

        if ($id_sucursal != "0") {
            $consulta = $consulta . " and v.id_sucursal=:id_sucursal";
        }
        if ($id_cliente != "0") {
            $consulta = $consulta . " and v.id_cliente=:id_cliente";
        }

        $sql = "SELECT v.id,v.fecha_venta,v.total,v.nombre,v.ci
         ,v.saldo,v.nota
         ,s.nombre as sucursal
         ,v.descuento
        ,(v.total-v.descuento) as total_descuento
         ,(select nombre from cli_cliente where id=v.id_cliente) as cliente
         from venta v,em_sucursal s
         where v.id_sucursal=s.id
         
         and date(v.fecha_venta) between :fecha_ini and :fecha_fin
         $consulta
         and s.id_empresa=:id_empresa
         group by v.id";
        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        if ($id_sucursal != "0") {
            $stmt->bindParam('id_sucursal', $id_sucursal);
        }
        if ($id_cliente != "0") {
            $stmt->bindParam('id_cliente', $id_cliente);
        }

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']                = trim($data['id']);
                $array[$i]['fecha_venta']       = trim($data['fecha_venta']);
                $array[$i]['total']             = trim($data['total']);
                $array[$i]['nombre']            = trim($data['nombre']);
                $array[$i]['ci']                = trim($data['ci']);
                $array[$i]['saldo']             = trim($data['saldo']);
                $array[$i]['nota']              = trim($data['nota']);
                $array[$i]['sucursal']          = trim($data['sucursal']);
                $array[$i]['descuento']         = trim($data['descuento']);
                $array[$i]['total_descuento']   = trim($data['total_descuento']);
                $array[$i]['cliente']           = trim($data['cliente']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/reporte_compras/:fecha_ini/:fecha_fin/:id_sucursal/:id_proveedor/:id_empresa', 'reporte_compras');
function reporte_compras($fecha_ini, $fecha_fin, $id_sucursal, $id_proveedor, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = "";
        if ($id_sucursal != "0") {
            $consulta = $consulta . " and a.id_sucursal=:id_sucursal";
        }
        if ($id_proveedor != "0") {
            $consulta = $consulta . " and i.id_proveedor=:id_proveedor";
        }

        $sql = "SELECT i.id, i.fecha_ingreso, i.id_sucursal,i.id_proveedor
         ,i.costo as total,i.descripcion,i.estado
         ,s.nombre as sucursal,p.nombre as proveedor
         FROM in_ingreso i,em_sucursal s,in_proveedor p
         WHERE i.id_sucursal=s.id
         
         AND i.id_proveedor=p.id
         AND i.estado=1 
          and s.id_empresa=:id_empresa
         AND date(i.fecha_ingreso) BETWEEN :fecha_ini and :fecha_fin
         $consulta
         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        if ($id_sucursal != "0") {
            $stmt->bindParam('id_sucursal', $id_sucursal);
        }
        if ($id_proveedor != "0") {
            $stmt->bindParam('id_proveedor', $id_proveedor);
        }

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['fecha_ingreso']    = trim($data['fecha_ingreso']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['id_proveedor']     = trim($data['id_proveedor']);
                $array[$i]['total']            = trim($data['total']);
                $array[$i]['descripcion']      = trim($data['descripcion']);
                $array[$i]['estado']           = trim($data['estado']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['proveedor']        = trim($data['proveedor']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/reporte_viaje/:fecha_ini/:fecha_fin/:id_sucursal/:id_chofer/:id_vehiculo', 'reporte_viaje');
function reporte_viaje($fecha_ini, $fecha_fin, $id_sucursal, $id_chofer, $id_vehiculo)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = "";
        if ($id_sucursal != "0") {
            $consulta = $consulta . " and v.id_sucursal=:id_sucursal";
        }
        if ($id_chofer != "0") {
            $consulta = $consulta . " and v.id_chofer=:id_chofer";
        }
        if ($id_vehiculo != "0") {
            $consulta = $consulta . " and v.id_vehiculo=:id_vehiculo";
        }
        $sql = "SELECT v.id,v.origen,v.destino,v.id_chofer
         ,v.id_vehiculo,v.id_sucursal,v.costo,v.fecha_origen,v.fecha_destino
         ,c.nombre as chofer,ve.nombre as vehiculo
         ,s.nombre as sucursal
         ,ifnull((select sum(costo)from costos_viaje where id_viaje=v.id),0)as gasto
         ,ifnull((select sum(total)from venta where id_viaje=v.id),0)as ventas
         from ne_viaje v,cli_cliente c,veh_vehiculo ve
         ,em_sucursal s
         where v.estado=1
         and v.id_chofer=c.id
         and v.id_vehiculo=ve.id
         and v.id_sucursal=s.id
         and v.id_tipo_viaje=2
         and date(v.fecha_origen) between :fecha_ini and :fecha_fin
         $consulta
         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        if ($id_sucursal != "0") {
            $stmt->bindParam('id_sucursal', $id_sucursal);
        }
        if ($id_chofer != "0") {
            $stmt->bindParam('id_chofer', $id_chofer);
        }
        if ($id_vehiculo != "0") {
            $stmt->bindParam('id_vehiculo', $id_vehiculo);
        }
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['origen']           = trim($data['origen']);
                $array[$i]['destino']          = trim($data['destino']);
                $array[$i]['id_chofer']        = trim($data['id_chofer']);
                $array[$i]['id_vehiculo']      = trim($data['id_vehiculo']);
                $array[$i]['id_sucursal']      = trim($data['id_sucursal']);
                $array[$i]['costo']            = trim($data['costo']);
                $array[$i]['fecha_origen']     = trim($data['fecha_origen']);
                $array[$i]['fecha_destino']    = trim($data['fecha_destino']);
                $array[$i]['chofer']           = trim($data['chofer']);
                $array[$i]['vehiculo']         = trim($data['vehiculo']);
                $array[$i]['sucursal']         = trim($data['sucursal']);
                $array[$i]['gasto']            = trim($data['gasto']);
                $array[$i]['ventas']           = trim($data['ventas']);

                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/reporte_ganancia/:fecha_ini/:fecha_fin/:id_empresa', 'reporte_ganancia');
function reporte_ganancia($fecha_ini, $fecha_fin, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');

        $sql = "SELECT round(sum(t1.venta_contado),2)as venta,
         round(sum(t1.compras),2)as compras,
         round(sum(t1.ingresos),2)as ingresos,
         round(sum(t1.egresos),2)as egresos,
         sum(t1.cantidad_venta)as cantidad_ventas,
         sum(t1.cantidad_productos)as cantidad_productos,
         round(sum(t1.venta_contado+t1.compras+t1.ingresos+t1.egresos),2)as ganancia
         from(    
      select (v.total-v.descuento)as venta_contado,
            0 as compras,
            0 as ingresos,
            0 as egresos,
            0 as cantidad_venta,
            0 cantidad_productos,
            s.id_empresa
      from venta v join em_sucursal s
      on v.id_sucursal=s.id
      where v.estado=1
      
      and date(v.fecha_venta) between :fecha_ini and :fecha_fin
      
      
      union all
      
      select 0 as venta_contado,
            
            (-v.costo) as compras,
            0 as ingresos,
            0 as egresos,
            0 as cantidad_venta,
            0 cantidad_productos,
            s.id_empresa
      from in_ingreso v join em_sucursal s
        on v.id_sucursal=s.id
        where v.estado=1
      
      and date(v.fecha_ingreso) between :fecha_ini and :fecha_fin
      
      union all
      
      select 0 as venta_contado,
            
            0 as compras,
            (i.monto) as ingresos,
            0 as egresos,
            0 as cantidad_venta,
            0 cantidad_productos,
            ti.id_empresa
      from fi_ingreso_egreso i,fi_tipo_inen ti
      where i.id_tipo_fi_in=ti.id
      and ti.id_tipo_categoria=1
      and date(i.fecha)  between :fecha_ini and :fecha_fin
      
      union all
      
      select 0 as venta_contado,
            
            0 as compras,
            0 as ingresos,
            (-i.monto) as egresos,
            0 as cantidad_venta,
            0 cantidad_productos,
            ti.id_empresa
      from fi_ingreso_egreso i,fi_tipo_inen ti
      where i.id_tipo_fi_in=ti.id
      and ti.id_tipo_categoria=2
      and date(i.fecha)  between :fecha_ini and :fecha_fin
     
       union all
      
      select 0 as venta_contado,
            
            0 as compras,
            0 as ingresos,
            0 as egresos,
            (v.id)as cantidad_venta,
            0 cantidad_productos,
            s.id_empresa
            from venta v join em_sucursal s
            on v.id_sucursal=s.id
            where v.estado=1
        and v.merma=0
        and date(v.fecha_venta) between :fecha_ini and :fecha_fin
        
        union all
        
         select 0 as venta_contado,
            
            0 as compras,
            0 as ingresos,
            0 as egresos,
            0 as cantidad_venta,
            (dv.cantidad)as cantidad_productos,
            s.id_empresa
            from venta v,det_venta dv,em_sucursal s
            where v.id=dv.id_venta
            and v.estado=1
            and v.id=dv.id_venta
            and v.merma=0
            and date(v.fecha_venta) between :fecha_ini and :fecha_fin
       
      
      )t1
      where t1.id_empresa=:id_empresa
         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        //  echo $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['venta']               = trim($data['venta']);
                $array[$i]['compras']           = trim($data['compras']);
                $array[$i]['ingresos']          = trim($data['ingresos']);
                $array[$i]['egresos']           = trim($data['egresos']);
                $array[$i]['cantidad_ventas']   = trim($data['cantidad_ventas']);
                $array[$i]['cantidad_productos'] = trim($data['cantidad_productos']);
                $array[$i]['ganancia']          = trim($data['ganancia']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/reporte_venta_detalle/:fecha_ini/:fecha_fin/:id_producto/:id_empresa', 'reporte_venta_detalle');
function reporte_venta_detalle($fecha_ini, $fecha_fin, $id_producto, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = '';
        if ($id_producto != '0') {
            $consulta = " and dv.id_producto=:id_producto";
        }
        $sql = "SELECT 'Venta'as movimiento,ifnull(sum(-dv.cantidad),0)as cantidad_productos,ifnull(sum(v.descuento),0)as descuento,ifnull(sum(v.total),0) as total, ifnull(sum(v.total+v.descuento),0) as subtotal,count(v.id)as cantidad_m
         from venta v,det_venta dv,em_sucursal s
         where v.id=dv.id_venta
        and v.id_sucursal=s.id
        and s.id_empresa=:id_empresa
         and v.estado!=0
         $consulta
         and date(v.fecha_venta) between :fecha_ini and :fecha_fin
         union all
         select 'Compra'as movimiento,ifnull(sum(dv.cantidad),0)as cantidad_productos,0 as descuento,ifnull(sum(-i.costo),0)as total,ifnull(sum(-i.costo),0)as subtotal,count(i.id)as cantidad_m
         from in_ingreso i,in_det_ingreso dv,em_sucursal s
         where i.id=dv.id_ingreso
        and i.id_sucursal=s.id
        and s.id_empresa=:id_empresa
         and i.estado=1
         $consulta
         and date(i.fecha_ingreso) between :fecha_ini and :fecha_fin
         union all
         select 'Ingreso'as movimiento,0 as cantidad_productos,0 as descuentos,sum(i.monto)as total,sum(i.monto)as subtotal,count(i.id)as cantidad_m
         from fi_ingreso_egreso i,fi_tipo_inen ti
         where i.estado=1
         and i.id_tipo_fi_in=ti.id
         and ti.id_empresa=:id_empresa
        and ti.id_tipo_categoria=1
         and date(i.fecha) between :fecha_ini and :fecha_fin
         union all
         select 'Egreso'as movimiento,0 as cantidad_productos,0 as descuentos,sum(-i.monto)as total,sum(-i.monto)as subtotal,count(i.id)as cantidad_m
         from fi_ingreso_egreso i,fi_tipo_inen ti
         where i.estado=1
         and i.id_tipo_fi_in=ti.id
         and ti.id_empresa=:id_empresa
        and ti.id_tipo_categoria=2
         and date(i.fecha) between :fecha_ini and :fecha_fin
         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        if ($id_producto != '0') {
            $stmt->bindParam('id_producto', $id_producto);
        }


        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['movimiento']               = trim($data['movimiento']);
                $array[$i]['cantidad_productos']           = trim($data['cantidad_productos']);
                $array[$i]['descuento']          = trim($data['descuento']);
                $array[$i]['total']           = trim($data['total']);
                $array[$i]['subtotal']           = trim($data['subtotal']);
                $array[$i]['cantidad_m']   = trim($data['cantidad_m']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
$app->get('/reporte_ingresos/:fecha_ini/:fecha_fin/:id_sucursal', 'reporte_ingresos');
function reporte_ingresos($fecha_ini, $fecha_fin, $id_sucursal)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = "";
        if ($id_sucursal != "0") {
            $consulta = $consulta . " and i.id_sucursal=:id_sucursal";
        }

        $sql = "SELECT t1.id,t1.ingreso,t1.egreso,t1.descripcion,t1.tipo,t1.sucursal
         ,i.fecha
         from(
           select i.id,i.monto as ingreso,0 as egreso,i.descripcion,ti.nombre as tipo
           ,s.nombre as sucursal
           from fi_ingreso_egreso i,fi_tipo_inen ti
           ,em_sucursal s
           where i.id_tipo_fi_in=ti.id
           and i.id_sucursal=s.id
           and ti.id_tipo_categoria=1
           and i.estado=1
           and i.fecha between :fecha_ini and :fecha_fin
           union all
           
           select i.id,0 as ingreso,-i.monto as egreso,i.descripcion,ti.nombre as tipo
           ,s.nombre as sucursal
           from fi_ingreso_egreso i,fi_tipo_inen ti
           ,em_sucursal s
           where i.id_tipo_fi_in=ti.id
           and i.id_sucursal=s.id
           and ti.id_tipo_categoria=2
           and i.estado=1
           and i.fecha between :fecha_ini and :fecha_fin)t1
           ,fi_ingreso_egreso i
           where t1.id=i.id
           $consulta
         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        if ($id_sucursal != "0") {
            $stmt->bindParam('id_sucursal', $id_sucursal);
        }

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['ingreso']           = trim($data['ingreso']);
                $array[$i]['egreso']           = trim($data['egreso']);
                $array[$i]['descripcion']          = trim($data['descripcion']);
                $array[$i]['tipo']           = trim($data['tipo']);
                $array[$i]['sucursal']           = trim($data['sucursal']);
                $array[$i]['fecha']           = trim($data['fecha']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/reporte_inventario/:id_almacen/:id_empresa', 'reporte_inventario');
function reporte_inventario($id_almacen, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $ini = 0;
        $fin = 3500;
        $consulta = "";
        if ($id_almacen != "0") {
            $consulta = $consulta . " and i.id_almacen=:id_almacen";
        }

        $sql = "SELECT i.id_producto,i.id_almacen,sum(i.cantidad) as cantidad,p.codigo,p.nombre,
        a.nombre as almacen,s.nombre as sucursal,di.fecha_vencimiento,di.lote,
        DATEDIFF(di.fecha_vencimiento,NOW()) as dias_restantes, p.stock_min as stock_minimo, i.cantidad as stock_actual
        FROM in_inventario i, pro_producto p, em_almacen a, em_sucursal s, in_det_ingreso di
        WHERE i.id_almacen=a.id
        AND i.id_det_ingreso=di.id
        AND a.id_sucursal=s.id
        AND i.estado=1
        AND p.estado=1
        AND i.id_producto=p.id
        AND s.id_empresa=:id_empresa
        $consulta
        GROUP BY i.id_producto,i.id_almacen
        LIMIT $ini,$fin";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('id_empresa', $id_empresa);

        if ($id_almacen != "0") {
            $stmt->bindParam('id_almacen', $id_almacen);
        }

        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id_producto']);

                $array[$i]['id_almacen']           = trim($data['id_almacen']);
                $array[$i]['cantidad']           = trim($data['cantidad']);
                $array[$i]['codigo']           = trim($data['codigo']);
                $array[$i]['lote']               = trim($data['lote']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['almacen']           = trim($data['almacen']);
                $array[$i]['sucursal']           = trim($data['sucursal']);
                $array[$i]['fecha_vencimiento']           = trim($data['fecha_vencimiento']);
                $array[$i]['dias_restantes']           = trim($data['dias_restantes']);
                $array[$i]['stock_minimo']           = trim($data['stock_minimo']);
                $array[$i]['stock_actual']           = trim($data['stock_actual']);



                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}


$app->get('/reporte_merma/:fecha_ini/:fecha_fin/:id_producto', 'reporte_merma');
function reporte_merma($fecha_ini, $fecha_fin, $id_producto)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = "";
        if ($id_producto != "0") {
            $consulta = $consulta . " and p.id_producto=:id_producto";
        }
        $sql = "SELECT v.id,v.fecha_venta as fecha,v.nota,(v.total-v.descuento)as total_descuento ,'venta' as movimiento
         ,sum(dv.cantidad)as cantidad,p.codigo,p.nombre
         ,v.total ,v.descuento
         from venta v,det_venta dv,pro_producto p
         where dv.id_venta=v.id
         and dv.id_producto=p.id
         and v.estado=1
         and v.merma=1
         and v.fecha_venta between :fecha_ini and :fecha_fin
         $consulta
         group by v.id,p.id
         union all
         select i.id,i.fecha_ingreso as fecha,i.descripcion as nota,-i.costo as total_descuento,'compra'as movimiento
         ,sum(-di.cantidad)as  cantidad,p.codigo,p.nombre
         ,-i.costo as total,0 as descuento
         from in_ingreso i,in_det_ingreso di,pro_producto p
         where di.id_ingreso=i.id
         and di.id_producto=p.id
         and i.estado=1
         and i.merma=1
         and i.fecha_ingreso between :fecha_ini and :fecha_fin
         $consulta
         group by i.id,p.id

         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        if ($id_producto != "0") {
            $stmt->bindParam('id_producto', $id_producto);
        }


        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id']               = trim($data['id']);
                $array[$i]['fecha']           = trim($data['fecha']);
                $array[$i]['nota']           = trim($data['nota']);
                $array[$i]['total']           = trim($data['total']);
                $array[$i]['movimiento']           = trim($data['movimiento']);
                $array[$i]['cantidad']           = trim($data['cantidad']);
                $array[$i]['codigo']           = trim($data['codigo']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['total_descuento']           = trim($data['total_descuento']);
                $array[$i]['descuento']           = trim($data['descuento']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}

$app->get('/reporte_productos_detalle/:fecha_ini/:fecha_fin/:id_producto/:id_empresa', 'reporte_productos_detalle');
function reporte_productos_detalle($fecha_ini, $fecha_fin, $id_producto, $id_empresa)
{
    try {
        $db = Config::getConnection();

        $fecha = date('Y-m-d');
        $consulta = '';
        if ($id_producto != '0') {
            $consulta = " and dv.id_producto=:id_producto";
        }
        $sql = "SELECT v.id,v.fecha_venta,v.total,dv.id_producto,sum(dv.cantidad)as cantidad,dv.precio
         ,p.codigo,p.nombre,dv.costo, (dv.precio-dv.costo)as ganancia
         ,sum(dv.precio*dv.cantidad) as total_venta
         ,sum(dv.costo*dv.cantidad) as total_compra
         from venta v join det_venta dv
         on v.id=dv.id_venta
         join em_sucursal s
         on v.id_sucursal=s.id
         join pro_producto p
         on dv.id_producto= p.id
         where s.id_empresa=:id_empresa
         and v.estado!=0
         and date(v.fecha_venta) between :fecha_ini and :fecha_fin
         $consulta
         group by dv.id_producto, dv.precio,dv.costo
         ";


        $stmt = $db->prepare($sql);
        $stmt->bindParam('fecha_ini', $fecha_ini);
        $stmt->bindParam('fecha_fin', $fecha_fin);
        $stmt->bindParam('id_empresa', $id_empresa);
        if ($id_producto != '0') {
            $stmt->bindParam('id_producto', $id_producto);
        }

        // echo $db->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $array[$i]['id_producto']               = trim($data['id_producto']);
                $array[$i]['cantidad']           = trim($data['cantidad']);
                $array[$i]['precio']          = trim($data['precio']);
                $array[$i]['costo']          = trim($data['costo']);
                $array[$i]['ganancia']          = trim($data['ganancia']);
                $array[$i]['ganancia_neta']          = trim($data['total_venta'] - $data['total_compra']);
                $array[$i]['codigo']           = trim($data['codigo']);
                $array[$i]['nombre']           = trim($data['nombre']);
                $array[$i]['total_venta']           = trim($data['total_venta']);
                $array[$i]['total_compra']           = trim($data['total_compra']);
                $i++;
            }
            echo ' {
                "errorCode": 0,
                "errorMessage": "Servicio ejecutado correctamente.",
                "msg": ' . json_encode($array) . '
            }';
        } else {
            echo ' {
                "errorCode": 2,
                "errorMessage": "Error de servicio."
            }';
        }
        $db = null;
        $stmt = null;
    } catch (PDOException $e) {
        $db = null;
        $stmt = null;
        echo $e;
        echo ' {
            "errorCode": 3,
            "errorMessage": "Error al ejecutar el servicio web.",
            "msg": 0
        }';
    }
}
