<?php

namespace App\ServiciosSiat; // Add the desired namespace

//require('C:\xampp\htdocs\facturacion\ServiciosSiat\ConfigService.php');
require __DIR__ . '/ConfigService.php';
//require('C:\xampp\htdocs\facturacion\Siat\Services\ServicioFacturacionCodigos.php');
require __DIR__ . '/../Siat/Services/ServicioFacturacionCodigos.php';
require __DIR__ . '/../API_REST/function/conexion_singleton.php';

use Config;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionCodigos;

date_default_timezone_set('America/La_Paz');

class CufdService
{
    public $configService;

    public function __construct()
    {
        $this->configService = new ConfigService();
    }

    function obtenerCufd($codigoPuntoVenta, $codigoSucursal, $cuis, $new = false)
    {

        $serviceCodigos = new ServicioFacturacionCodigos(null, null, $this->configService->config->tokenDelegado);
        $serviceCodigos->setConfig((array)$this->configService->config);
        $serviceCodigos->cuis = $cuis;

        $resCufd = $serviceCodigos->cufd($codigoPuntoVenta, $codigoSucursal);
        /* print_r($resCufd); */
        $res = $resCufd;

        return $resCufd;
    }

    public function obtenerCufdBD($id_empresa, $cuis)
    {
        $db = Config::getConnection();
        $fecha_actual = date("d-m-Y h:i:s");
        $sql = "SELECT *
        FROM impuestos_cufd
        WHERE id_empresa=:id_empresa AND cuis=:cuis
        LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_empresa', $id_empresa);
        $stmt->bindParam(':cuis', $cuis);
        $stmt->execute();
        $cufd = $stmt->fetch();
        /* echo(json_encode($cufd));  */
        /*   print_r($cufd); */
        return $cufd;
    }
    public function obtenerPuntoVenta($empresa)
    {
        /* $pc = gethostname();
        $mac = strtok(exec('getmac'), ' '); */
        if (!isset($_SESSION)) {
            session_start();
        }

        $userData = json_decode($_SESSION['dataUser']);
        $usuarioID = $userData->id;
        $estado = 1;
        $db = Config::getConnection();
        $sql = "SELECT * from puntodeventa p 
        join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
        where pvu.user_id = :user_id
        and p.id_empresa = :id_empresa
        and p.estado = :estado LIMIT 1;";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':user_id', $usuarioID);
        $stmt->bindParam(':estado', $estado);
        $stmt->bindParam(':id_empresa', $empresa);
        $stmt->execute();
        $punto_venta = $stmt->fetch();
        return $punto_venta;
        /*  echo json_encode('aca cuis',$codigoCui['ccuis']);  */
    }
    public function guardarHistorialCufd($resCufd, $empresa, $codigoCui)
    {
        date_default_timezone_set('America/La_Paz');
        $fecha_actual = date("Y-m-d H:i:s");

        $estadoCufd = 0;
        $estadoTransaccion = true;
        $db = Config::getConnection();
        $sql = "INSERT INTO historial_cufd 
        (CodigoCufd, Finicio, Fvigencia, Transaccion, CodigoControl, Cuis, Estado, Direccion, id_empresa) 
        VALUES (:CodigoCufd, :Finicio, :Fvigencia, :Transaccion, :CodigoControl, :Cuis, :Estado, :Direccion, :id_empresa)";
        /* $sql = "INSERT INTO historial_cufd
        VALUES (null,:CodigoCufd,:Finicio,:Fvigencia,:Transaccion,:CodigoControl,:Cuis,:Estado, :Direccion,:id_empresa)"; */

        $fechaVigencia = $resCufd->RespuestaCufd->fechaVigencia;
        $fechaVigenciaFormateada = date("Y-m-d H:i:s.000", strtotime($fechaVigencia));

        $stmt = $db->prepare($sql);
        $stmt->bindParam('CodigoCufd', $resCufd->RespuestaCufd->codigo);
        $stmt->bindParam('Finicio', $fecha_actual);
        $stmt->bindParam('Fvigencia', $fechaVigenciaFormateada);
        $stmt->bindParam('Transaccion', $estadoTransaccion);
        $stmt->bindParam('CodigoControl', $resCufd->RespuestaCufd->codigoControl);
        $stmt->bindParam('Cuis', $codigoCui);
        $stmt->bindParam('Estado', $estadoCufd);
        $stmt->bindParam('Direccion', $resCufd->RespuestaCufd->direccion);
        $stmt->bindParam('id_empresa', $empresa);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            return true;
        }
        return false;
    }

    public function updateCufd($empresa)
    {
        date_default_timezone_set('America/La_Paz');
        $fecha_actual = date("Y-m-d G:i:s");
        if (!isset($_SESSION)) {
            session_start();
        }

        $userData = json_decode($_SESSION['dataUser']);
        $userID = $userData->id;
        $pc = gethostname();
        $db = Config::getConnection();
        $estado = 1;
        $sql = "SELECT * from puntodeventa p 
        join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
        where pvu.user_id = :user_id
        and p.id_empresa = :id_empresa
        and p.estado = :estado LIMIT 1; ";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':user_id', $userID);
        $stmt->bindParam(':id_empresa', $empresa);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();
        $codigoCui = $stmt->fetch();

        $punto_ventaBD = $this->obtenerPuntoVenta($empresa);
        $cufd_bd = $this->obtenerCufdBD($empresa, $codigoCui['ccuis']);

        if (!$cufd_bd) {
            //echo json_encode(["data" => $punto_ventaBD['cpuntoventa'], ["data2" => $punto_ventaBD['csucursal'], ["data3" => $codigoCui['ccuis']]]]);
            $responseCufd = $this->obtenerCufd($punto_ventaBD['cpuntoventa'], $punto_ventaBD['csucursal'], $codigoCui['ccuis'], $new = false);

            if (!$responseCufd->RespuestaCufd->transaccion) {
                return [
                    'transaccion'   => 1,
                    'msg'           => $responseCufd->RespuestaCufd->mensajesList->descripcion,
                    'codigo' => $responseCufd->RespuestaCufd->mensajesList->codigo
                ];
            }
            $direccion = $responseCufd->RespuestaCufd->direccion;
            $sql = "INSERT INTO impuestos_cufd
            VALUES (null,:codigocufd,:fechavigencia,:transaccion,:codigocontrol,:cuis,:id_empresa,:direccion, :estado)";
            $arrayEstado["transaccion"] = $responseCufd->RespuestaCufd->transaccion === true ? "true" : "false";
            $arrayEstado["estado"] = 0;

            $fechaVigencia = $responseCufd->RespuestaCufd->fechaVigencia;
            $fechaVigenciaFormateada = date("Y-m-d H:i:s.000", strtotime($fechaVigencia));


            $stmt = $db->prepare($sql);
            $stmt->bindParam('codigocufd', $responseCufd->RespuestaCufd->codigo);
            //$stmt->bindParam('fechavigencia', $responseCufd->RespuestaCufd->fechaVigencia);
            $stmt->bindParam('fechavigencia', $fechaVigenciaFormateada);
            $stmt->bindParam('transaccion', $arrayEstado["transaccion"]);
            $stmt->bindParam('codigocontrol', $responseCufd->RespuestaCufd->codigoControl);
            $stmt->bindParam('cuis', $codigoCui['ccuis']);
            $stmt->bindParam('id_empresa', $empresa);
            $stmt->bindParam('direccion', $direccion);
            $stmt->bindParam('estado', $arrayEstado["estado"]);
            $stmt->execute();
            if ($stmt->rowCount() > 0) {
                $storeCufdHis = $this->guardarHistorialCufd($responseCufd, $empresa, $codigoCui['ccuis']);
                if ($storeCufdHis) {
                    return [
                        'transaccion'   => 0,
                        'msg'           => 'CUFD Actualizado Exitosamente!'
                    ];
                } else {
                    return [
                        'transaccion' => 1,
                        'msg' => 'Error al Actualizar CUFD',
                        'codigo' => "Ninguno"
                    ];
                }
            }

            $db = null;
            $stmt = null;
        } else {
            //echo json_encode($cufd_bd['fechavigencia'] < $fecha_actual);            
            //echo json_encode(["data" => $punto_ventaBD['cpuntoventa'], ["data2" => $punto_ventaBD['csucursal'], ["data3" => $codigoCui['ccuis']]]]);
            if ($cufd_bd['fechavigencia']  <  $fecha_actual) { /* Si Cufd ya vencio */
                $responseCufd = $this->obtenerCufd($punto_ventaBD['cpuntoventa'], $punto_ventaBD['csucursal'], $codigoCui['ccuis'], $new = false);

                $sql = "UPDATE impuestos_cufd
                        set 
                        codigocufd =:codigo_cufd,
                        fechavigencia=:fecha_vigencia,
                        codigocontrol =:codigocontrol,
                        direccion = :direccion WHERE cuis=:cuis";

                $fechaVigencia = $responseCufd->RespuestaCufd->fechaVigencia;
                $fechaVigenciaFormateada = date("Y-m-d H:i:s.000", strtotime($fechaVigencia));

                $stmt = $db->prepare($sql);
                $stmt->bindParam('codigo_cufd', $responseCufd->RespuestaCufd->codigo);
                $stmt->bindParam('fecha_vigencia', $fechaVigenciaFormateada);
                $stmt->bindParam('codigocontrol', $responseCufd->RespuestaCufd->codigoControl);
                $stmt->bindParam('direccion', $responseCufd->RespuestaCufd->direccion);
                $stmt->bindParam('cuis', $codigoCui['ccuis']);
                $stmt->execute();
                if ($stmt->rowCount() > 0) {
                    $storeCufdHis = $this->guardarHistorialCufd($responseCufd, $empresa, $codigoCui['ccuis']);
                    if ($storeCufdHis) {
                        return [
                            'transaccion'   => 0,
                            'msg'           => 'CUFD Actualizado Exitosamente!'
                        ];
                    }
                } else {
                    return [
                        'transaccion' => 1,
                        'msg' => 'Error al Actualizar CUFD',
                        'codigo' => "Ninguno"
                    ];
                }

                $db = null;
                $stmt = null;
            } else {
                return [
                    'transaccion' => 2,
                    'msg' => 'CUFD Ya actualizado',
                    'codigo' => "Ninguno"
                ];
            }
        }
    }
}

$cufdService = new CufdService();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['metodo'] === 'actualizarCufd') {
        $empresa  = $_POST['id_empresa'];
        /* echo json_encode($dataFactura); */
        $res = $cufdService->updateCufd($empresa);
        echo json_encode($res);
    }
}
