<?php

namespace App\ServiciosSiat;

require __DIR__ . '/ConfigService.php';
require_once __DIR__ . '/../API_REST/function/conexion_singleton.php';


use Config;
use DateTime;
use App\ServiciosSiat\ConfigService;
use PDO;

class EventoSignificativoService
{
    /* public $configService;
    public function __construct()
    {
        $this->configService = new ConfigService();
    } */

    public function obtenerParametricaEventos()
    {
        $db = Config::getConnection();

        $sql = "SELECT *
        FROM impuestos_eventosignificativo 
        WHERE estado=1";

        $stmt = $db->prepare($sql);
        $stmt->execute();
        $i = 0;
        if ($stmt->rowCount() > 0) {
            while ($data  = $stmt->fetch(\PDO::FETCH_ASSOC)) {
                $array['content'][$i]['ideventosignificativo'] = trim($data['ideventosignificativo']);
                $array['content'][$i]['codigoclasificador']    = trim($data['codigoclasificador']);
                $array['content'][$i]['descripcion']           = trim($data['descripcion']);

                $i++;
            }
        }

        return $array;
    }

    public function obtenerUnidadMedidaLiteral($id_unidad)
    {
        $producto_id = $id_unidad;
        $db = Config::getConnection();
        $sql = "SELECT * FROM `impuestos_unidadmedida` WHERE  codigoclasificador=:id LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $producto_id);
        $stmt->execute();
        $producto_unidad = $stmt->fetch(\PDO::FETCH_ASSOC);

        return json_encode($producto_unidad);
    }
    protected function getPuntoVentaOffline()
    {
        //connect this function with api rest
        $url = "https://api.rda-consultores.com/api/getUserStorage";
        //connect php with api
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //curl post petition
        curl_setopt($ch, CURLOPT_POST, 1);
        $response = curl_exec($ch);
        curl_close($ch);
        $userData = json_decode($response, true)["content"];
        $userData = json_decode($userData[0], true);
        //file_put_contents("userData.text", json_encode($userData[0], JSON_PRETTY_PRINT));
        $userID = $userData["id"];
        $empresaUser = $userData["id_empresa"];
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT * from puntodeventa p 
          join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
          where pvu.user_id = :user_id
          and p.id_empresa = :id_empresa
          and p.estado = :estado LIMIT 1; ";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':user_id', $userID);
        $stmt->bindParam(':id_empresa', $empresaUser);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();

        $puntoVenta =  $stmt->fetch();

        return $puntoVenta;
    }
    protected function getPuntoVenta()
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $userData = json_decode($_SESSION['dataUser']);
        $userID = $userData->id;
        $empresaUser = $userData->id_empresa;
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT * from puntodeventa p 
          join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
          where pvu.user_id = :user_id
          and p.id_empresa = :id_empresa
          and p.estado = :estado LIMIT 1; ";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':user_id', $userID);
        $stmt->bindParam(':id_empresa', $empresaUser);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();

        $puntoVenta =  $stmt->fetch();

        return $puntoVenta;
    }



    public function obtenerEvento($codigoClasificador)
    {
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM impuestos_eventosignificativo 
        WHERE codigoclasificador = :codigoClasificador AND estado=1";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':codigoClasificador', $codigoClasificador);
        $stmt->execute();
        $evento = $stmt->fetch();

        return $evento;
    }

    public function getImpuestosCufd($cuis)
    {
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM impuestos_cufd 
        WHERE cuis =:cuis";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':cuis', $cuis);
        $stmt->execute();
        $evento = $stmt->fetch();

        return $evento;
    }

    public function guardarEventoOffline()
    {
        $params = [
            "CodigoDesc" => "2",
            "Descripcion" => "INACCESIBILIDAD AL SERVICIO WEB DE LA ADMINISTRACIÓN TRIBUTARIA",
            "FechaFinal" => null,
            "Cafc" => null
        ];
        /* try { */
        date_default_timezone_set("America/La_Paz");
        $db = Config::getConnection();
        $codigoClasificador = $params['CodigoDesc'];
        //! Validamos si ya existe un eventoRegistrado con el mismo Code
        $sameEvento = $this->getExistsEventSinOffline();
        if ($sameEvento['msg']['evento'] == true) {
            return [
                "transaccion" => true,
                "msg" => 'Ya Existe Un Evento Registrado'
            ];
        }

        $data = $this->getPuntoVentaOffline();
        $impuestos_cufd = $this->getImpuestosCufd($data['ccuis']);
        $fechaInicioCufd = (new DateTime(date('Y-m-d H:i:s')))->modify("+1 minute")->format('Y-m-d H:i:s');
        //$fechaInicioCufd = (new DateTime($params["fechaInicio"]))->modify("+1 minute")->format('Y-m-d H:i:s');

        $sql = "INSERT INTO evento_significativos
                    (CodigoDesc ,Descripcion, FechaInicio, FechaFinal, Cafc,CufdEvento, CodigoControl, Direccion, CodigoSucursal, CodigoPVenta)
                    VALUES 
                    (:CodigoDesc ,:Descripcion, :FechaInicio, :FechaFinal,:Cafc,:CufdEvento,:CodigoControl,:Direccion, :CodigoSucursal, :CodigoPVenta)";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':CodigoDesc', $params["CodigoDesc"]);
        $stmt->bindParam(':Descripcion', $params['Descripcion']);
        $stmt->bindParam(':FechaInicio', $fechaInicioCufd);
        $stmt->bindParam(':FechaFinal', $params["FechaFinal"]);
        $stmt->bindParam(':Cafc',  $params["Cafc"]);
        $stmt->bindParam(':CufdEvento', $impuestos_cufd['codigocufd']);
        $stmt->bindParam(':CodigoControl', $impuestos_cufd['codigocontrol']);
        $stmt->bindParam(':Direccion', $impuestos_cufd['direccion']);
        $stmt->bindParam(':CodigoSucursal', $data['csucursal']);
        $stmt->bindParam(':CodigoPVenta', $data['cpuntoventa']);
        $stmt->execute();

        return [
            "transaccion" => true,
            "msg" => "Evento Registrado"
        ];
        /* } catch (\Throwable $e) {
            return [
                "transaccion" => true,
                "msg" => $e->getMessage(),
            ];
        } */
    }

    public function guardarEvento($params)
    {
        try {
            date_default_timezone_set("America/La_Paz");
            $db = Config::getConnection();
            $codigoClasificador = $params['codigoDesc'];
            //! Validamos si ya existe un eventoRegistrado con el mismo Code
            $sameEvento = $this->getExistsEventSin();
            if ($sameEvento['msg']['evento'] == true) {
                return   json_encode('Ya Existe Un Evento Registrado');
            }
            $fechaInicioFormateada = (new DateTime($params['FechaInicio']))->format('Y-m-d\TH:i:s.v');
            $fechaFinFormateada = (new DateTime($params['FechaFinal']))->format('Y-m-d\TH:i:s.v');
            $fechaInicioCufd = (new DateTime($params['fechaInicioCufd']))->modify("+1 minute")->format('Y-m-d H:i:s');
            /* $fechaInicioCufd = (new DateTime($params['FechaInicio']))->modify("+1 minute")->format('Y-m-d H:i:s'); */
            $cafcLimpio = trim($params['cafc']);
            $resEvento = $this->obtenerEvento($codigoClasificador);
            $data = $this->getPuntoVenta();

            $sql = "INSERT INTO evento_significativos
                    (CodigoDesc ,Descripcion, FechaInicio, FechaFinal, Cafc,CufdEvento, CodigoControl, Direccion, CodigoSucursal, CodigoPVenta)
                    VALUES 
                    (:CodigoDesc ,:Descripcion, :FechaInicio, :FechaFinal,:Cafc,:CufdEvento,:CodigoControl,:Direccion, :CodigoSucursal, :CodigoPVenta)";

            $stmt = $db->prepare($sql);
            $stmt->bindParam(':CodigoDesc', $resEvento['codigoclasificador']);
            $stmt->bindParam(':Descripcion', $resEvento['descripcion']);
            $stmt->bindParam(':FechaInicio', $fechaInicioCufd);
            $stmt->bindParam(':FechaFinal', $fechaFinFormateada);
            $stmt->bindParam(':Cafc',  $cafcLimpio);
            $stmt->bindParam(':CufdEvento', $params['cufdEvento']);
            $stmt->bindParam(':CodigoControl', $params['codigoControl']);
            $stmt->bindParam(':Direccion', $params['Direccion']);
            $stmt->bindParam(':CodigoSucursal', $data['csucursal']);
            $stmt->bindParam(':CodigoPVenta', $data['cpuntoventa']);
            $stmt->execute();

            return [
                "transaccion" => true,
                "msg" => "Evento Registrado"
            ];
        } catch (\Throwable $e) {
            return [
                "transaccion" => true,
                "msg" => $e->getMessage(),
            ];
        }
    }
    public function getExistsEventSinOffline()
    {
        $data = $this->getPuntoVentaOffline();

        $db = Config::getConnection();

        $sql = "SELECT * FROM evento_significativos
         WHERE CodigoSucursal=:CodigoSucursal AND CodigoPVenta=:CodigoPVenta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('CodigoSucursal', $data['csucursal']);
        $stmt->bindParam('CodigoPVenta', $data['cpuntoventa']);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            return [
                'transaccion' => true,
                'msg' => [
                    'existe' => true,
                    'evento' => $stmt->fetch(PDO::FETCH_ASSOC),
                ],
            ];
        }
        return [
            'transaccion' => true,
            'msg' => [
                'existe' => false,
                'evento' => null,
            ],
        ];
    }
    public function getExistsEvent()
    {
        $data = $this->getPuntoVenta();

        $db = Config::getConnection();

        $sql = "SELECT * FROM evento_significativos
         WHERE CodigoSucursal=:CodigoSucursal AND CodigoPVenta=:CodigoPVenta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('CodigoSucursal', $data['csucursal']);
        $stmt->bindParam('CodigoPVenta', $data['cpuntoventa']);
        $stmt->execute();

        return $stmt;
    }

    public function getExistsEventSin() //?Para el Evento 2
    {
        $data = $this->getPuntoVenta();

        $db = Config::getConnection();

        $sql = "SELECT * FROM evento_significativos
         WHERE CodigoSucursal=:CodigoSucursal AND CodigoPVenta=:CodigoPVenta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('CodigoSucursal', $data['csucursal']);
        $stmt->bindParam('CodigoPVenta', $data['cpuntoventa']);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            return [
                'transaccion' => true,
                'msg' => [
                    'existe' => true,
                    'evento' => $stmt->fetch(PDO::FETCH_ASSOC),
                ],
            ];
        }
        return [
            'transaccion' => true,
            'msg' => [
                'existe' => false,
                'evento' => null,
            ],
        ];
    }

    public function getEventExists($data_type)
    {
        $evento_func = $this->getExistsEvent();

        if ($data_type) {
            return $evento_func->rowCount() > 0 ? true : false;
        } else {
            return $evento_func->fetch();
        }
    }
    public function registrarEventoImpuesto($facturas)
    {
        $cantidadFacturas = count($facturas); //Hacer funcion pa traer facturas segun el codigoEvento
        $codigoDocumentoSector = 1; /* Temporal xd */
        $dataEvento = $this->getExistsEvent();
        $dataPuntoVenta = $this->getPuntoVenta();
        $serviceOps = new ServicioOperaciones();
        $serviceOps->setConfig((array)(new ConfigService())->config);
        $serviceOps->cuis = $dataPuntoVenta['ccuis'];
        $serviceOps->cufd = $dataEvento['cufdEvento'];
        $resEvent = $serviceOps->registroEventoSignificativo(
            $dataEvento['CodigoDesc'], /* Codigo Evento */
            $dataEvento['Descripcion'],
            $dataEvento['CufdEvento'],
            $dataEvento['FechaInicio'],
            $dataEvento['FechaFinal'],
            $dataEvento['CodigoSucursal'],
            $dataEvento['CodigoPVenta']
        );

        if (!isset($resEvent->RespuestaListaEventos->codigoRecepcionEventoSignificativo)) {
            echo "Error al Registrar Evento";
        }

        $resConstruirFacturas = $this->construirFacturas($dataEvento['CodigoSucursal'], $dataEvento['CodigoPVenta'], $cantidadFacturas, $codigoDocumentoSector, $dataEvento['CufdEvento'], $dataEvento['Cafc'], $facturas);
        if (count($resConstruirFacturas) > 0) {
            //Enviar Paquete con las Facturas Construidas
        }

        return $resEvent;
    }

    function construirFacturas($sucursal, $puntoventa, int $cantidad, $documentoSector, $cufdAntiguo = null, $cafc = null, $facturas)
    {
        $facturas = [];
        $fechaEmision = date('Y-m-d\TH:i:s.v');
        for ($i = 0; $i < $cantidad; $i++) {
            $factura = construirFactura($puntoventa, $sucursal, (new ConfigService())->config->modalidad, $documentoSector, $facturas[$i]);
            $factura->cabecera->nitEmisor = (new ConfigService())->config->nit;
            $factura->cabecera->razonSocialEmisor = (new ConfigService())->config->razonSocial;
            $factura->cabecera->fechaEmision =  date('Y-m-d\TH:i:s.v'); //Fecha Ingreso Manual Venta
            $factura->cabecera->cufd = $cufdAntiguo;
            $factura->cabecera->cafc = $cafc;
            $facturas[] = $factura;
            $fechaEmision = date('Y-m-d\TH:i:s.v', strtotime($fechaEmision) + 10);
        }

        return $facturas;
    }
    function getEstadoAnulacion($nro_factura, $cuf)
    {
        $db = Config::getConnection();
        $sql = "SELECT evento_significativo_id,estado_anulacion FROM venta WHERE  nro_factura=:nro_factura AND cuf=:cuf LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':nro_factura', $nro_factura);
        $stmt->bindParam(':cuf', $cuf);
        $stmt->execute();

        $response = $stmt->fetch(\PDO::FETCH_ASSOC);

        return json_encode($response);
    }
}

$eventoSignificativoService = new EventoSignificativoService();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if ($_POST['metodo'] === 'registroOfflineImp') {
        echo json_encode($eventoSignificativoService->guardarEventoOffline());
    } else if ($_POST['metodo'] === 'registroEventoSignificativo') {
        $params['codigoDesc'] = $_POST['codigoDesc'];
        $params['FechaInicio'] = $_POST['FechaInicio'];
        $params['FechaFinal'] = $_POST['FechaFinal'];
        $params['cafc'] = isset($_POST['cafc']) ? $_POST['cafc'] : '';
        $params['cufdEvento'] = $_POST['cufdEvento'];
        $params['codigoControl'] = $_POST['codigoControl'];
        $params['Direccion'] = $_POST['direccion'];
        $params['fechaInicioCufd'] = $_POST['fechaInicioCufd'];

        $res = $eventoSignificativoService->guardarEvento($params);
        echo json_encode($res);
    } elseif ($_POST['metodo'] === 'getEstadoAnulacion') {
        $nroFactura = $_POST['nro_factura'];
        $cuf = $_POST['cuf'];
        $res = $eventoSignificativoService->getEstadoAnulacion($nroFactura, $cuf);

        echo $res;
    }
} else if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if ($_GET['metodo'] === 'obtenerParametricasEventos') {
        $res = $eventoSignificativoService->obtenerParametricaEventos();
        echo json_encode($res);
    } else if ($_GET['metodo'] === 'getExistsEventSin') {
        $res = $eventoSignificativoService->getExistsEventSin(true);

        echo json_encode($res);
    }
}
