<?php

namespace App\ServiciosSiat;

//require('C:\xampp\htdocs\facturacion\API_REST\function\conexion_singleton.php');
require_once __DIR__ . '/../API_REST/function/conexion_singleton.php';

use Config;
date_default_timezone_set('America/La_Paz');
class ObtenerCufdPorFechas
{
    public function obtenerCufdFechas($fechaInicio, $fechaFin, $codigoEvento)
    {
        $db = Config::getConnection();
//        try {
            //echo json_encode([$fechaInicio,$fechaFin]);
            
            $codigoCafc = '';
            $sql = "SELECT *
            FROM historial_cufd  
            WHERE Finicio BETWEEN :fechaInicio AND :fechaFin AND estado = 0 LIMIT 1";

            $stmt = $db->prepare($sql);
            $stmt->bindParam(':fechaInicio', $fechaInicio);
            $stmt->bindParam(':fechaFin', $fechaFin);
            $stmt->execute();
            $data = $stmt->fetch(\PDO::FETCH_ASSOC);

            if ($codigoEvento == 5 || $codigoEvento == 6 || $codigoEvento == 7) {
                $parametroSin = $this->getParametroSiat();
                $codigoCafc = $parametroSin['codigoCafc'];
            }

            if ($data) {
                $codigoCufd['content']['fechaInicioCufd'] = trim($data['Finicio']);    
                $codigoCufd['content']['CodigoCufd'] = trim($data['CodigoCufd']);
                $codigoCufd['content']['CodigoControl'] = trim($data['CodigoControl']);
                $codigoCufd['content']['Direccion'] = trim($data['Direccion']);
                $codigoCufd['content']['codigoCafc'] = trim($codigoCafc);
                
                return $codigoCufd;
            } 
    
        /*} catch (\PDOException $e) {
            $error = $e->getMessage(); // Aquí capturamos el mensaje de error en la variable $error
            echo 'Error en la consulta SQL: ' . $error;
        }*/
    }

    function getParametroSiat()
    {
        if (!isset($_SESSION)) {
            session_start();
        }

        $userEmpresaID = json_decode($_SESSION['dataUser']);
        $db = Config::getConnection();
        $query = "SELECT * FROM parametro_sin ps
            WHERE ps.id_empresa =:id_empresa 
            ORDER BY ps.id_empresa DESC
            LIMIT 1";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id_empresa', $userEmpresaID->id_empresa);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $parametroSin = $stmt->fetch(\PDO::FETCH_ASSOC); 
            return $parametroSin;
        }
        return null;
    }

}

$claseObtenerCufdPorFechas = new ObtenerCufdPorFechas();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['metodo'] === 'obtenerCufdPorFechas') {
        $fechaIni = $_POST['fechaInicio'];
        $fechaFin = $_POST['fechaFin'];
        $codigoEvento = $_POST['codigoEvento'];
        $res = $claseObtenerCufdPorFechas->obtenerCufdFechas($fechaIni, $fechaFin,$codigoEvento);
        echo json_encode($res);
    }
}
