<?php

namespace App\ServiciosSiat;

/* require __DIR__ . '/ConfigService.php'; */

require __DIR__ . '/CufdService.php';
require_once __DIR__ . '/../API_REST/function/conexion_singleton.php';
require __DIR__ . '/../Siat/Services/ServicioOperaciones.php';
require __DIR__ . '/../Siat/SiatFactory.php';
require __DIR__ . '/../Siat/Invoices/CompraVenta.php';
require __DIR__ . '/../Siat/Invoices/ElectronicaCompraVenta.php';
require __DIR__ . '/../Siat/Services/ServicioFacturacionElectronica.php';
require __DIR__ . '/../Siat/Invoices/InvoiceDetail.php';


require __DIR__ . '/../API_REST/PHPmailer/PHPMailer.php';
require __DIR__ . '/../API_REST/dompdf/vendor/dompdf/dompdf/src/Options.php';
require __DIR__ . '/../API_REST/dompdf/vendor/dompdf/dompdf/src/Dompdf.php';
require __DIR__ . '/../API_REST/dompdf/vendor/dompdf/dompdf/src/FontMetrics.php';
require __DIR__ . '/../API_REST/function/builfFacturaMiddlePage.php';
require_once __DIR__ . '/../API_REST/dompdf/vendor/autoload.php';

use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\SiatFactory;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\DocumentTypes;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\CompraVenta;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\SiatInvoice;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioSiat;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\InvoiceDetail;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioOperaciones;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Invoices\ElectronicaCompraVenta;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionComputarizada;
use SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services\ServicioFacturacionElectronica;

use Config;
use DateTime;
use Dompdf\Dompdf;
use Dompdf\FontMetrics;
use Dompdf\Options;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class registroEventoSignificativo
{
    public $configService;
    public $cufdService;

    public function __construct()
    {
        $this->configService = new ConfigService();
        $this->cufdService = new CufdService();
    }

    public function listadoFacturasEvento() //Listado de Facturas en la vista enviar_evento_manual.html
    {
        $estadoPendiente = 'P';
        $estadoAnulacion = 0;
        $dataEvento = $this->getExistsEvent();
        $db = Config::getConnection();
        $query = "SELECT * FROM venta v WHERE v.evento_significativo_id = :codigoEvento
        AND v.fecha_venta BETWEEN :fechaInicioEvento AND  :fechaFinEvento
        AND v.estado_anulacion = :estado_anulacion AND v.estado_emision = :estadoPendiente";
        $dataEvento['FechaFinal'] = $dataEvento['CodigoDesc'] == 2 ? (new DateTime(date('Y-m-d H:i:s')))->format('Y-m-d\TH:i:s.v') : $dataEvento['FechaFinal'];

        $stmt = $db->prepare($query);
        $stmt->bindParam('codigoEvento', $dataEvento['CodigoDesc']);
        $stmt->bindParam('fechaInicioEvento', $dataEvento['FechaInicio']);
        $stmt->bindParam('fechaFinEvento', $dataEvento['FechaFinal']);
        $stmt->bindParam('estado_anulacion', $estadoAnulacion);
        $stmt->bindParam('estadoPendiente', $estadoPendiente);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $facturas = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            return $facturas;
        } else {
            $message = 'No se encontraron facturas.';
            return $message;
        }
    }

    function getFacturasEvento($dataEvento)
    {
        $estadoPendiente = 'P';
        /* Las que no han sido anuladas */
        $estadoAnulacion = 0;
        $db = Config::getConnection();
        $query = "SELECT * FROM venta v WHERE v.evento_significativo_id = :codigoEvento
        AND v.fecha_venta BETWEEN :fechaInicioEvento AND  :fechaFinEvento
        AND v.estado_anulacion = :estado_anulacion AND v.estado_emision = :estadoPendiente";
        $dataEvento['FechaFinal'] = $dataEvento['CodigoDesc'] == 2 ? (new DateTime(date('Y-m-d H:i:s')))->format('Y-m-d\TH:i:s.v') : $dataEvento['FechaFinal'];

        $stmt = $db->prepare($query);
        $stmt->bindParam('codigoEvento', $dataEvento['CodigoDesc']);
        $stmt->bindParam('fechaInicioEvento', $dataEvento['FechaInicio']);
        $stmt->bindParam('fechaFinEvento', $dataEvento['FechaFinal']);
        $stmt->bindParam('estado_anulacion', $estadoAnulacion);
        $stmt->bindParam('estadoPendiente', $estadoPendiente);
        $stmt->execute();

        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $facturas = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            return $facturas;
        }
    }

    function deleteEventoSignificativo($dataEvento)
    {
        $db = Config::getConnection();
        $query = "DELETE from evento_significativos where idEvento =:eventoID;";
        $stmt = $db->prepare($query);
        $stmt->bindParam('eventoID', $dataEvento['idEvento']);
        $stmt->execute();
        if ($stmt->execute()) {
            return true;
        }
        return false;
    }

    //! Actualizamos el Cufd despues de validar los Paquetes
    function updateCufdAfterEvent()
    {

        if (!isset($_SESSION)) {
            session_start();
        }
        $puntoVenta = $this->getPuntoVenta();
        $userData = json_decode($_SESSION['dataUser']);
        $empresaID = $userData->id_empresa;
        $responseCufd = $this->cufdService->obtenerCufd($puntoVenta['cpuntoventa'], $puntoVenta['csucursal'], $puntoVenta['ccuis']);
        $db = Config::getConnection();
        $sql = "UPDATE impuestos_cufd
        set 
        codigocufd =:codigo_cufd,
        fechavigencia=:fecha_vigencia,
        codigocontrol =:codigocontrol,
        direccion = :direccion WHERE cuis=:cuis";

        $fechaVigencia = $responseCufd->RespuestaCufd->fechaVigencia;
        $fechaVigenciaFormateada = date("Y-m-d H:i:s.000", strtotime($fechaVigencia));
        $stmt = $db->prepare($sql);
        $stmt->bindParam('codigo_cufd', $responseCufd->RespuestaCufd->codigo);
        $stmt->bindParam('fecha_vigencia', $fechaVigenciaFormateada);
        $stmt->bindParam('codigocontrol', $responseCufd->RespuestaCufd->codigoControl);
        $stmt->bindParam('direccion', $responseCufd->RespuestaCufd->direccion);
        $stmt->bindParam('cuis', $puntoVenta['ccuis']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $storeHistorialCufd = $this->cufdService->guardarHistorialCufd($responseCufd, $empresaID, $puntoVenta['ccuis']);
            if ($storeHistorialCufd) {
                return true;
            }
        }
    }

    function getParametroSiat()
    {
        if (!isset($_SESSION)) {
            session_start();
        }

        $userEmpresaID = json_decode($_SESSION['dataUser']);
        $db = Config::getConnection();
        $query = "SELECT * FROM parametro_sin ps
            WHERE ps.id_empresa =:id_empresa 
            ORDER BY ps.id_empresa DESC
            LIMIT 1";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':id_empresa', $userEmpresaID->id_empresa);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $parametroSin = $stmt->fetch(\PDO::FETCH_ASSOC);
            return $parametroSin;
        }
        return null;
    }

    function getClient($idCliente)
    {
        $db = Config::getConnection();
        $query = "SELECT * FROM  cli_cliente c WHERE c.id=:idCliente;";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':idCliente', $idCliente);
        $stmt->execute();
        $cliente = $stmt->fetch();

        return json_encode($cliente);
    }

    function getCorreosVar()
    {
        if (!isset($_SESSION)) {
            session_start();
        }

        $userEmpresaID = json_decode($_SESSION['dataUser']);

        $db = Config::getConnection();
        $sql = "SELECT * FROM impuestos_correo WHERE  id_empresa =:id_empresa LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id_empresa', $userEmpresaID->id_empresa);
        $stmt->execute();
        $response = $stmt->fetch(\PDO::FETCH_ASSOC);
        //file_put_contents('/home/rdaconsu/public_html/respuestaCorreos.txt', json_encode($response));
        return $response;
    }

    function getEstadoAnulacion($cuf)
    {
        $db = Config::getConnection();
        $sql = "SELECT evento_significativo_id,estado_anulacion FROM venta WHERE  cuf=:cuf LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':cuf', $cuf);
        $stmt->execute();

        $response = $stmt->fetch(\PDO::FETCH_ASSOC);

        return json_encode($response);
    }

    function sendMailtoCustomer($dataFactura, $dataVenta)
    {
        // Instanciar el objeto PHPMailer
        $mail = new PHPMailer(true);
        $idCliente = $dataFactura->cabecera->codigoCliente;
        $resCodigoCliente = json_decode($this->getClient($idCliente));

        try {
            // Configurar el servidor SMTP
            $mail->isSMTP();
            $mail->Host = $this->getCorreosVar()["host"];
            $mail->SMTPAuth = true;
            $mail->Username = $this->getCorreosVar()["correo"];
            $mail->Password = $this->getCorreosVar()["contrasena"];
            $mail->Port = $this->getCorreosVar()["puerto"];
            $mail->SMTPSecure = 'ssl';
            $mail->setFrom($this->getCorreosVar()["correo"]);
            $mail->addAddress($resCodigoCliente->correo);
            $mail->addCC('rdamain@rda-consultores.com', $resCodigoCliente->correo);

            // Configurar el contenido del correo
            $mail->isHTML(true);
            $mail->Subject = $this->getCorreosVar()["asunto"];
            $mail->Body = $this->getCorreosVar()["cuerpo"];
            // Adjuntar un archivo
            /* $publicPath = $_SERVER['DOCUMENT_ROOT'] . '/facturacion'; */
            //$publicPath =  'C:/xampp8/htdocs/facturacion';
            $publicPath = $_SERVER['DOCUMENT_ROOT'] . '/facturacion';
            $getDataAnulacion = json_decode($this->getEstadoAnulacion($dataFactura->cabecera->cuf));

            $evento_significativo = $getDataAnulacion->evento_significativo_id == -1 ? 0 : $getDataAnulacion->evento_significativo_id;

            $archivo = $publicPath . '/FacturasXML/factura-' . $dataFactura->cabecera->numeroDocumento . '-' . $dataFactura->cabecera->numeroFactura . '-' . $evento_significativo  . '.xml';


            $options = new Options();
            $options->set('isPhpEnabled', true);
            $options->set('isJavascriptEnabled ', true);
            $options->set('isHtml5ParserEnabled  ', true);
            $options->set('isRemoteEnabled', true);
            $options->setIsRemoteEnabled(true);

            $options->setIsHtml5ParserEnabled(true);
            $options->setIsPhpEnabled(true);
            $options->setIsJavascriptEnabled(true);
            //}
            $dompdf = new Dompdf($options);
            $dompdf->loadHtml(buildFacturaMiddlePage($dataFactura, $dataVenta));
            $dompdf->setPaper('letter', 'landscape');
            $dompdf->render();


            file_put_contents($publicPath . '/FacturasPDF/factura-' . $dataFactura->cabecera->numeroFactura . '-' . $evento_significativo . '.pdf', $dompdf->output());
            $mail->addStringAttachment($dompdf->output(), 'factura.pdf');
            $mail->addAttachment($archivo);
            // Enviar el correo
            $mail->send();
        } catch (Exception $e) {
            throw $e;
        }
    }

    public function registrarEventoImpuesto() //! Aqui Hago el Envio de Paquetes a Impuestos
    {
        $dataEvento = $this->getExistsEvent();
        $codigoEvento = $dataEvento['CodigoDesc'];
        $fechaInicioEvento = (new DateTime($dataEvento['FechaInicio']))->format('Y-m-d\TH:i:s.v');
        $fechaFinEvento = (new DateTime($dataEvento['FechaFinal']))->format('Y-m-d\TH:i:s.v');
        $codigoSucursal = $dataEvento['CodigoSucursal'];
        $codigoPuntoVenta = $dataEvento['CodigoPVenta'];
        $cufdEvento = $dataEvento['CufdEvento'];
        $codigoControlEvento = $dataEvento['CodigoControl'];
        $cafc = $dataEvento['Cafc'];
        $tipoFactura = $this->configService->tipoFactura;
        $arrayFacturas = $this->getFacturasEvento($dataEvento);

        $cantidadFacturas = count($arrayFacturas);

        // ? Verifico si el nro de facturas esta dentro del rango del CAFC solo EVENTO 5,6,7
        //$fueraNumeracion = false;
        if ($codigoEvento == 5  || $codigoEvento == 6 || $codigoEvento == 7) {
            $numeracionCafc = $this->getParametroSiat();
            
            $numeracionInicio = $numeracionCafc['desde']; // 1
            $numeracionFin = $numeracionCafc['hasta']; // 100
            foreach ($arrayFacturas as $factura) {
                $nroFactura = $factura['nro_factura'];
                
                if ($nroFactura >= $numeracionInicio and $nroFactura <= $numeracionFin) {
                    //$fueraNumeracion = true;
                    break;
                } else {
                    $mensajeNumeracion =  'La Numeracion de Facturas, No Corresponde con la Numeracion del CAFC';
                    return [
                        "transaccion" => false,
                        "message" => $mensajeNumeracion
                    ];
                }
            }
            /* if ($fueraNumeracion) {
                $mensajeNumeracion =  'La Numeracion de Facturas, No Corresponde con la Numeracion del CAFC';
                return $mensajeNumeracion;
            } */
        }
        
        /* Temporal xd */
        $codigoDocumentoSector = 1;
        $dataPuntoVenta = $this->getPuntoVenta();
        $empresa = $dataPuntoVenta['id_empresa'];
        $codigoCuis = $dataPuntoVenta['ccuis'];
        $resNuevoCufd = $this->cufdService->obtenerCufd($codigoPuntoVenta, $codigoSucursal, $dataPuntoVenta['ccuis']); //TODO Falta Pedir Nuevo Cufd, Actualizarlo e Insertar en el historial  
        /* $updateCufd = $this->cufdService->updateCufdEvento($resNuevoCufd,$codigoCuis);*/
        $storeHistorialCufd = $this->cufdService->guardarHistorialCufd($resNuevoCufd, $empresa, $codigoCuis);
        $serviceOps = new ServicioOperaciones();
        $serviceOps->setConfig((array)$this->configService->config);
        $serviceOps->cuis = $dataPuntoVenta['ccuis'];
        $serviceOps->cufd = $resNuevoCufd->RespuestaCufd->codigo; //Aca solicitar nuevo CUFD

        $resEvent = $serviceOps->registroEventoSignificativo( //? Registro Evento Impuestos
            $dataEvento['CodigoDesc'], /* Codigo Evento */
            $dataEvento['Descripcion'],
            $dataEvento['CufdEvento'],
            $fechaInicioEvento,
            $fechaFinEvento,
            $dataEvento['CodigoSucursal'],
            $dataEvento['CodigoPVenta']
        ); //Envia Evento y Registra en Impuesto
        
        

        if (!isset($resEvent->RespuestaListaEventos->codigoRecepcionEventoSignificativo)) {
            $codigoExcepcion =  $resEvent->RespuestaListaEventos->mensajesList->codigo;
            if ($codigoExcepcion === 914 || $codigoExcepcion === 981 || $codigoExcepcion === 984) {
                return [
                    'transaccion' => false,
                    'msg' => $resEvent->RespuestaListaEventos->mensajesList->descripcion
                ]; 
            }
        }
        $resEvento = 1; //Temporal
        if (isset($resEvent->RespuestaListaEventos->codigoRecepcionEventoSignificativo)) {
            $resEvento = $resEvent->RespuestaListaEventos->codigoRecepcionEventoSignificativo;
        }

        $facturasConstruidas = $this->construirFacturas($codigoSucursal, $codigoPuntoVenta, $cantidadFacturas, $codigoDocumentoSector, $cufdEvento, $cafc, $arrayFacturas);
        //TODO Falta Pedir Nuevo Cufd, Actualizarlo e Insertar en el historial  
        $resPaquetes = $this->testPaquetes($codigoSucursal, $codigoPuntoVenta, $facturasConstruidas, $codigoControlEvento, $codigoCuis, $tipoFactura, $resEvento, $cafc, $codigoEvento);
        //echo json_encode($resPaquetes);
        if (isset($resPaquetes->RespuestaServicioFacturacion->codigoRecepcion)) {
            $codigoRecepcionPaquete =  $resPaquetes->RespuestaServicioFacturacion->codigoRecepcion;
            $resRecepcionPaquete = $this->testRecepcionPaquete($codigoSucursal, $codigoPuntoVenta, $codigoDocumentoSector, $tipoFactura, $codigoRecepcionPaquete, $codigoCuis, $cufdEvento);
            if ($resRecepcionPaquete->RespuestaServicioFacturacion->codigoEstado === 908) {
                foreach ($facturasConstruidas as $factura) { //Actualizar estado de: "P" a: "V" y  enviar Correo
                    $cufFactura = $factura->cabecera->cuf;
                    $resUpdate = $this->updateFacturaEvento($factura, $cufFactura);
                    if ($resUpdate) { //TODO Enviar Correo
                        $getFacturaEvento = $this->getFacturaEvento($cufFactura);
                        if ($getFacturaEvento['evento_significativo_id'] == 2 || $getFacturaEvento['evento_significativo_id'] == 5 || $getFacturaEvento['evento_significativo_id'] == 6 || $getFacturaEvento['evento_significativo_id'] == 7) { //? Si es 2 no es necesario volver a enviar el Correo porque ya se ha enviado                             */
                            $updateLastCufd = $this->updateCufdAfterEvent();
                            $deleteEvento = $this->deleteEventoSignificativo($dataEvento);
                        } else {
                            $this->sendMailtoCustomer($factura, $getFacturaEvento);
                            $updateLastCufd = $this->updateCufdAfterEvent();
                            $deleteEvento = $this->deleteEventoSignificativo($dataEvento);
                        }
                        $updateLastCufd = $this->updateCufdAfterEvent();
                    }
                }
                $deleteEvento = $this->deleteEventoSignificativo($dataEvento);
                if ($updateLastCufd && $deleteEvento) {
                    return [
                        'transaccion' => true,
                        'msg' => 'Paquete de Facturas Validados Exitosamente!'
                    ];
                } else {
                    return [
                        'transaccion' => false,
                        'msg' => 'Error al Generar Ultimo Cufd!'
                    ];
                }
            } else {
                if ($resRecepcionPaquete->RespuestaServicioFacturacion->codigoEstado === 904) {
                    return [
                        'transaccion' => false,
                        'msg' => gettype($resRecepcionPaquete->RespuestaServicioFacturacion->mensajesList) == "array" ? $resRecepcionPaquete->RespuestaServicioFacturacion->mensajesList : $resRecepcionPaquete->RespuestaServicioFacturacion->mensajesList->descripcion
                    ];
                }
            }
        } else {
            $codigoResPaquete = $resPaquetes->RespuestaServicioFacturacion->codigoEstado;
            if ($codigoResPaquete === 902 || $codigoResPaquete === 901) {
                $errorPaqueteRecepcion = $resPaquetes->RespuestaServicioFacturacion->mensajesList;
                return [
                    'transaccion' => false,
                    'msg' => $errorPaqueteRecepcion
                ];
            }
        }
        return [
            'transaccion' => true,
            'msg' => $resEvent
        ];
    }

    function testPaquetes($codigoSucursal, $codigoPuntoVenta, $facturas, $codigoControlEvento, $codigoCuis, $tipoFactura, $resEvento, $cafc, $codigoEvento) //?Aqui  Envio el Paquete de las Facturas con el codigoRecepcion que me dio al Registrar Evento
    {

        if ($cafc == "") {
            $cafc = null;
        }
        $dataCufd = $this->obtenerCufd();
        $service = SiatFactory::obtenerServicioFacturacion($this->configService->config, $codigoCuis, $dataCufd['codigocufd'], $codigoControlEvento);

        $res = $service->recepcionPaqueteFactura(
            $facturas,
            $resEvento,
            SiatInvoice::TIPO_EMISION_OFFLINE,
            $tipoFactura,
            $cafc,
            $codigoEvento
        );



        return $res;
    }

    function testRecepcionPaquete($codigoSucursal, $codigoPuntoVenta, $codigoDocumentoSector, $tipoFactura, $codigoRecepcionPaquete, $codigoCuis, $cufdEvento) //? Hago la Validacion del Paquete y sus Facturas
    {
        /* $service = new ServicioFacturacionComputarizada( 
            $codigoCuis,
            $cufdEvento
        ); */

        $service = new ServicioFacturacionElectronica($codigoCuis,
        $cufdEvento);
        $service->setConfig((array)$this->configService->config);
        $res = $service->validacionRecepcionPaqueteFactura($codigoSucursal, $codigoPuntoVenta, $codigoRecepcionPaquete, $tipoFactura, $codigoDocumentoSector); //Valido el Paquete Enviado

        while ($res->RespuestaServicioFacturacion->codigoDescripcion == 'PENDIENTE') {
            $res = $this->testRecepcionPaquete($codigoSucursal, $codigoPuntoVenta, $codigoDocumentoSector, $tipoFactura, $codigoRecepcionPaquete, $codigoCuis, $cufdEvento);
        }

        return $res;
    }

    function construirFacturas($sucursal, $puntoventa, int $cantidad, $documentoSector, $cufdAntiguo = null, $cafc = null, $arrayFacturas)
    {

        $facturas = [];
        $fechaEmision = date('Y-m-d\TH:i:s.v');
        for ($i = 0; $i < $cantidad; $i++) {
            $factura = $this->construirFactura($puntoventa, $sucursal, $cantidad, $this->configService->config->modalidad, $documentoSector, $cufdAntiguo, $cafc, $arrayFacturas[$i]);
            $factura->cabecera->nitEmisor = $this->configService->config->nit;
            $factura->cabecera->razonSocialEmisor = $this->configService->config->razonSocial;
            /* $factura->cabecera->fechaEmision =  date( 'Y-m-d\TH:i:s.v');
            */
            //Fecha Ingreso Manual Venta
            $factura->cabecera->cufd = $cufdAntiguo;
            $facturas[] = $factura;
            /* $fechaEmision = date( 'Y-m-d\TH:i:s.v', strtotime( $fechaEmision ) + 10 );
            */
        }

        return $facturas;
    }

    function updateFacturaEvento($factura, $cufFactura)
    {
        $db = Config::getConnection();
        $estadoEmision = "V";
        $data_factura = json_encode($factura);
        $query = "UPDATE venta SET estado_emision=:estado_emision, data_factura=:data_factura
        WHERE cuf=:cuf";
        $stmt = $db->prepare(($query));
        $stmt->bindParam('estado_emision', $estadoEmision);
        $stmt->bindParam('cuf', $cufFactura);
        $stmt->bindParam('data_factura', $data_factura);
        $stmt->execute();
        if ($stmt->execute()) {
            return true;
        } else {
            return false;
        }
    }

    function getFacturaEvento($cufFactura)
    {
        $db = Config::getConnection();

        $query = "SELECT * FROM venta
        WHERE cuf=:cuf";
        $stmt = $db->prepare(($query));

        $stmt->bindParam('cuf', $cufFactura);
        $stmt->execute();
        $dataVenta = $stmt->fetch();
        return $dataVenta;
    }

    function getExistsEvent()
    {
        $data = $this->getPuntoVenta();
        $db = Config::getConnection();

        $sql = "SELECT * FROM evento_significativos
         WHERE CodigoSucursal=:CodigoSucursal AND CodigoPVenta=:CodigoPVenta";

        $stmt = $db->prepare($sql);
        $stmt->bindParam('CodigoSucursal', $data['csucursal']);
        $stmt->bindParam('CodigoPVenta', $data['cpuntoventa']);
        $stmt->execute();
        $eventoRegistrado = $stmt->fetch();
        return $eventoRegistrado;
    }

    function getPuntoVenta()
    {
        if (!isset($_SESSION)) {
            session_start();
        }
        $userData = json_decode($_SESSION['dataUser']);
        $userID = $userData->id;
        $empresaUser = $userData->id_empresa;
        $estado = 1;
        $db = Config::getConnection();
        $query = "SELECT * from puntodeventa p 
          join puntos_ventas_user pvu on pvu.tipo_pv = p.cpuntoventa 
          where pvu.user_id = :user_id
          and p.id_empresa = :id_empresa
          and p.estado = :estado LIMIT 1; ";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':user_id', $userID);
        $stmt->bindParam(':id_empresa', $empresaUser);
        $stmt->bindParam(':estado', $estado);
        $stmt->execute();
        $data = $stmt->fetch();
        return $data;
    }

    function obtenerCLiente($dataFactura)
    {
        $data = (object) $dataFactura;
        $id_cliente = intval($data->id_cliente);
        $db = Config::getConnection();
        $sql = "SELECT *
         FROM cli_cliente
         WHERE id=:id 
         LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $id_cliente);
        $stmt->execute();
        $cliente = $stmt->fetch();
        return json_encode($cliente);
    }

    function obtenerProducto($det)
    {
        $producto_id = $det['id_producto'];
        $db = Config::getConnection();
        $sql = 'SELECT * FROM `pro_producto` WHERE  id=:id LIMIT 1';
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $producto_id);
        $stmt->execute();
        $producto = $stmt->fetch(\PDO::FETCH_ASSOC);
        return json_encode($producto);
    }

    function getInvoiceDetail($facturaID)
    {
        $db = Config::getConnection();
        $query = 'SELECT * FROM det_venta dv  where id_venta =:factura_id;';
        $stmt = $db->prepare($query);
        $stmt->bindParam(':factura_id', $facturaID);
        $stmt->execute();
        $detalleFactura = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        return $detalleFactura;
    }

    function obtenerCufd()
    {
        $codigoCuis = $this->configService->config->cuis;
        $db = Config::getConnection();
        $sql = "SELECT *
        FROM impuestos_cufd
        WHERE cuis=:cuis
        ORDER BY idcufd DESC
        LIMIT 1";
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':cuis', $codigoCuis);
        $stmt->execute();
        $cufd = $stmt->fetch();
        return $cufd;
    }

    function obtenerUsuario($dataFactura)
    {
        $data = (object)($dataFactura);
        $usuario_id = $data->id_usuario;
        $db = Config::getConnection();
        $sql = 'SELECT * from per_usuarios WHERE  id=:id LIMIT 1';
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':id', $usuario_id);
        $stmt->execute();
        $usuario = $stmt->fetch();
        return json_encode($usuario);
    }

    function construirFactura($puntoventa, $sucursal, $cantidadFacturas, $modalidad, $documentoSector, $cufdAntiguo, $cafc, $dataFactura)
    {
        $subTotal = 0;
        $factura = null;
        $modalidad = $this->configService->config->modalidad;
        $codigoSucursal = $this->configService->sucursal;
        $detailClass = InvoiceDetail::class;
        if ($modalidad == ServicioSiat::MOD_ELECTRONICA_ENLINEA) {
            if ($documentoSector == DocumentTypes::FACTURA_COMPRA_VENTA)
                $factura = new ElectronicaCompraVenta();
        } else {
            if ($documentoSector == DocumentTypes::FACTURA_COMPRA_VENTA)
                $factura = new CompraVenta();
        }
        $dataCliente = json_decode($this->obtenerCLiente($dataFactura));
        $usuarioData = json_decode($this->obtenerUsuario($dataFactura));
        $obtenerCufd = $this->obtenerCufd();
        $detalleFacturas = $this->getInvoiceDetail($dataFactura['id']);

        foreach ($detalleFacturas as $det) {
            $resProducto = json_decode($this->obtenerProducto($det)); //Muere

            $det = (object)$det;
            $detalle = new $detailClass();
            $detalle->actividadEconomica    = $resProducto->id_homologacion;
            //?CODIGO ACTIVIDAD
            $detalle->codigoProductoSin        = $resProducto->codigo_actividad;
            //CODIGO PRODUCTO
            $detalle->codigoProducto        = $det->id_producto;
            $detalle->descripcion            = $resProducto->nombre;
            $detalle->cantidad                =  $det->cantidad;
            $detalle->unidadMedida          = $resProducto->id_unidad_medida;
            $detalle->precioUnitario        = $det->precio;

            if ($dataFactura['evento_significativo_id'] == 1) {

                $detalle->montoDescuento = (empty($det->descuento_item) ? 0 : $det->descuento_item) * $det->cantidad;
                $detalle->subTotal       = number_format((float)$det->costo, 2, '.', '');
            } else if ($dataFactura['evento_significativo_id'] == 3 || $dataFactura['evento_significativo_id'] == 4) {

                $detalle->montoDescuento   = (empty($det->descuento_item) ? 0 : $det->descuento_item) * $det->cantidad;
                $detalle->subTotal         = number_format((float)($det->costo), 2, '.', '');
            } else if ($dataFactura['evento_significativo_id'] == 5 || $dataFactura['evento_significativo_id'] == 6 || $dataFactura['evento_significativo_id'] == 7) {

                $detalle->montoDescuento   = (empty($det->descuento_item) ? 0 : $det->descuento_item) * $det->cantidad;
                $detalle->subTotal         = number_format((float)($det->costo), 2, '.', '');
            } else {
                $detalle->montoDescuento   = (empty($det->descuento_item) ? 0 : $det->descuento_item) * $det->cantidad;
                $detalle->subTotal             = number_format((float)($det->costo - $detalle->montoDescuento), 2, '.', '');
            }

            $subTotal += $detalle->subTotal;
            $subTotal += $detalle->subTotal;
            $factura->detalle[] = $detalle;
        }

        $factura->cabecera->razonSocialEmisor    = $this->configService->config->razonSocial;
        $factura->cabecera->municipio            = $this->configService->config->ciudad;
        $factura->cabecera->telefono            = $this->configService->config->telefono;
        $factura->cabecera->numeroFactura        = intval($dataFactura['nro_factura']);
        $factura->cabecera->cuf                 = $dataFactura['cuf'];
        $factura->cabecera->codigoSucursal        = $codigoSucursal;
        $factura->cabecera->direccion            = $obtenerCufd['direccion'];
        $factura->cabecera->codigoPuntoVenta    = $dataFactura['punto_venta_id'];
        $factura->cabecera->fechaEmision        = (new DateTime($dataFactura['fecha_venta']))->format('Y-m-d\TH:i:s.v');   /*  date('Y-m-d\TH:i:s.v'); */
        $factura->cabecera->codigoTipoDocumentoIdentidad    = $dataCliente->tipo_documento_id;
        $factura->cabecera->codigoMetodoPago    = $dataFactura['tipo_pago'];
        $factura->cabecera->numeroTarjeta       = $dataFactura['tarjeta'];

        if ($dataCliente->tipo_documento_id == 1 || $dataCliente->tipo_documento_id == 2 || $dataCliente->tipo_documento_id == 3 || $dataCliente->tipo_documento_id == 4) {
            $codigoExcepcionNit = 0;
        } else {
            $codigoExcepcionNit = 1;
        }

        if ($dataFactura['evento_significativo_id'] == 1 || $dataFactura['evento_significativo_id'] == 3 || $dataFactura['evento_significativo_id'] == 4 || $dataFactura['evento_significativo_id'] == 5 || $dataFactura['evento_significativo_id'] == 6 || $dataFactura['evento_significativo_id'] == 7) {
            $dataFactura['total'] = $dataFactura['total'] /*- $dataFactura['descuento']*/;
        }

        $factura->cabecera->codigoCliente        = $dataCliente->id;
        $factura->cabecera->nombreRazonSocial    = htmlspecialchars($dataCliente->nombre);
        $factura->cabecera->numeroDocumento        = $dataCliente->nit;
        $factura->cabecera->complemento        = isset($dataCliente->complemento) ? $dataCliente->complemento : '';
        $factura->cabecera->montoTotal            = $dataFactura['total'];
        $factura->cabecera->montoTotalMoneda    = $dataFactura['total'];
        $factura->cabecera->montoTotalSujetoIva    = $dataFactura['total'] -  $dataFactura['monto_giftcard'];
        $factura->cabecera->montoGiftCard = $dataFactura['monto_giftcard'];
        if ($cafc != "") {
            $factura->cabecera->cafc            = $cafc;
        }
        $factura->cabecera->codigoMoneda        = $dataFactura['moneda_id'];
        $factura->cabecera->tipoCambio            =  $dataFactura['moneda_id'];
        $factura->cabecera->descuentoAdicional    = $dataFactura['descuento'];
        $factura->cabecera->codigoExcepcion           = $codigoExcepcionNit; /* $codigoVerificarNit == 986 ? 0 : 1 */;
        $factura->cabecera->leyenda                 = $dataFactura['leyenda'];
        $factura->cabecera->usuario                = $usuarioData->nombre;

        return $factura;
    }
}

$resRegistroEvento = new registroEventoSignificativo();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($_POST['metodo'] === 'obtenerListadoFacturasEvento') {
        $res = $resRegistroEvento->listadoFacturasEvento();
        echo json_encode($res);
    } else {
        if ($_POST['metodo'] === 'envioPaquetesManual') {
            $resEnvio = $resRegistroEvento->registrarEventoImpuesto();
            echo json_encode($resEnvio);
        }
    }
}
