<?php

namespace SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services;

use \Config as ConfiguracionDB;
use App\ServiciosSiat\ConfigService;

/**
 * Clases para el servicio de obtencion de codigos CUIS y CUF
 * @author mac
 *
 */
class ServicioFacturacionCodigos extends ServicioSiat
{
	protected $wsdl;

	protected function getLinkSincro()
	{
		$id_empresa = (new ConfigService())->getTaxesInfoUser()[1]['id'];

		$db = ConfiguracionDB::getConnection();
		$sql = "SELECT * FROM `linksin` WHERE  id_empresa=:id LIMIT 1";
		$stmt = $db->prepare($sql);
		$stmt->bindParam(':id', $id_empresa);
		$stmt->execute();
		$allLinks = $stmt->fetch(\PDO::FETCH_ASSOC);

		return json_encode($allLinks);
	}

	public function cuis($codigoPuntoVenta, $codigoSucursal)
	{
		$linkSincronizacion = json_decode($this->getLinkSincro(), true);
		$this->wsdl = $linkSincronizacion['linkcodigos'];

		$data = [
			[
				'SolicitudCuis' => [
					'codigoAmbiente'	=> $this->ambiente,
					'codigoModalidad'	=> $this->modalidad,
					'codigoPuntoVenta'	=> $codigoPuntoVenta,
					'codigoSistema'		=> $this->codigoSistema,
					'codigoSucursal'	=> $codigoSucursal,
					'nit'				=> $this->nit,
				]
			]
		];
		list(, $action) = explode('::', __METHOD__);
		$res = $this->callAction($action, $data);

		return $res;
	}
	public function cufd($codigoPuntoVenta = 0, $codigoSucursal = 0)
	{
		$linkSincronizacion = json_decode($this->getLinkSincro(), true);
		$this->wsdl = $linkSincronizacion['linkcodigos'];

		list(, $action) = explode('::', __METHOD__);
		$data = [
			[
				'SolicitudCufd' => [
					'codigoAmbiente'	=> $this->ambiente,
					'codigoModalidad'	=> $this->modalidad,
					'codigoPuntoVenta'	=> $codigoPuntoVenta,
					'codigoSistema'		=> $this->codigoSistema,
					'codigoSucursal'	=> $codigoSucursal,
					'cuis'				=> $this->cuis,
					'nit'				=> $this->nit,
				]
			]
		];
		$res = $this->callAction($action, $data);

		return $res;
	}
}
