<?php

namespace SinticBolivia\SBFramework\Modules\Invoices\Classes\Siat\Services;

require __DIR__ . '/ServicioFacturacion.php';

use \Config as ConfiguracionDB;
use App\ServiciosSiat\ConfigService;

/**
 * Clase para el servicio de Facturacion Computarizada en linea
 * @author J. Marcelo Aviles
 * 
 *
 */
class ServicioFacturacionComputarizada extends ServicioFacturacion
{
	protected	$wsdl;

	protected function getLinkSincro()
	{
		$id_empresa = (new ConfigService())->getTaxesInfoUser()[1]['id'];

		$db = ConfiguracionDB::getConnection();
		$sql = "SELECT * FROM `linksin` WHERE  id_empresa=:id LIMIT 1";
		$stmt = $db->prepare($sql);
		$stmt->bindParam(':id', $id_empresa);
		$stmt->execute();
		$allLinks = $stmt->fetch(\PDO::FETCH_ASSOC);

		return json_encode($allLinks);
	}
	
	public function __construct($cuis = null, $cufd = null, $token = null, $endpoint = null)
	{
		$linkSincronizacion = json_decode($this->getLinkSincro(), true);
		$this->wsdl = $linkSincronizacion['linkcompraventa'];

		parent::__constructor($cuis, $cufd, $token, $endpoint);
		/* parent::__construct($cuis, $cufd, $token, $endpoint); */
		//$this->modalidad = self::MOD_COMPUTARIZADA_ENLINEA;
	}
}
