let clientes = [];
var $table = $("#table");
let id_cliente = 0;
let id_empresa = 0;
let cadena;
// $(document).ready(function() {
//     cargar_tabla();
// });
$(function () {
  $table.bootstrapTable("refreshOptions", {
    locale: "es-AR",
  });
});

function llenarSelectDocumentoIdentidad() {
  $.ajax({
    url: urlServicio + "API_REST/cargarDocumentosIdentidades",
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      var documento = $("#tipo_documento_id").html("");
      if (d.errorCode == 0) {
        let res = d.msg;
        console.log(res);
        documentos = res.documento;
        for (let index = 0; index < res.documento.length; index++) {
          const element = res.documento[index];
          if (index == 0) {
            documento.append(
              '<option selected value="' +
                element.codigoclasificador +
                '">' +
                element.descripcion +
                "</option>"
            );
          } else {
            documento.append(
              '<option value="' +
                element.codigoclasificador +
                '">' +
                element.descripcion +
                "</option>"
            );
          }
        }
      }
    },
    error: error,
  });
}

function cargar_tabla() {
  $("#fecha_nac").val(moment().format("YYYY-MM-DD"));
  id_empresa = usuario.id_empresa;
  $.ajax({
    url: urlServicio + "API_REST/cargar_cliente_chofer/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      llenarSelectDocumentoIdentidad();
      $(".caja_loader").hide();

      if (d.errorCode == 0) {
        let res = d.msg;
        for (let index = 0; index < res.length; index++) {
          const element = res[index];

          element.editar =
            '<a data-edit="' +
            element.id +
            '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
          element.eliminar =
            '<a data-delete="' +
            element.id +
            '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

          clientes.push(element);
        }

        data_table_cargar(clientes);
      }
    },
    error: error,
  });
}
$(document).on("click", ".edit", function (e) {
  var t = this.dataset.edit;
  id_cliente = t;
  agregar_tabla(t);
});
$(document).on("click", ".delete", function (e) {
  let t = this.dataset.delete;
  Snackbar.show({
    text: "Eliminar cliente?.",
    pos: "top-center",
    actionText: "Si",
    onActionClick: function (element) {
      eliminar_cliente(t);
    },
  });
});
$(".delete").click(function () {
  //eliminar_cliente(this.dataset.delete)
});

function agregar_tabla(id) {
  let datos = $table.bootstrapTable("getRowByUniqueId", id);
  $("#nombre").val(datos.nombre);
  $("#nit").val(datos.nit);
  $("#telefono").val(datos.telefono);
  $("#direccion").val(datos.direccion);
  $("#correo").val(datos.correo);
  $("#fecha_nac").val(datos.fecha_nac);
  $("#tipo_documento_id").val(datos.tipo_documento_id);

  $("html, body").animate(
    {
      scrollTop: $("#nombre").offset().top - 100,
    },
    500
  );
}
$(".guardar").click(function () {
  if (
    validar($("#nombre")) &&
    validar($("#nit")) &&
    validar($("#telefono")) &&
    validar($("#direccion"))
  ) {
    $(".caja_loader").show();

    var datos = {};
    datos.nombre = $("#nombre").val();
    datos.nit = $("#nit").val();
    datos.complemento = $("#complemento").val();
    datos.telefono = $("#telefono").val();
    datos.direccion = $("#direccion").val();
    datos.correo = $("#correo").val();
    datos.fecha_nac = $("#fecha_nac").val();
    datos.tipo_documento_id = $("#tipo_documento_id").val();
    datos.id_empresa = usuario.id_empresa;
    if (id_cliente > 0) {
      datos.id = id_cliente;
      actualizar_cliente(datos);
    } else {
      insertar_cliente(datos);
    }
  }
});
$(".cancelar").click(function () {
  limpiar();
});

function insertar_cliente(datos) {
  let aray = [];
  var enviar = JSON.stringify(datos);

  $.ajax({
    url: urlServicio + "API_REST/insertar_cliente",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();

      if (d["errorCode"] == 0) {
        Snackbar.show({ text: "Se inserto correctamente.", pos: "top-center" });
        datos.id = d.msg;
        datos.editar =
          '<a data-edit="' +
          d.msg +
          '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
        datos.eliminar =
          '<a data-delete="' +
          d.msg +
          '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
        aray.push(datos);
        $table.bootstrapTable("append", aray);
        limpiar();
      } else {
        Snackbar.show({ text: "Error al insertar.", pos: "top-center" });
      }
    },
    error: error,
  });
}

function actualizar_cliente(datos) {
  var enviar = JSON.stringify(datos);
  $.ajax({
    url: urlServicio + "API_REST/actualizar_cliente_chofer",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();

      if (d["errorCode"] == 0) {
        Snackbar.show({
          text: "Se actualizo correctamente.",
          pos: "top-center",
        });

        $table.bootstrapTable("updateByUniqueId", {
          id: id_cliente,
          row: {
            nombre: $("#nombre").val(),
            nit: $("#nit").val(),
            telefono: $("#telefono").val(),
            direccion: $("#direccion").val(),
            correo: $("#correo").val(),
          },
        });
        limpiar();
      } else {
        limpiar();
        Snackbar.show({
          text: "Se actualizo correctamente.",
          pos: "top-center",
        });
      }
    },
    error: error,
  });
}

function eliminar_cliente(id_) {
  var datos = {};
  datos.id = id_;

  var enviar = JSON.stringify(datos);

  $.ajax({
    url: urlServicio + "API_REST/eliminar_cliente_chofer",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".loader").toggle();
      if (d["errorCode"] == 0) {
        Snackbar.show({
          text: "Se elimino correctamente.",
          pos: "top-center",
          actionText: "cerrar",
        });

        $table.bootstrapTable("removeByUniqueId", id_);
        limpiar();
      }
    },
    error: error,
  });
}

function limpiar() {
  id_cliente = 0;
  $("#nombre").val("");
  $("#nit").val("");
  $("#telefono").val("");
  $("#direccion").val("");
  $("#correo").val("");
}

//////////excel
$(".descargar").click(function () {
  crear_excel();
});

function crear_excel() {
  var cabeceras = [];
  var Datas = {
    // We will make a Workbook contains 2 Worksheets
    datos: [
      {
        nombre: "",
        nit: "",
        correo: "",
        telefono: "",
        direccion: "",
      },
    ],
  };

  var wb = XLSX.utils.book_new(); // make Workbook of Excel
  var animalWS = XLSX.utils.json_to_sheet(Datas.datos, {
    fecha_vencimineto: "yyyy-mm-dd",
  });
  //var pokemonWS = XLSX.utils.json_to_sheet(productos);

  // add Worksheet to Workbook
  // Workbook contains one or more worksheets
  XLSX.utils.book_append_sheet(wb, animalWS, "Datos"); // sheetAName is name of Worksheet
  //XLSX.utils.book_append_sheet(wb, pokemonWS, 'Productos');

  // export Excel file
  XLSX.writeFile(wb, "formato_cliente.xlsx");
}
$("#archivo").change(function (e) {
  archivo_cargadov2(e);
});

function verificar_excel() {
  let costo = 0;
  cadena.forEach((element) => {
    costo += parseFloat(element.costo_lote);
  });
  return costo;
}
$(".subir").click(function () {
  if (cadena) {
    subir_archivo(cadena);
  }
});

function archivo_cargadov2(e) {
  var reader = new FileReader();
  var selectedFile = e.target.files[0];

  reader.onload = function (event) {
    var data = event.target.result;
    var workbook = XLSX.read(data, {
      type: "binary",
      cellDates: true,
      cellNF: false,
      cellText: false,
      cellStyles: true,
    });
    //  workbook.SheetNames.forEach(function(sheetName) {
    var XL_row_object = XLSX.utils.sheet_to_row_object_array(
      workbook.Sheets.Datos
    );
    cadena = XL_row_object;
  };
  reader.onerror = function (event) {
    console.error("Error" + event.target.error.code);
  };
  reader.readAsBinaryString(selectedFile);
}

function subir_archivo(archivo) {
  $(".caja_loader").show();
  var datos = {};
  datos.id_empresa = id_empresa;
  datos.detalle = archivo;
  var enviar = JSON.stringify(datos);
  console.log(datos);
  $.ajax({
    url: urlServicio + "API_REST/subir_clientes",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();
      if (d["errorCode"] == 0) {
        Snackbar.show({
          text: "Se subio correctamente.",
          pos: "top-center",
          actionText: "cerrar",
        });
        setTimeout(() => {
          window.location.reload();
        }, 1500);
        limpiar();
      } else {
        Snackbar.show({
          text: "Error al subir.",
          pos: "top-center",
          actionText: "cerrar",
        });
      }
    },
    error: error,
  });
}
