let fecha_ago = moment().subtract(7, 'days').format('YYYY-MM-DD');
let fecha_ = moment().format('YYYY-MM-DD');
$("#fecha_ini").val(fecha_ago);
$("#fecha_fin").val(fecha_);

$("#btn_buscar").click(function() {
    $("#loading-wrapper").fadeIn();
    cargar_tabla();
});

function cargar_tabla() {
    let id_empresa = usuario.id_empresa;
    let fecha_ini = $("#fecha_ini").val();
    let fecha_fin = $("#fecha_fin").val();
    $(".nombre").text('Bienvenido ' + usuario.nombre);
    $.ajax({
        url: urlServicio + 'API_REST/cargar_datos_dashboard/' + id_empresa + '/' + fecha_ini + '/' + fecha_fin,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $("#loading-wrapper").fadeOut(3000);
            if (d.errorCode == 0) {
                let datos = d.msg;

                $(".clientes").text(datos.clientes);
                $(".compras").text(datos.compras);
                $(".ventas").text(datos.ventas);
                if (datos.ventas_dash.length > 0) {
                    let fecha = [];
                    let ventas = [];
                    for (let index = 0; index < datos.ventas_dash.length; index++) {
                        const element = datos.ventas_dash[index];
                        fecha.push(element.fecha);
                        ventas.push(element.venta);
                    }
                    armar_dash(fecha, ventas);

                }
            }
        },
        error: error


    });
}

function armar_dash(fecha, venta) {
    var chart;
    $("#chart").html('');
    console.log(fecha);
    var options = {
        chart: {
            type: 'line'
        },
        series: [{
            name: 'Ventas',
            data: venta
        }],
        xaxis: {
            categories: fecha
        }
    }

    chart = new ApexCharts(document.querySelector("#chart"), options);

    chart.render();
}