let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let url_imagen = 'img/';
let $table_empresas = $('#table_empresas');
// $(document).ready(function() {
//     cargar_tabla();
// });
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
$("#img").click(function() {
    $("#fimagen").click();
});
$("#fimagen").change(function() {
    var ext = this.value.match(/\.([^\.]+)$/)[1];
    switch (ext) {
        case 'jpg':
        case 'jpeg':
        case 'bmp':
        case 'png':
        case 'tif':
            var file = this.files[0];
            var reader = new FileReader();
            reader.onload = function(e) {
                var data = e.target.result;
                $('#img').attr("src", data);
                actualizar_imagen(data)
            };
            reader.readAsDataURL(file);
            break;
        default:
            $('#img').attr("src", "img/500.png");
            alert('Imagen no soportada');
            imagen = 'sin_imagen';

            this.value = '';
    }

});

function cargar_tabla() {
    let id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_empresa_u/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let datos = d.msg;

                $("#nombre").val(datos.nombre);
                $("#nit").val(datos.nit);
                $("#descripcion").val(datos.descripcion);
                $("#rubro").val(datos.rubro);
                $("#tipo_impresion").val(datos.tipo_impresion);
                $("#cumple").val(datos.cumple);
                if (datos.foto != 'sin_imagen') {
                    $("#img").attr("src", url_imagen + id_empresa + '/' + datos.foto);

                }
            }
            mostrar_empresas();
        },
        error: error


    });
}

function mostrar_empresas() {
    $.ajax({
        url: urlServicio + 'API_REST/ver_plan_empresa_id/' + usuario.id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            if (d.errorCode == 0) {
                let res = d.msg;
                data_table_cargar_1(res, $table_empresas);
                $("#modal_empresas").modal('show');
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_sucursal(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#nombre_factura").val(datos.nombre_factura);
    $("#direccion").val(datos.direccion);

    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$("#guardar").click(function() {

    actualizar_sucursal();

});
$(".cancelar").click(function() {
    limpiar();
});


function actualizar_sucursal() {
    var datos = {};
    datos.nombre = $("#nombre").val();
    datos.nit = $("#nit").val();
    datos.descripcion = $("#descripcion").val();
    datos.rubro = $("#rubro").val();
    datos.tipo_impresion = $("#tipo_impresion").val();
    datos.cumple = $("#cumple").val();
    datos.id = usuario.id_empresa;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_empresa',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });



            } else {

                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function actualizar_imagen(img) {
    var datos = {};

    datos.id_empresa = usuario.id_empresa;
    datos.foto = img;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_empresa_img',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });



            } else {

                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function eliminar_sucursal(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_sucursal',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: error


    });


}

function limpiar() {
    id_sucursal = 0;
    $("#nombre").val('');
    $("#nombre_factura").val('');
    $("#direccion").val('');
}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}