const csrfToken = document.head.querySelector(
  "[name~=csrf-token][content]"
).content;
let sucursales = [];

var $table = $("#table");
$(function () {
  $table.bootstrapTable("refreshOptions", {
    locale: "es-AR",
  });
});

function getListadoFacturasEvent() {
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/RegistroEventoSignificativo.php",
    type: "POST",
    data: {
      metodo: "obtenerListadoFacturasEvento",
    },
    dataType: "json",
    success: function (res) {
      let facturas = res;
      let templates = "";
      facturas.forEach((factura) => {
        templates += `
                    <tr>
                    <td>${factura.id}</td>
                    <td>${factura.punto_venta_id}</td>
                    <td>${factura.total}</td>
                    <td>${factura.nro_factura}</td>
                    <td>${factura.evento_significativo_id}</td>
                    <td>${factura.estado_emision}</td>
                    </tr>
                        `;
      });
      $("#facturaList").html(templates);
    },
  });
}

function cargar_tabla() {
  llenarTablasinccufd();
}

$(document).ready(function () {
  getListadoFacturasEvent();
});

function enviarPaquetesManual() {
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/RegistroEventoSignificativo.php",
    type: "POST",
    data: {
      metodo: "envioPaquetesManual",
    },
    dataType: "json",

    success: function (res) {
      console.log(res);
      if (res.transaccion) {
        Snackbar.show({ text: res.msg, pos: "top-right" });
        setTimeout(function () {
          location.href = "lista_ventas.html";
        }, 3000);
      } else {
        Snackbar.show({ text: res.msg, pos: "top-right" });
      }
    },
    error: error,
  });
}
