let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let id_empresa = 0;
$("#fecha_ingreso").val(moment().format('YYYY-MM-DD'));

$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
$("#id_sucursales").change(function() {
    // $table.bootstrapTable('removeAll');
    // cargar_tabla();
});

function cargar_tipo_ingreso_egreso() {
    $.ajax({
        url: urlServicio + 'API_REST/cargar_tipo_ingreso_egreso_tipo/' + 1 + '/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_tipo_ingreso");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
        },
        error: error


    });
}

function cargar_sucursales() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                var sucursales = $("#id_sucursales");
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    sucursales.append('<option value="' + element.id + '">' + element.nombre + '</option>');
                }
            }
        },
        error: error


    });
}

function cargar_tabla() {
    id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_ingreso_egreso_tipo/' + 1 + '/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_tipo_ingreso_egreso();
            cargar_sucursales();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_sucursal(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#id_tipo_ingreso").val(datos.id_tipo_fi_in);
    $("#id_sucursal").val(datos.id_sucursal);
    $("#monto").val(datos.monto);
    $("#descripcion").val(datos.descripcion);
    $("#fecha_ingreso").val(datos.fecha);

    $('html, body').animate({
        scrollTop: $("#id_tipo_ingreso").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_sucursal > 0) {
        if (validar($("#monto")) && validar($("#descripcion"))) {

            actualizar_sucursal();

        }
    } else {
        if (validar($("#monto")) && validar($("#descripcion"))) {

            insertar_sucursal();
        }
    }
});
$(".cancelar").click(function() {
    limpiar();
});

function insertar_sucursal() {
    let aray = [];
    let datos = {};

    datos.id_tipo_fi_in = $("#id_tipo_ingreso").val();
    datos.id_sucursal = $("#id_sucursales").val();
    datos.id_usuario = usuario.id;
    datos.monto = $("#monto").val();
    datos.descripcion = $("#descripcion").val();
    datos.fecha = $("#fecha_ingreso").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_fin_ingreso_egreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.sucursal = $("#id_sucursales option:selected").text();
                datos.tipo_ingreso = $("#id_tipo_ingreso option:selected").text();
                datos.id = d.msg;
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function actualizar_sucursal() {
    var datos = {};
    datos.id = id_sucursal;
    datos.id_tipo_fi_in = $("#id_tipo_ingreso").val();
    datos.id_sucursal = $("#id_sucursales").val();
    datos.id_usuario = usuario.id;
    datos.monto = $("#monto").val();
    datos.descripcion = $("#descripcion").val();
    datos.fecha = $("#fecha_ingreso").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_ingreso_egreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {

                        descripcion: $("#descripcion").val(),
                        id_tipo_fi_in: $("#id_tipo_ingreso").val(),
                        id_sucursal: $("#id_sucursales").val(),
                        monto: $("#monto").val(),
                        fecha: $("#fecha_ingreso").val(),

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function eliminar_sucursal(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_ingreso_egreso',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}

function validar_nro(costo) {
    if (parseFloat(costo.val()) > 0) {
        return true;
    } else {
        Snackbar.show({ text: 'Debe ingresar un costo valido.', pos: 'top-center' });
        return false;

    }
}

function limpiar() {
    id_sucursal = 0;
    $("#monto").val('');
    $("#fecha_ingreso").val('');
    $("#descripcion").val('');
}

function error(data, textStatus, jqXHR) {
    $('.loader').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}