var $table = $('#table');
var $table_empresas = $('#table_empresas');
var $table_usuarios = $('#table_usuarios');
var $table_pagos = $('#table_pagos');
let momento_actual = moment().format('YYYY-MM-DD');
let empresas = [];
let costos_t = [];
let id_venta_edit = 0;
let saldo_venta = 0;
let cargo = true;
$("#fecha_ini").val(momento_actual);
$("#fecha_fin").val(momento_actual);
$("#fecha_inicio").val(momento_actual);
$("#fecha_final").val(momento_actual);
$("#fecha_pago").val(momento_actual);
// $(document).ready(function() {
//     $(".caja_loader").toggle();


//     cargar_tabla();

// });
$("#nueva_empresa").click(function() {
    $("#modal_empresa").modal('show');
    $("#nombre").val('');
    $("#monto").val(0);
});
$(document).on('click', '.enviar', function() {
    $(".caja_loader").toggle();
    empresas = [];
    cargar_tabla();
});
$(document).on('click', '.user', function() {
    id_venta_edit = $(this).data('usuario');
    // let empresa = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre_usuario").val('');
    $("#correo").val('');

    $("#modal_usuario").modal('show');

});

$(document).on('click', '.edit', function() {
    id_venta_edit = $(this).data('edit');
    let empresa = $table.bootstrapTable('getRowByUniqueId', id_venta_edit);
    $("#nombre").val(empresa.nombre);
    $("#fecha_inicio").val(empresa.fecha_inicio);
    $("#fecha_final").val(empresa.fecha_fin);
    $("#monto").val(empresa.monto);
    $("#modal_empresa").modal('show');

});



$(document).on('click', '.desactivar', function(e) {
    let t = this.dataset.delete;
    let datos = $table.bootstrapTable('getRowByUniqueId', t);
    let estado_ = 0;
    let estado_n = 'Inactivo';
    let texto = '¿Esta seguro de desactivar la empresa?';
    if (datos.estado == 0) {
        texto = '¿Esta seguro de activar la empresa?';
        estado_ = 1;
        estado_n = 'Activo';
    }
    Snackbar.show({
        text: texto,
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            desactivar_empresa(t, estado_, estado_n);
        }
    }); 
});

$("#guardar").click(function() {
    let datos = {};
    datos.nombre = $("#nombre").val();
    datos.fecha_inicio = moment($("#fecha_inicio").val()).format('YYYY-MM-DD');
    datos.fecha_fin = moment($("#fecha_final").val()).format('YYYY-MM-DD');
    datos.monto = $("#monto").val();
    datos.id_modalidad = $("#modalidad").val();
    if (id_venta_edit == 0) {
        insertar_empresa(datos);
    } else {
        editar_plan(datos);
    }
});
$("#guardar_usuario").click(function() {
    let datos = {};
    datos.nombre = $("#nombre_usuario").val();
    datos.correo = $("#correo").val();
    datos.pass = $("#pass").val();
    datos.id_empresa = id_venta_edit;
    insertar_usuarios(datos);
});
$(document).on('click', '.ver_usuarios', function() {
    $table_usuarios.bootstrapTable('load', []);
    let id = $(this).data('ver');
    ver_usaurios(id);
    $("#modal_ver_usuario").modal('show');
});
$(document).on('click', '.pago', function() {
    $table_pagos.bootstrapTable('load', []);
    let id = $(this).data('pago');
    cargar_costos(id);
    $("#modal_pagos").modal('show');
});

$(document).on('click', '.guardar_pago', function(e) {
    insertar_costos();
});
$(document).on('click', '.delete_costo', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_pagos(t);
        }
    }); 
});

function cargar_tabla() {
    let fecha_ini = $("#fecha_ini").val();
    let fecha_fin = $("#fecha_fin").val();

    $.ajax({
        url: urlServicio + 'API_REST/cargar_empresas/' + fecha_ini + '/' + fecha_fin,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            if (cargo) {
                cargar_modalidad(d.modalidad);
                cargo = false;
            }

            if (d.errorCode == 0) {
                let res = d.msg;
                empresas = [];
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    element.usuario = '<a data-usuario="' + element.id + '" class=" text-danger user"><i class="fas fa-id-badge"></i></a>' +
                        ' <a data-ver="' + element.id + '" class="text-success ver_usuarios"><i class="fas fa-eye"></i></a>';

                    element.pago = '<a data-pago="' + element.id + '" class=" text-primary pago"><i class="far fa-money-bill-alt"></i></a>';
                    element.editar = '<a data-edit="' + element.id + '" class=" text-primary edit"><i class="far fa-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class=" text-primary desactivar"><i class="las la-trash-alt"></i></a>';
                    empresas.push(element);
                }
                data_table_cargar_1(empresas, $table);
            }
            $(".caja_loader").hide();
            mostrar_empresas();
        },
        error: error


    });
}

function mostrar_empresas() {
    $.ajax({
        url: urlServicio + 'API_REST/ver_empresas_plan',
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            if (d.errorCode == 0) {
                let res = d.msg;
                data_table_cargar_1(res, $table_empresas);
                $("#modal_empresas").modal('show');
            }
        },
        error: error


    });
}

function cargar_modalidad(array) {
    $("#modalidad").html('');
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        $("#modalidad").append('<option value="' + element.id + '">' + element.nombre + '</option>');
    }
}

function insertar_empresa(datos) {
    $('.caja_loader').toggle();

    let aray = [];
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_empresa',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.usuario = '<a data-usuario="' + d.msg + '" class=" text-danger user"><i class="fas fa-id-badge"></i></a>' +
                    ' <a data-ver="' + d.msg + '" class="text-success ver_usuarios"><i class="fas fa-eye"></i></a>';
                datos.estado = 1;
                datos.estado_n = 'Activo';
                datos.saldo = $("#monto").val();
                datos.id_modalidad_pago = $("#modalidad").val();
                datos.modalidad = $("#modalidad option:selected").text();
                datos.pago = '<a data-pago="' + d.msg + '" class=" text-primary pago"><i class="far fa-money-bill-alt"></i></a>';
                datos.editar = '<a data-edit="' + d.msg + '" class=" text-primary edit"><i class="far fa-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class=" text-primary desactivar"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);


            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }
            $('.caja_loader').toggle();
            limpiar();
        },
        error: error



    });
}

function editar_plan(datos) {
    datos.id = id_venta_edit;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_plan',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {

                Snackbar.show({
                    text: 'Se actualizo correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });
                datos.modalidad=$("#modalidad option:selected").text();
                $table.bootstrapTable('updateByUniqueId', {
                    id: id_venta_edit,
                    row: datos


                });
                limpiar();
            }

        },
        error: error



    });

}

function insertar_usuarios(datos) {
    $('.caja_loader').toggle();


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_usuario_emp',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;

            } else {
                Snackbar.show({ text: d.errorMessage, pos: 'top-center' });


            }
            $('.caja_loader').hide();
            $("#modal_usuario").modal('hide');
        },
        error: error



    });
}

function ver_usaurios(id_empresa) {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_usuarios/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                data_table_cargar_1(res, $table_usuarios);
            }
            $(".caja_loader").hide();

        },
        error: error


    });
}

function desactivar_empresa(id, estado, estado_n) {
    let datos = {};
    datos.id = id;
    datos.estado = estado;
    datos.estado_n = estado_n;

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/desactivar_empresa',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {

                Snackbar.show({
                    text: 'Se actualizo correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id,
                    row: datos


                });
                limpiar();
            }

        },
        error: error



    });

}


function cargar_costos(id_venta) {
    id_venta_edit = id_venta;
    costos_t = [];
    $table_pagos.bootstrapTable('load', costos_t);

    $.ajax({
        url: urlServicio + 'API_REST/cargar_pagos_empresa' + '/' + id_venta,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';

                    costos_t.push(element);
                }

                $table_pagos.bootstrapTable('load', costos_t);

                //data_table_cargar(sucursales);
            }
        },
        error: error


    });
}

function insertar_costos() {
    let saldot = $table.bootstrapTable('getRowByUniqueId', id_venta_edit).saldo;
    let saldo = parseFloat(saldot) - parseFloat($("#monto_pago").val());
    let aray = [];
    let datos = {};

    datos.id_empresa = id_venta_edit
    datos.fecha_pago = moment($("#fecha_pago").val()).format('YYYY-MM-DD');
    datos.pago = $("#monto_pago").val();
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_pago_empresa',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;

                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)

                $table_pagos.bootstrapTable('append', aray);
                $table.bootstrapTable('updateByUniqueId', {
                    id: id_venta_edit,
                    row: {
                        saldo: saldo
                    }

                });
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: error



    });
}

function eliminar_pagos(id) {
    let saldot = $table.bootstrapTable('getRowByUniqueId', id_venta_edit);
    let pago = $table_pagos.bootstrapTable('getRowByUniqueId', id);

    let saldo = parseFloat(saldot.saldo) + parseFloat(pago.pago);

    var datos = {};
    datos.id = id;
    datos.id_empresa = saldot.id
    datos.monto = pago.pago;



    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_pago_empresa',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table_pagos.bootstrapTable('removeByUniqueId', id);
                $table.bootstrapTable('updateByUniqueId', {
                    id: id_venta_edit,
                    row: {
                        saldo: saldo
                    }

                });
                limpiar();
            }

        },
        error: error



    });


}

function limpiar() {
    id_venta_edit = 0;
    $("#modal_empresa").modal('hide');
    $("#nombre").val('');
    $("#monto").val('0');
}