var $table = $('#table');
let momento_actual = moment().format('YYYY-MM-DD');
let compras = [];
var $table_costos = $('#table_costos');
let id_venta_edit = 0;
let saldo_venta = 0;
let id_empresa = 0;
$("#fecha_ini").val(momento_actual);
$("#fecha_fin").val(momento_actual);
$("#fecha_pago_").val(momento_actual);

$(document).on('click', '.enviar', function() {
    $('.caja_loader').show();

    compras = [];
    data_table_cargar(compras);
    cargar_tabla();
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar compra seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_compra(t);
        }
    });
});
$(document).on('click', '.imprimir', function(e) {
    let t = this.dataset.imprimir;
    window.open('imprimir_compra.html?v=' + t, '_blank');
});
$(document).on('click', '.print_p', function(e) {
    let t = this.dataset.print;
    window.open('imprimir_pago_compra.html?v=' + t, '_blank');
});
$(document).on('click', '.pago', function() {
    // $("#load_screen").toggle();
    let id_venta = this.dataset.pago;
    $("#exampleModal").modal('show');
    limpiar();
    cargar_costos(id_venta);
});
$(document).on('click', '.guardar_costo', function(e) {
    if (parseFloat($("#monto").val()) > 0 && parseFloat($("#monto").val()) <= saldo_venta) {
        insertar_costos();

    } else {
        Snackbar.show({ text: 'Debe ingresar un monto valido.', pos: 'top-center' });

    }
});
$(document).on('click', '.delete_costo', function(e) {
    let t = this.dataset.delete;
    let datos = $table_costos.bootstrapTable('getRowByUniqueId', t);
    Snackbar.show({
        text: 'Eliminar pago seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_pagos(datos);
        }
    }); 
});
function cargar_tabla() {
    let fecha_ini = $("#fecha_ini").val();
    let fecha_fin = $("#fecha_fin").val();
    id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_compras/' + id_empresa + '/' + fecha_ini + '/' + fecha_fin+'/'+2,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.caja_loader').hide();

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                  
                    element.pago = '<a data-pago="' + element.id + '" class="font-20 text-danger pago"><i class="fas fa-money-bill"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                    element.imprimir = '<a data-imprimir="' + element.id + '" class="font-20 text-primary imprimir"><i class="fa fa-print"></i></a>';

                    compras.push(element);
                }

                data_table_cargar(compras);
            }
        },
        error: error


    });
}

function eliminar_compra(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_compra',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                //limpiar();
            }

        },
        error: error



    });
}

function cargar_costos(id_venta) {
    id_venta_edit = id_venta;
    costos_t = [];
    $table_costos.bootstrapTable('load', costos_t);
    let datos = $table.bootstrapTable('getRowByUniqueId', id_venta);
    saldo_venta = datos.saldo;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_pago_compra' + '/' + id_venta,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];
                    element.print = '<a data-print="' + element.id + '" class="font-20 text-danger print_p"><i class="fa fa-print"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';

                    costos_t.push(element);
                }

                $table_costos.bootstrapTable('load', costos_t);

                //data_table_cargar(sucursales);
            }
        },
        error: error


    });
}

function insertar_costos() {
    let aray = [];
    let datos = {};

    datos.id_venta = id_venta_edit
    datos.id_usuario = usuario.id;
    datos.fecha_pago = moment($("#fecha_pago_").val()).format('YYYY-MM-DD');
    datos.monto = $("#monto").val();
    datos.nombre = $("#nombre_").val();
    datos.ci = $("#ci_").val();
    datos.nota = $("#nota_").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/guardar_pago_compra',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                let viaje_tabla = $table.bootstrapTable('getRowByUniqueId', id_venta_edit);
                let saldos = parseFloat(viaje_tabla.saldo) - parseFloat($("#monto").val());
                saldo_venta = saldos;
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.print = '<a data-print="' + d.msg + '" class="font-20 text-danger print_p"><i class="fa fa-print"></i></a>';

                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete_costo"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table_costos.bootstrapTable('append', aray);

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_venta_edit,
                    row: {

                        saldo: saldos,


                    }
                });
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });
}

function eliminar_pagos(element) {
    var datos = {};
    datos.id = element.id;
    datos.monto = element.monto;
    datos.id_venta = id_venta_edit;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_pago_compra',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                let viaje_tabla = $table.bootstrapTable('getRowByUniqueId', id_venta_edit);
                let costos_tabla = $table_costos.bootstrapTable('getRowByUniqueId', element.id);
                let costos = parseFloat(viaje_tabla.saldo) + parseFloat(costos_tabla.monto);
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_venta_edit,
                    row: {

                        saldo: costos,


                    }
                });
                $table_costos.bootstrapTable('removeByUniqueId', element.id);
                limpiar();
            }

        },
        error: function(data, textStatus, jqXHR) {

            console.log(data);
            console.log(textStatus);
            console.log(jqXHR);

            $('.loader').toggle();

        }



    });


}
function limpiar() {
    $("#nota_").val('');
    $("#ci_").val('');
    $("#nombre_").val('');
    $("#monto").val('');
}
function error(data, textStatus, jqXHR) {
    $('#load_screen').hide();
    console.log(data);
    console.log(textStatus);
    console.log(jqXHR);
}