const csrfToken = document.head.querySelector(
  "[name~=csrf-token][content]"
).content;
let sucursales = [];

var $table = $("#table");
let id_sucursal = 0;

$(function () {
  $table.bootstrapTable("refreshOptions", {
    locale: "es-AR",
  });
});

function actualizarCufd() {
  let id_empresa = usuario.id_empresa;
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/CufdService.php",
    type: "POST",
    data: {
      metodo: "actualizarCufd",
      id_empresa: id_empresa,
    },
    dataType: "json",
    success: function (d) {
      if (d.errorCode == 0) {
        Snackbar.show({ text: d.errorMessage, pos: "top-center" });
      } else {
        if (d.errorCode == 1) {
          Snackbar.show({ text: d.errorMessage, pos: "top-center" });
        }
      }
    },
    error: Snackbar.show({ text: "Cufd ya esta Vigente1", pos: "top-center" }),
  });
}

function cargar_tabla() {
  llenarUsersTable();
}

function llenarUsersTable() {
  let id_empresa = usuario.id_empresa;
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "API_REST/Controllers/AsignarPVController.php",
    type: "POST",
    data: {
      metodo: "getUsersEnterPrise",
      empresa_id: id_empresa,
    },
    dataType: "json",
    success: function (res) {
      let usuarios = res;
      let templates = "";
      usuarios.forEach((usuario) => {
        templates += `
                    <tr>
                    <td>${usuario.usuario_id}</td>
                    <td>${usuario.usuario_nombre}</td>
                    <td>${usuario.usuario_correo}</td>
                    <td>${usuario.nombre_empresa}</td>
                    <td>${usuario.departamento_empresa}</td>
                    <td><button class="asignar-pv-button btn btn-primary" data-usuario-id="${usuario.usuario_id}">Asignar PV</button></td>
                    </tr>
                        `;
      });
      $("#usuarioList").html(templates);

      $(".asignar-pv-button").on("click", function () {
        const usuarioId = $(this).data("usuario-id");
        let empresa_id = id_empresa;
        const asignarPView = `asignar_usuario_pv.html?id_usuario=${usuarioId}&id_empresa=${empresa_id}`;
        window.location.href = asignarPView;
      });
    },
    error: console.log(error),
  });
}
