let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let imagen = 'sin_imagen';
let imagen_actual = '';
let id_empresa = 1;
let cadena;
let date = moment().format('YYYY-MM-DD');
$("#fecha_vencimiento").val(date);
// $(document).ready(function() {

//     cargar_tabla();
// });
$(document).ready(function () {
    $("#id_unidad_medida").select2();
    $("#id_homologacion").select2();
  });
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});

function llenarSelectUnidadMedida() {
    $.ajax({
      url: urlServicio + "API_REST/cargarUnidadesMedida",
      //data: datos,
      type: "GET",
      dataType: "json",
      //contentType: "application/json; charset=utf-8",
      success: function (d) {
        var producto = $("#id_unidad_medida").html("");
        if (d.errorCode == 0) {
          let res = d.msg;

          productos = res.producto;
          for (let index = 0; index < res.producto.length; index++) {
            const element = res.producto[index];

            if (index == 0) {
              producto.append(
                '<option selected value="' + element.codigoclasificador + '">' +
                element.descripcion +
                "</option>"
                );

            } else {
              producto.append(
                '<option value="' + element.codigoclasificador + '">' +
                element.descripcion +
                "</option>"
              );
            }
          }
        }
      },
      error: error,
    });
}
function llenarSelectProductoServicio() {

    $.ajax({
      url: urlServicio + "API_REST/cargarProductosServicios",
      //data: datos,
      type: "GET",
      dataType: "json",
      //contentType: "application/json; charset=utf-8",
      success: function (d) {
        var producto = $("#id_homologacion").html("");
        if (d.errorCode == 0) {
          let res = d.msg;
          //console.log(res);
          productos = res.producto;
          for (let index = 0; index < res.producto.length; index++) {
            const element = res.producto[index];

            if (index == 0) {
              producto.append(
                '<option selected value="' + element.idproductoservicios + '">' +
                element.descripcion +
                "</option>"
                );

            } else {
              producto.append(
                '<option value="' + element.idproductoservicios + '">' +
                element.descripcion +
                "</option>"
              );
            }
          }
        }
      },
      error: error,
    });
  }


function cargar_tabla() {
    id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_productos/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            cargar_almacenes();
            llenarSelectProductoServicio();
            llenarSelectUnidadMedida();
            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }
                data_table_cargar(sucursales);
            }
            $(".caja_loader").hide();
        },
        error: error


    });
}

function cargar_almacenes() {
    id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_almacen_todos/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;

                cargar_almacen(res);
            }
            $(".caja_loader").hide();
        },
        error: error


    });
}

function cargar_almacen(array) {
    $("#id_almacen").html("<option value='0'>Seleccione un almacén</option>");
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        $("#id_almacen").append('<option data-sucursal="' + element.id_sucursal + '" value="' + element.id + '">Sucursal: ' + element.sucursal + ', Almacen: ' + element.nombre + '</option>');
    }
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_producto(t);
        }
    });
});

$(".guardar").click(function() {
    $(".caja_loader").show();

    if(!validarNegativos(parseInt($("#peso").val()))||!validarNegativos($("#precio").val()) || !validarNegativos($("#precio_2").val()) || !validarNegativos($("#stock_min").val()))
    {
        Snackbar.show({ text: 'No se permiten negativos', pos: 'top-center' });
        $(".caja_loader").hide();
        return
    } else {
        if (id_sucursal > 0) {
            if (validar($("#codigo")) && validar($("#nombre")) && validar($("#precio"))) {

                actualizar_producto();

            }
        } else {
            if (validar($("#codigo")) && validar($("#nombre")) && validar($("#precio"))) {

                insertar_producto();
            }
        }
    }
});
$(".cancelar").click(function() {
    limpiar();
});

$("#imagen").change(function() {
    var ext = this.value.match(/\.([^\.]+)$/)[1];
    switch (ext) {
        case 'jpg':
        case 'jpeg':
        case 'png':
            var file = this.files[0];
            var reader = new FileReader();
            reader.onload = function(e) {
                var data = e.target.result;
                $('#mostrar_imagen').attr("src", data);
                imagen = data;
            };
            reader.readAsDataURL(file);
            break;
        default:
            $('#mostrar_imagen').attr("src", "img/500.png");
            alert('El tipo de imagen puede ser jpg, jpeg, png');
            imagen = 'sin_imagen';

            this.value = '';
    }

});




function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#codigo").val(datos.codigo);
    $("#nombre").val(datos.nombre);
    $("#descripcion").val(datos.descripcion);
    $("#peso").val(datos.peso);
    $("#precio").val(datos.precio);

    $("#precio_2").val(datos.precio_2);
    $("#precio_paquete").val(datos.precio_paquete);
    $("#cod_barra").val(datos.cod_barra);
    $("#marca").val(datos.marca);
    $("#caracteristica").val(datos.caracteristica);
    $("#grupo_familia").val(datos.grupo_familia);
    $("#costo").val(datos.costo);
    $("#costo_paquete").val(datos.costo_paquete);
    $("#stock_min").val(datos.stock_min);
    $("#fecha_vencimiento").val(datos.fecha_vencimiento);
    if (datos.foto == 'sin_imagen') {
        $('#mostrar_imagen').attr("src", "img/subir.png");
        imagen_actual = 'sin_imagen';

    } else {
        $('#mostrar_imagen').attr("src", "img/" + id_empresa + "/" + datos.foto);
        imagen_actual = datos.foto;
    }
    imagen = 'sin_imagen';

    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
function validarNegativos(campo){
    if(campo<0){
        return false;
    }else{
        return true;
    }
}

function insertar_producto() {

    let aray = [];
    let datos = {};
    datos.codigo = $("#codigo").val();
    datos.nombre = $("#nombre").val();
    datos.descripcion = $("#descripcion").val();
    datos.imei = $("#imei").val(); /* 2 nuevos campos para la Homologacion de productos */
    datos.serie = $("#serie").val();
    datos.id_homologacion= $("#id_homologacion").val();
    datos.id_unidad_medida = $("#id_unidad_medida").val();

    datos.foto = imagen;
    datos.id_empresa = id_empresa;
    datos.tamano = $("#descripcion").val();
    datos.peso = $("#peso").val();
    datos.precio = $("#precio").val();

    datos.precio_mayor = $("#precio_2").val();
    datos.precio_paquete = $("#precio_paquete").val();
    datos.cod_barra = $("#cod_barra").val();
    datos.marca = $("#marca").val();
    datos.caracteristica = $("#caracteristica").val();
    datos.grupo_familia = $("#grupo_familia").val();
    datos.costo = $("#costo").val();
    datos.costo_paquete = $("#costo_paquete").val();
    datos.stock_min = $("#stock_min").val();
    datos.fecha_vencimiento = $("#fecha_vencimiento").val();

    var enviar = JSON.stringify(datos);
    /* console.log(enviar);  */

    $.ajax({
        url: urlServicio + 'API_REST/insertar_producto',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();

            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.foto = d.imagen;
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: error



    });
}

function actualizar_producto() {
    var datos = {};
    datos.id = id_sucursal;
    datos.codigo = $("#codigo").val();
    datos.nombre = $("#nombre").val();
    datos.descripcion = $("#descripcion").val();
    datos.imei = $("#imei").val(); /* 2 nuevos campos para la Homologacion de productos */
    datos.serie = $("#serie").val();
    datos.id_homologacion= $("#id_homologacion").val();
    datos.id_unidad_medida = $("#id_unidad_medida").val();

    datos.tamano = $("#descripcion").val();
    datos.foto = imagen;
    datos.peso = $("#peso").val();
    datos.precio = $("#precio").val();
    datos.id_empresa = id_empresa;
    datos.precio_2 = $("#precio_2").val();
    datos.precio_paquete = $("#precio_paquete").val();
    datos.cod_barra = $("#cod_barra").val();
    datos.marca = $("#marca").val();
    datos.caracteristica = $("#caracteristica").val();
    datos.grupo_familia = $("#grupo_familia").val();
    datos.costo = $("#costo").val();
    datos.costo_paquete = $("#costo_paquete").val();
    datos.stock_min = $("#stock_min").val();
    datos.fecha_vencimiento = $("#fecha_vencimiento").val();
    var enviar = JSON.stringify(datos);
    console.log(datos);
    let imagen_;
    $.ajax({
        url: urlServicio + 'API_REST/actualizar_producto',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();

            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });
                imagen_ = d.msg;
                if (imagen_actual != 'sin_imagen') {
                    imagen_ = imagen_actual;
                }
                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {

                        codigo: $("#codigo").val(),
                        nombre: $("#nombre").val(),
                        descripcion: $("#descripcion").val(),
                        imei : $("#imei").val(),
                        serie : $("#serie").val(),
                        id_homologacion: $("#id_homologacion").val(),
                        tamano: $("#tamano").val(),
                        peso: $("#peso").val(),
                        precio: $("#precio").val(),

                        precio_2: $("#precio_2").val(),
                        precio_paquete: $("#precio_paquete").val(),
                        cod_barra: $("#cod_barra").val(),
                        marca: $("#marca").val(),
                        caracteristica: $("#caracteristica").val(),
                        grupo_familia: $("#grupo_familia").val(),
                        costo: $("#costo").val(),
                        costo_paquete: $("#costo_paquete").val(),
                        stock_min: $("#stock_min").val(),
                        fecha_vencimiento: $("#fecha_vencimiento").val(),
                        foto: imagen_




                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function eliminar_producto(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_producto',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: error



    });


}

//////////excel
$(".descargar").click(function() {
    crear_excel();
});

function crear_excel() {
    var cabeceras = [];
    var Datas = {
        // We will make a Workbook contains 2 Worksheets
        'datos': [{
            "codigo": "",
            "codigo_barra": "",
            "nombre": "",
            "descripcion": "",
            "tamahno": "",
            "peso": "",
            "precio": "",
            "precio_2": "",
            "precio_paquete": "",
            "marca": "",
            "caracteristica": "",
            "costo": "",
            "stock_min": "",
            "grupo_familia": "",
            "costo_lote": "",
            "stock": "",
            "fecha_vencimiento": "",
            "lote": "",
            "codigo_actividad": "",
            "homologacion": "",
            "imei": "",
            "serie": "",
            "unidad_medida": "",
        }]
    };

    var wb = XLSX.utils.book_new(); // make Workbook of Excel
    var animalWS = XLSX.utils.json_to_sheet(Datas.datos, { fecha_vencimineto: "yyyy-mm-dd" });
    //var pokemonWS = XLSX.utils.json_to_sheet(productos);

    // add Worksheet to Workbook
    // Workbook contains one or more worksheets
    XLSX.utils.book_append_sheet(wb, animalWS, 'Datos'); // sheetAName is name of Worksheet
    //XLSX.utils.book_append_sheet(wb, pokemonWS, 'Productos');

    // export Excel file
    XLSX.writeFile(wb, 'formato_producto.xlsx');
}
$("#archivo").change(function(e) {
    archivo_cargadov2(e);
});

function verificar_excel() {
    let costo = 0;
    cadena.forEach(element => {
        costo += parseFloat(element.costo_lote);
    });
    return costo;
}
$(".subir").click(function() {
    if (cadena) {
        if ($("#id_almacen").val() > 0) {
            console.log(cadena);

            subir_archivo(cadena);
        } else {
            Snackbar.show({
                text: 'Seleccione un almacen',
                pos: 'top-center',
                actionText: 'cerrar'
            });
        }
    }

});

function archivo_cargadov2(e) {
    var reader = new FileReader();
    var selectedFile = (e.target.files[0]);

    reader.onload = function(event) {
        var data = event.target.result;
        var workbook = XLSX.read(data, {
            type: 'binary',
            cellDates: true,
            cellNF: false,
            cellText: false,
            cellStyles: true
        });
        //  workbook.SheetNames.forEach(function(sheetName) {
        const wsname = workbook.SheetNames[0];
        console.log(wsname);
        var XL_row_object = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[wsname]);
        cadena = (XL_row_object);


    };
    reader.onerror = function(event) {
        console.error("Error" + event.target.error.code);
    };
    reader.readAsBinaryString(selectedFile);
}

function subir_archivo(archivo) {
    var datos = {};
    datos.id_empresa = id_empresa;
    datos.id_usuario = usuario.id;
    datos.costo = verificar_excel();
    datos.id_sucursal = $("#id_almacen option:selected").data('sucursal');
    datos.id_almacen = $("#id_almacen").val();
    datos.detalle = archivo;
    var enviar = JSON.stringify(datos);
    console.log(datos);
    $.ajax({
        url: urlServicio + 'API_REST/subir_productos',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se subio correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });
                setTimeout(() => {
                    window.location.reload();
                }, 1500);
                limpiar();
            } else {
                Snackbar.show({
                    text: d.msg,
                    pos: 'top-center',
                    actionText: 'cerrar'
                });
            }

        },
        error: error

    });
}

function limpiar() {
    id_sucursal = 0;
    imagen = 'sin_imagen'
    $('#mostrar_imagen').attr("src", "img/subir.png");
    $("#imagen").val('');
    $("#codigo").val('');
    $("#nombre").val('');
    $("#descripcion").val('');
    $("#peso").val('');
    $("#precio").val('');
    $("#precio_2").val('');
    $("#precio_paquete").val('');
    $("#cod_barra").val('');
    $("#marca").val('');
    $("#caracteristica").val('');
    $("#grupo_familia").val('');
    $("#costo").val('');
    $("#costo_paq").val('');
    $("#stock_min").val('');
}