let sucursales = [];
var $table = $("#table");
let id_sucursal = 0;
let productos = [];
let detalle_productos = [];
let contador = 0;
let id_viaje_u = 0;
let total_venta = 0;
let id_empresa = 1;
let id_caja = 0;
let fecha_apertura = "";
$("#fecha_venta").val(moment().format("YYYY-MM-DD"));
$(".fecha_modal").text(moment().format("YYYY-MM-DD"));
$("#fecha_apertura").val(moment().format("YYYY-MM-DD"));
// $(document).ready(function() {

//     cargar_tabla();

// });
$(function () {
  $table.bootstrapTable("refreshOptions", {
    locale: "es-AR",
  });
});
$("#fecha_venta").change(function () {
  $(".fecha_modal").text(this.value);
});
$("#id_sucursales").change(function () {
  $(".caja_loader").show();
  id_sucursal = this.value;
  let almacen_cargar = sucursales.findIndex((x) => x.id == id_sucursal);
  detalle_productos = [];
  $("#tabla").html("");
  cargar_almacen(sucursales[almacen_cargar].almacenes);
});

$("#id_almacenes").change(function () {
  $(".caja_loader").show();

  detalle_productos = [];
  $("#tabla").html("");
  cargar_productos();
});
$("#tipo_pago").change(function () {
  if (this.value == 1) {
    $(".caja_tarjeta").hide();
  } else {
    $(".caja_tarjeta").show();
  }
});
$(".cargar_caja").click(function () {
  $(".caja_loader").show();
  $("#modal_caja").modal("show");
  cargar_caja();
});
$(".guardar_caja").click(function () {
  $(".caja_loader").show();
  if (id_caja == 0) {
    insertar_caja();
  } else {
    actualizar_caja();
  }
});
$("#tipo_venta").change(function () {
  if (this.value == 1) {
    $(".caja_credito").removeClass("d-none");
  } else {
    $(".caja_credito").addClass("d-none");
  }
});

function cargar_tabla() {
  id_empresa = usuario.id_empresa;
  $.ajax({
    url: urlServicio + "API_REST/cargar_funciones_ventas/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      var sucu = $("#id_sucursales").html("");
      if (d.errorCode == 0) {
        let res = d.msg;
        sucursales = res.sucursal;
        for (let index = 0; index < res.sucursal.length; index++) {
          const element = res.sucursal[index];
          if (index == 0) {
            sucu.append(
              '<option selected value="' +
              element.id +
              '">' +
              element.nombre +
              "</option>"
            );
          } else {
            sucu.append(
              '<option value="' +
              element.id +
              '">' +
              element.nombre +
              "</option>"
            );
          }
        }

        cargar_almacen(res.sucursal[0].almacenes);
        cargar_clientes(res.cliente);
      }
    },
    error: error,
  });
}

function cargar_almacen(array) {
  let almacen = $("#id_almacenes").html("");
  for (let index = 0; index < array.length; index++) {
    const element = array[index];
    almacen.append(
      '<option value="' + element.id + '">' + element.nombre + "</option>"
    );
  }
  cargar_productos();
}

function cargar_clientes(array) {
  let almacen = $("#id_cliente").html("");
  for (let index = 0; index < array.length; index++) {
    const element = array[index];
    almacen.append(
      '<option value="' + element.id + '">' + element.nombre + "</option>"
    );
  }
}

function cargar_productos() {
  let id_almacen = $("#id_almacenes").val();
  $.ajax({
    url: urlServicio + "API_REST/cargar_productos_venta/" + id_almacen,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();

      if (d.errorCode == 0) {
        let res = d.msg;
        productos = res;
        $("#productos_").html("");
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          pintar_productos(element);
        }
      } else {
        $("#productos_").html(
          '<h4 class="text-center">No existe productos</h4>'
        );
      }
    },
    error: error,
  });
}

function pintar_productos(elemento) {
  let img = "img/subir.png";
  if (elemento.foto != "sin_imagen") {
    img = "img/" + id_empresa + "/" + elemento.foto;
  }
  let precios =
    '<select class="form-control" id="precio_' +
    elemento.id +
    '">' +
    '<option value="' +
    elemento.precio +
    '">' +
    elemento.precio +
    "</option>" +
    '<option value="' +
    elemento.precio_2 +
    '">' +
    elemento.precio_2 +
    "</option>" +
    "</select>";
  var cuerpo = "";
  cuerpo =
    ' <div class="items">' +
    '<div class="item-content">' +
    '<div class="product-info">' +
    ' <img src="' +
    img +
    '" alt="avatar">' +
    '<div class="user-meta-info">' +
    '<p class="d-none"><span>Codigo_barra: </span>' +
    elemento.cod_barra +
    "</p>" +
    '<a  class="btn btn-soft-success btn-rounded  ">' +
    elemento.nombre +
    "</a>" +
    '<p class="product-category-addr"><span>Stock: </span>' +
    elemento.cantidad +
    "</p>" +
    " </div>" +
    "</div>" +
    '<div class="product-price">' +
    '<p class="product-category-addr"><span>precio: </span></p><br>' +
    " </div>" +
    "<div>" +
    precios +
    "</div>" +
    ' <div class="action-btn">' +
    ' <a data-producto="' +
    elemento.id +
    '" class="btn btn-success font-20 agregar"><i class="las la-check-double"></i></a>' +
    "</div>" +
    "</div>" +
    "</div>";
  $("#productos_").append(cuerpo);
}

function pintar_paginador() {
  let cuerpo = "";
  cuerpo =
    '<div class="pagination p13 text-center w-100 mt-4">' +
    ' <ul class="mx-auto">' +
    '<a href="#" class="prev">' +
    " <li>Prev</li>" +
    " </a>" +
    ' <a class="is-active" href="#">' +
    "  <li>1</li>" +
    "</a>" +
    '<a href="#">' +
    " <li>2</li>" +
    "</a>" +
    '<a href="#">' +
    " <li>3</li>" +
    " </a>" +
    '<a href="#" class="next">' +
    " <li>Next</li>" +
    " </a>" +
    "</ul>" +
    "</div>";
  $("#productos_").append(cuerpo);
}

$(document).on("click", ".agregar", function (e) {
  let t = this.dataset.producto;
  let producto = productos.find((x) => x.id == t);
  producto.contador = contador;
  cargar_detalle(producto);
  sumar_total();
});

function agregar_por_codigo(cod_barra) {
  let producto = productos.find((x) => x.cod_barra == cod_barra);
  producto.contador = contador;
  cargar_detalle(producto);
  sumar_total();
}

function cargar_detalle(elemento) {
  let cuerpo = "";
  let precio_seleccionado = $("#precio_" + elemento.id).val();
  cuerpo =
    '<tr id="t' +
    elemento.contador +
    '">' +
    "<td>" +
    elemento.nombre +
    "</td>" +
    '<td><input id="c' +
    elemento.contador +
    '" class="form-control cantidad" data-cantidad="' +
    elemento.contador +
    '" type="number" value=1></td>' +
    '<td><input id="cu' +
    elemento.contador +
    '" class="form-control costo_un" data-costo_un="' +
    elemento.contador +
    '" type="number" value=' +
    precio_seleccionado +
    "></td>" +
    '<td><input id="s' +
    elemento.contador +
    '" class="form-control subtotal" data-subtotal="' +
    elemento.contador +
    '" type="number" value=' +
    precio_seleccionado +
    "></td>" +
    '<td><a data-eliminar="' +
    elemento.contador +
    '" class="btn btn-danger eliminar"><i class="fa fa-trash"></i></a></td>' +
    "</tr>";
  $("#tabla").append(cuerpo);
  detalle_productos.push(elemento);
  contador++;
}
$("#id_descuento").on("change keyup", function () {
  let total = total_venta;
  let descuento_ = $(this).val();
  let descuento = parseFloat(total) - parseFloat(descuento_);
  $(".tot_descuento").text(descuento);
  $("#id_cancelo").val(0);
  $("#id_vuelto").text(0);
});
$("#id_cancelo").keyup(function () {
  let total = $(".tot_descuento").text();
  let cancelo = $("#id_cancelo").val();
  let vuelto = parseFloat(cancelo) - parseFloat(total);
  $("#id_vuelto").text(vuelto);
});
$(document).on("change keyup", ".cantidad", function (e) {
  let id = this.dataset.cantidad;
  let cantidad = this.value;
  let costo_un = $("#cu" + id).val();
  let subtotal = cantidad * costo_un;
  $("#s" + id).val(subtotal);
  sumar_total();
});
$(document).on("change keyup", ".costo_un", function (e) {
  let id = this.dataset.costo_un;
  let costo_un = this.value;
  let cantidad = $("#c" + id).val();
  let subtotal = costo_un * cantidad;
  $("#s" + id).val(subtotal);
  sumar_total();
});

$(document).on("change keyup", ".subtotal", function (e) {
  let id = this.dataset.subtotal;
  let subtotal = this.value;
  let cantidad = $("#c" + id).val();
  let costo_un = subtotal / cantidad;
  $("#cu" + id).val(costo_un);
  sumar_total();
});
$(document).on("click", ".eliminar", function (e) {
  let t = this.dataset.eliminar;
  let index = detalle_productos.findIndex((x) => x.id == t);
  detalle_productos.splice(index, 1);
  $("#t" + t).remove();
  sumar_total();
});

function sumar_total() {
  var numbers = $(".subtotal");
  var total = 0;
  for (var i = 0; i < numbers.length; i++) {
    total = total + parseFloat(numbers.eq(i).val());
  }
  total_venta = total;
  $(".result").text(total);
  $(".tot_descuento").text(total);
}

$(".guardar").click(function () {
  let descuento = $("#id_descuento").val();
  if (
    detalle_productos.length > 0 &&
    $("#id_cliente").val() != 0 &&
    $("#id_almacenes").val() != 0 &&
    parseFloat(descuento) >= 0
  ) {
      construir_json();
  } else {
    if (!isNaN(descuento)) {
      $("#id_descuento").addClass("need_input");
    }
    Snackbar.show({
      text: "No existe productos, tiene que seleccionar un cliente, tiene que seleccionar un almacen",
      pos: "top-center",
    });
  }
});

$(".cancelar").click(function () {
  location.href = "lista_proformas.html";
});

function construir_json() {
  let datos = {};
  var costo = 0;
  for (let index = 0; index < detalle_productos.length; index++) {
    const element = detalle_productos[index];
    element.precio = $("#cu" + element.contador).val();
    element.costo = $("#s" + element.contador).val();
    element.cantidad = $("#c" + element.contador).val();
    element.id_almacen = $("#id_almacenes").val();
    element.id_producto = element.id;
    costo += parseFloat(element.costo);
  }
  datos.productos = detalle_productos;
  datos.id_sucursal = $("#id_sucursales").val();
  datos.id_cliente = $("#id_cliente").val();
  datos.id_responsable = 0;
  datos.id_usuario = usuario.id;
  datos.descuento = $("#id_descuento").val();
  datos.fecha_venta = $("#fecha_venta").val();
  datos.total = costo;
  datos.nombre = $("#nombre").val();
  datos.ci = $("#ci").val();
  datos.estado = 1;
  datos.nota = $("#nota").val();

  console.log(datos);
  if (productos.length > 0) {
    insertar_venta(datos);
  } else {
    Snackbar.show({ text: "No existe productos.", pos: "top-center" });
  }
}

function insertar_venta(datos) {
  var enviar = JSON.stringify(datos);
  $(".caja_loader").show();
  $.ajax({
    url: urlServicio + "API_REST/insertar_proforma",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      if (d["errorCode"] == 0) {
        Snackbar.show({ text: "Se inserto correctamente.", pos: "top-center" });
        let url = "imprimir_proforma_cinta.html?v=" + d.msg;

        window.open(url);

        setTimeout(() => {
            location.href = "lista_proformas.html";
          // window.location.href = "lista_ventas.html";
        }, 1000);
        $(".caja_loader").hide();
      } else {
        Snackbar.show({ text: "Error al insertar.", pos: "top-center" });
      }
    },
    error: error,
  });
}

function limpiar() { }
