const csrfToken = document.head.querySelector(
  "[name~=csrf-token][content]"
).content;
var total = 0;
let sucursales = [];
var $table = $("#table");
let id_sucursal = 0;
let productos = [];
let detalle_productos = [];
let contador = 0;
let id_viaje_u = 0;
let total_venta = 0;
let id_empresa = 1;
let id_caja = 0;
let fecha_apertura = "";

$("#fecha_venta").val(moment().format("YYYY-MM-DD HH:mm:ss"));
$(".fecha_modal").text(moment().format("YYYY-MM-DD"));
$("#fecha_apertura").val(moment().format("YYYY-MM-DD"));
$(document).ready(function () {
  cargar_tabla();
});
$(function () {
  $table.bootstrapTable("refreshOptions", {
    locale: "es-AR",
  });
});
$("#fecha_venta").change(function () {
  $(".fecha_modal").text(this.value);
});
$("#id_sucursales").change(function () {
  $(".caja_loader").show();
  id_sucursal = this.value;
  let almacen_cargar = sucursales.findIndex((x) => x.id == id_sucursal);
  detalle_productos = [];
  $("#tabla").html("");
  cargar_almacen(sucursales[almacen_cargar].almacenes);
});

$("#id_almacenes").change(function () {
  $(".caja_loader").show();

  detalle_productos = [];
  $("#tabla").html("");
  cargar_productos();
});

/* SELECT 2 METODO PAGO */
$(document).ready(function () {
  $("#id_cliente").select2();
});

$(document).ready(function () {
  $("#tipo_pago").select2();
});

$(document).ready(function () {
  $("#tipo_moneda").select2();
});
$("#tipo_pago").change(function () {
  /*  if (this.value == 1) {
     $(".caja_tarjeta").hide();
   } else {
     $(".caja_tarjeta").show();
   } */
});

$(".cargar_caja").click(function () {
  $(".caja_loader").show();
  $("#modal_caja").modal("show");
  cargar_caja();
});
$(".guardar_caja").click(function () {
  $(".caja_loader").show();
  if (id_caja == 0) {
    insertar_caja();
  } else {
    actualizar_caja();
  }
});

$("#monto_tarjeta").hide();
$("#monto_giftcard").hide();

$("#tipo_pago").change(function () {
  var selectedText = $(this).find("option:selected").text();
  if (selectedText.includes("GIFT") && selectedText.includes("TARJETA")) {
    $("#monto_tarjeta").show();
    $("#monto_giftcard").show();
  } else {
    $("#monto_tarjeta").hide();
    $("#monto_giftcard").hide();

    if (selectedText.includes("GIFT")) {
      $("#monto_giftcard").show();
    } else {
      if (selectedText.includes("TARJETA")) {
        $("#monto_tarjeta").show();
      } else {
        $("#monto_tarjeta").hide();
      }
    }
  }
});

function llenarTipoPago() {
  $.ajax({
    url: urlServicio + "API_REST/cargarTiposPagos",
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      var tipo_pago = $("#tipo_pago").html("");
      if (d.errorCode == 0) {
        let res = d.msg;

        tipos_pagos = res.tipo_pago;
        for (let index = 0; index < res.tipo_pago.length; index++) {
          const element = res.tipo_pago[index];

          if (index == 0) {
            tipo_pago.append(
              '<option selected value="' +
                element.codigoclasificador +
                '">' +
                element.descripcion +
                "</option>"
            );
          } else {
            tipo_pago.append(
              '<option value="' +
                element.codigoclasificador +
                '">' +
                element.descripcion +
                "</option>"
            );
          }
        }
      }
    },
    error: error,
  });
}
function llenarTipoMoneda() {
  $.ajax({
    url: urlServicio + "API_REST/cargarTiposMonedas",
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      var tipo_moneda = $("#tipo_moneda").html("");
      if (d.errorCode == 0) {
        let res = d.msg;

        tipos_monedas = res.tipo_moneda;
        for (let index = 0; index < res.tipo_moneda.length; index++) {
          const element = res.tipo_moneda[index];

          if (index == 0) {
            tipo_moneda.append(
              '<option selected value="' +
                element.codigoclasificador +
                '">' +
                element.descripcion +
                "</option>"
            );
          } else {
            tipo_moneda.append(
              '<option value="' +
                element.codigoclasificador +
                '">' +
                element.descripcion +
                "</option>"
            );
          }
        }
      }
    },
    error: error,
  });
}

function cargar_tabla() {
  id_empresa = usuario.id_empresa;
  $.ajax({
    url: urlServicio + "API_REST/cargar_funciones_ventas/" + id_empresa,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      var sucu = $("#id_sucursales").html("");
      if (d.errorCode == 0) {
        let res = d.msg;
        sucursales = res.sucursal;
        for (let index = 0; index < res.sucursal.length; index++) {
          const element = res.sucursal[index];
          if (index == 0) {
            sucu.append(
              '<option selected value="' +
                element.id +
                '">' +
                element.nombre +
                "</option>"
            );
          } else {
            sucu.append(
              '<option value="' +
                element.id +
                '">' +
                element.nombre +
                "</option>"
            );
          }
        }
        console.log(res.cliente)
        verificar_caja();
        llenarTipoPago();
        llenarTipoMoneda();
        cargar_almacen(res.sucursal[0].almacenes);
        cargar_clientes(res.cliente);
      }
    },
    error: error,
  });
}

function cargar_almacen(array) {
  let almacen = $("#id_almacenes").html("");
  for (let index = 0; index < array.length; index++) {
    const element = array[index];
    almacen.append(
      '<option value="' + element.id + '">' + element.nombre + "</option>"
    );
  }
  cargar_productos();
}

function cargar_clientes(array) {
  let almacen = $("#id_cliente").html("");
  for (let index = 0; index < array.length; index++) {
    const element = array[index];
    almacen.append(
      '<option value="' + element.id + '">' + element.nombre+ " NIT:" + element.nit + "</option>"
    );
  }
}

function verificar_caja() {
  let id_sucursal = $("#id_sucursales").val();

  $.ajax({
    url:
      urlServicio + "API_REST/cargar_caja_id/" + usuario.id + "/" + id_sucursal,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".cargar_caja").text("Apertura de caja");

      if (d.errorCode == 0) {
        $(".cargar_caja").text("Cierre de caja");
      }
    },
    error: error,
  });
}
function cargar_caja() {

  let id_sucursal = $("#id_sucursales").val();
  $.ajax({
    url:
      urlServicio + "API_REST/cargar_caja_id/" + usuario.id + "/" + id_sucursal,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {

      $(".caja_loader").hide();
      if (d.errorCode == 0) {
        console.log(d.msg);
        $(".cargar_caja").text("Cierre de caja");
        id_caja = d.msg.id;
        $("#id_monto").attr("disabled", true);
        $("#id_monto").val(d.msg.monto_apertura);
        $("#id_monto_v").val(d.msg.montos_ventas_efectivo);
        fecha_apertura = d.msg.fecha_reg;
        $("#fecha_apertura").val(fecha_apertura);
        $(".d_cierre").removeClass("d-none");
        $("#apertura").text("Cierre de caja");
        $("#id_monto_t").val(d.msg.monto_tarjeta);
        $("#id_monto_q").val(d.msg.montos_ventas_otros);
      } else {
        id_caja = 0;
        $(".cargar_caja").text("Apertura de caja");

        $("#id_monto").attr("disabled", false);
        $("#id_monto").val("0");
        $("#id_monto_v").val("0");
        $("#id_monto_t").val("0");
        $("#id_monto_q").val("0");
        $("#descripcion_caja").val("");
        $("#fecha_apertura").val(moment().format("YYYY-MM-DD HH:mm:ss"));
        $(".d_cierre").addClass("d-none");
        $("#apertura").text("Apertura de caja");
      }
    },
    error: error,
  });
}

function insertar_caja() {
  let id_sucursal = $("#id_sucursales").val();
  let id_usuario = usuario.id;
  let monto = $("#id_monto").val();
  let datos = {
    id_usuario: id_usuario,
    id_sucursal: id_sucursal,
    monto_apertura: monto,
  };
  let enviar = JSON.stringify(datos);
  $.ajax({
    url: urlServicio + "API_REST/insertar_caja",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();
      if (d.errorCode == 0) {
        id_caja = d.msg.id;
        $("#id_monto").val(d.msg.monto);
        $("#modal_caja").modal("hide");
        $(".cargar_caja").text("Cierre de caja");

        Snackbar.show({
          text: "Caja abierta correctamente",
          pos: "bottom-center",
          showAction: false,
          actionText: "Deshacer",
          duration: 3000,
          textColor: "#fff",
          backgroundColor: "#4caf50",
        });
      } else {
      }
    },
    error: error,
  });
}

function actualizar_caja() {
  // let fecha = moment($("#fecha_apertura").val()).format('YYYY-MM-DD');
  let datos = {
    id_usuario: usuario.id,
    id_sucursal: $("#id_sucursales").val(),
    fecha: fecha_apertura,
    monto_cierre: $("#id_monto_v").val(),
    monto_tarjeta: $("#id_monto_t").val(),
    monto_qr: $("#id_monto_q").val(),
    descripcion: $("#descripcion_caja").val(),
    id: id_caja,
  };
  let enviar = JSON.stringify(datos);
  $.ajax({
    url: urlServicio + "API_REST/actualizar_caja",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();
      if (d.errorCode == 0) {
        id_caja = 0;
        $("#modal_caja").modal("hide");
        Snackbar.show({
          text: "Caja cerrada correctamente",
          pos: "bottom-center",
          showAction: false,
          actionText: "Deshacer",
          duration: 3000,
          textColor: "#fff",
          backgroundColor: "#4caf50",
        });
      } else {
      }
    },
    error: error,
  });
}

function cargar_productos() {
  let id_almacen = $("#id_almacenes").val();
  $.ajax({
    url: urlServicio + "API_REST/cargar_productos_venta/" + id_almacen,
    //data: datos,
    type: "GET",
    dataType: "json",
    //contentType: "application/json; charset=utf-8",
    success: function (d) {
      $(".caja_loader").hide();

      if (d.errorCode == 0) {
        let res = d.msg;
        productos = res;
        $("#productos_").html("");
        for (let index = 0; index < res.length; index++) {
          const element = res[index];
          pintar_productos(element);
        }
      } else {
        $("#productos_").html(
          '<h4 class="text-center">No existe productos</h4>'
        );
      }
    },
    error: error,
  });
}

function pintar_productos(elemento) {
  let img = "img/subir.png";
  if (elemento.foto != "sin_imagen") {
    img = "img/" + id_empresa + "/" + elemento.foto;
  }
  let precios =
    '<select class="form-control" id="precio_' +
    elemento.id +
    '">' +
    '<option value="' +
    elemento.precio +
    '">' +
    elemento.precio +
    "</option>" +
    '<option value="' +
    elemento.precio_2 +
    '">' +
    elemento.precio_2 +
    "</option>" +
    "</select>";
  var cuerpo = "";
  cuerpo =
    ' <div class="items">' +
    '<div class="item-content">' +
    '<div class="product-info">' +
    ' <img src="' +
    img +
    '" alt="avatar">' +
    '<div class="user-meta-info">' +
    '<p class="d-none"><span>Codigo_barra: </span>' +
    elemento.cod_barra +
    "</p>" +
    '<a  class="btn btn-soft-success btn-rounded  ">' +
    elemento.nombre +
    "</a>" +
    '<p class="product-category-addr"><span>Stock: </span>' +
    elemento.cantidad +
    "</p>" +
    " </div>" +
    "</div>" +
    '<div class="product-price">' +
    '<p class="product-category-addr"><span>precio: </span></p><br>' +
    " </div>" +
    "<div>" +
    precios +
    "</div>" +
    ' <div class="action-btn">' +
    ' <a data-producto="' +
    elemento.id +
    '" class="btn btn-success font-20 agregar"><i class="las la-check-double"></i></a>' +
    "</div>" +
    "</div>" +
    "</div>";
  $("#productos_").append(cuerpo);
}

function pintar_paginador() {
  let cuerpo = "";
  cuerpo =
    '<div class="pagination p13 text-center w-100 mt-4">' +
    ' <ul class="mx-auto">' +
    '<a href="#" class="prev">' +
    " <li>Prev</li>" +
    " </a>" +
    ' <a class="is-active" href="#">' +
    "  <li>1</li>" +
    "</a>" +
    '<a href="#">' +
    " <li>2</li>" +
    "</a>" +
    '<a href="#">' +
    " <li>3</li>" +
    " </a>" +
    '<a href="#" class="next">' +
    " <li>Next</li>" +
    " </a>" +
    "</ul>" +
    "</div>";
  $("#productos_").append(cuerpo);
}
$("#id_merma").on("change", function () {
  detalle_productos = [];
  $("#tabla").html("");
});

$(document).on("click", ".agregar", function (e) {

  let t = this.dataset.producto;
  console.log(t)
  console.log(productos)
  $("#gifcard").val("0.00");
  let producto = productos.find((x) => x.id == t);
  let elemento = {
    id: producto.id,
    nombre: producto.nombre,
    contador: contador,
  };
  if (producto.cantidad <= 0) {
    Snackbar.show({
      text: "Producto sin stock",
      pos: "top-center",
      showAction: false,
      actionText: "Deshacer",
      duration: 3000,
      textColor: "#fff",
      backgroundColor: "#f44336",
    });
  } else {
    cargar_detalle(elemento);
    sumar_total();
  }
});

async function agregar_por_codigo(cod_barra) {
  try {
    let producto = await codigoBarra(cod_barra);
    if (producto) {
      let elemento = {
        id: producto.id,
        nombre: producto.nombre,
        contador: contador,
      };
      if (producto.cantidad <= 0) {
        Snackbar.show({
          text: "Producto sin stock",
          pos: "bottom-center",
          showAction: false,
          actionText: "Deshacer",
          duration: 3000,
          textColor: "#fff",
          backgroundColor: "#f44336",
        });
      } else {
        cargar_detalle(elemento);
        sumar_total();
      }
    }
  } catch (error) {
    window.alert(
      "El codigo:" +
        cod_barra +
        "-No esta registrado en la base de datos-" +
        error
    );
  }
}

function codigoBarra(cod_barra) {
  return new Promise((resolve, reject) => {
    setTimeout(() => {
      resolve(productos.find((x) => x.cod_barra == cod_barra.trim()));
    }, 300);
  });
}

function cargar_detalle(elemento) {
  console.log('cargando_detalle..........')
  let cuerpo = "";
  let precio_seleccionado = parseFloat(
    $("#precio_" + elemento.id).val()
  ).toFixed(2);

  let descuento_item = "";
  cuerpo =
    '<tr id="t' +
    elemento.contador +
    '">' +
    "<td>" +
    elemento.nombre +
    "</td>" +
    '<td><input id="c' +
    elemento.contador +
    '" class="form-control cantidad" data-producto="' +
    elemento.id +
    '" data-cantidad="' +
    elemento.contador +
    '" type="number" value=1></td>' +
    '<td><input id="cu' +
    elemento.contador +
    '" class="form-control costo_un" data-costo_un="' +
    elemento.contador +
    '" type="number" value=' +
    precio_seleccionado +
    "></td>" +
    '<td><input id="desc' +
    elemento.contador +
    '" class="form-control desc_item" data-costo_un="' +
    elemento.contador +
    '" type="number" value=' +
    descuento_item +
    "></td>" +
    '<td><input id="s' +
    elemento.contador +
    '" class="form-control subtotal" data-subtotal="' +
    elemento.contador +
    '" type="number" value=' +
    precio_seleccionado +
    "></td>" +
    '<td><a data-eliminar="' +
    elemento.contador +
    '" class="btn btn-danger eliminar"><i class="fa fa-trash"></i></a></td>' +
    "</tr>";

  let producto_search = detalle_productos.find((x) => x.id === elemento.id);

  if (typeof (producto_search) == 'undefined') {
    detalle_productos.push(elemento);
    $("#tabla").append(cuerpo);
  } else {
    Snackbar.show({ text: 'El producto ya existe', pos: 'top-center' });
  }
  contador++;
}
$("#id_descuento").on("change", function () {
  let total = $("#subTotalTotal").text();
  let descuento_ = $(this).val();
  let descuento = parseFloat(total) - parseFloat(descuento_);

  if (descuento_ < parseFloat(total)) {
    $(".tot_descuento").text(descuento);
    $("#id_cancelo").val(0);
    $("#id_vuelto").text(0);
  } else {
    $(this).val(0);
    $("#id_cancelo").val(0);
    $("#id_vuelto").text(0);
  }
});
$("#id_cancelo").keyup(function () {
  let total = $("#totalMonto").text();
  let cancelo = $("#id_cancelo").val();
  let vuelto = parseFloat(cancelo) - parseFloat(total);

  $("#id_vuelto").text(vuelto);
});
$(document).on("change keyup", ".cantidad", function (e) {
  let cantidad = this.value;
  let id_almacen = $("#id_almacenes").val();
  let id_producto = this.dataset.producto;
  verificarInv(cantidad, id_almacen, id_producto, this.dataset.cantidad);
});

function verificarInv(cantidad, id_almacen, id_producto, id_ca) {
  var datos = {};
  datos.cantidad = cantidad;
  datos.id_almacen = id_almacen;
  datos.id_producto = id_producto;
  var enviar = JSON.stringify(datos);
  let id = id_ca;

  $.ajax({
    url: urlServicio + "API_REST/verificar_inventario",
    data: enviar,
    type: "POST",
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (d) {
      if (!d.transaccion) {
        $(".cantidad").val(1);
        cantidad = 1;
        Snackbar.show({
          text: d.msg,
          pos: "top-center",
        });
      }
      let costo_un = $("#cu" + id).val();
      let subtotal = parseFloat(cantidad * costo_un).toFixed(2);
      $("#s" + id).val(subtotal);
      sumar_total();
    },
    error: function (data, textStatus, jqXHR) {
      console.log(data);
      console.log(textStatus);
      console.log(jqXHR);

      $(".loader").toggle();
    },
  });
}

$(document).on("change keyup", ".costo_un", function (e) {
  let id = this.dataset.costo_un;
  let costo_un = this.value;
  let cantidad = $("#c" + id).val();
  let subtotal = costo_un * cantidad;
  $("#s" + id).val(subtotal);
  sumar_total();
});

$(document).on("change keyup", ".desc_item", function (e) {
  sumar_total();
});

$(document).on("change keyup", ".subtotal", function (e) {
  let id = this.dataset.subtotal;
  let subtotal = this.value;
  let cantidad = $("#c" + id).val();
  let costo_un = subtotal / cantidad;
  $("#cu" + id).val(costo_un);
  sumar_total();
});
$(document).on("click", ".eliminar", function (e) {
  let t = this.dataset.eliminar;
  let index = detalle_productos.findIndex((x) => x.id == t);
  detalle_productos.splice(index, 1);
  $("#t" + t).remove();
  sumar_total();
});

function validateGiftCard() {
  let giftcard = $("#gifcard").val();

  if (parseFloat(giftcard) <= parseFloat(total)) {
    let totalTotal = parseFloat(total) - parseFloat(giftcard);

    $("#totalMount").html(totalTotal);
    $(".result").text(totalTotal);
    $(".tot_descuento").text(totalTotal);
  } else {
    if (giftcard > total)
      Snackbar.show({
        text: "Monto Giftcard No debe ser Mayor al Total.",
        pos: "top-center",
      });
  }
}

function sumar_total() {
  var numbers = $(".subtotal");
  var cant_items = $(".cantidad");
  var prec_items = $(".costo_un");
  var descuentos = $(".desc_item");

  //Calcular el descuento por item
  for (var i = 0; i < descuentos.length; i++) {
    if (
      parseFloat(descuentos.eq(i).val()) < parseFloat(prec_items.eq(i).val())
    ) {
      cant_precio =
        parseFloat(cant_items.eq(i).val()) * parseFloat(prec_items.eq(i).val());

      cant_desc =
        parseFloat(cant_items.eq(i).val()) * parseFloat(descuentos.eq(i).val());

      total_desc = (cant_precio - cant_desc).toString();
      $("#s" + i).val(total_desc);
    }
    if (
      parseFloat(descuentos.eq(i).val()) > parseFloat(prec_items.eq(i).val())
    ) {
      $("#desc" + i).val(0);
    }
    if (
      parseFloat(descuentos.eq(i).val()) == parseFloat(prec_items.eq(i).val())
    ) {
      $("#desc" + i).val(0);
    }
  }

  //Calcular el Total
  total = 0;
  for (var i = 0; i < numbers.length; i++) {
    total = total + parseFloat(numbers.eq(i).val());
  }
  $(".result").text(total);
  $(".tot_descuento").text(total);
}

$(".guardar").click(function () {
  /* $(".guardar").attr("disabled", true); */
  let descuento = $("#id_descuento").val();
  let vuelto = $("#id_vuelto").text();
  if (
    detalle_productos.length > 0 &&
    $("#id_cliente").val() != 0 &&
    $("#id_almacenes").val() != 0 &&
    parseFloat(descuento) >= 0
  ) {
    if (parseFloat(vuelto) >= 0) {
      construir_json();
    } else {
      Snackbar.show({
        text: "El vuelto debe ser mayor a cero",
        postion: "top-center",
        backgroundColor: "#dc3545",
        textColor: "#fff",
        duration: 3000,
      });
    }
  } else {
    if (!isNaN(descuento)) {
      $("#id_descuento").addClass("need_input");
    }
    Snackbar.show({
      text: "No existe productos, tiene que seleccionar un cliente, tiene que seleccionar un almacen",
      pos: "top-center",
    });
  }
});

$(".cancelar").click(function () {
  location.href = "lista_ventas.html";
});

// ? Logica para Obtener el estado del Check
var $checkbox = $("#is_factura");
var isChecked = $checkbox.is(":checked"); // Obtener el estado inicial
var estadoCheckFactura = false;

$checkbox.on("change", function () {
  isChecked = $checkbox.is(":checked"); // Actualizar el estado cuando cambie
  if (isChecked) {
    estadoCheckFactura = true;
  } else {
    estadoCheckFactura = false;
  }
});

function construir_json() {
  let datos = {};
  var costo = 0;
  for (let index = 0; index < detalle_productos.length; index++) {
    const element = detalle_productos[index];
    element.precio = $("#cu" + element.contador).val();
    element.desc = $("#desc" + element.contador).val(); //TODO check later
    element.costo = $("#s" + element.contador).val();
    element.cantidad = $("#c" + element.contador).val();
    element.id_almacen = $("#id_almacenes").val();
    element.id_producto = element.id;
    costo += parseFloat(element.costo);
  }
  datos.id_viaje = 0;
  if (id_viaje_u > 0) {
    datos.id_viaje = id_viaje_u;
  }
  datos.productos = detalle_productos;
  datos.id_sucursal = $("#id_sucursales").val();
  if (datos.id_viaje > 0) {
    datos.id_cliente = 0;
    datos.id_responsable = $("#id_responsable").val();
  } else {
    datos.id_cliente = $("#id_cliente").val();
    datos.id_responsable = 0;
  }
  datos.id_usuario = usuario.id;
  datos.descuento = $("#id_descuento").val();

  /* var today = new Date();
  var dd = String(today.getDate()).padStart(2, "0");
  var mm = String(today.getMonth() + 1).padStart(2, "0"); //January is 0!
  var yyyy = today.getFullYear();
  var hours = today.getHours();
  var minutes = String(today.getMinutes()).padStart(2, "0");
  var seconds = String(today.getSeconds()).padStart(2, "0");
  var milliseconds = today.getMilliseconds();

  let fechaInput =
    yyyy +
    "-" +
    mm +
    "-" +
    dd +
    "T" +
    hours +
    ":" +
    minutes +
    ":" +
    seconds +
    "." +
    milliseconds; */
  datos.fecha_venta = $("#fecha_venta").val();

  datos.tipo_venta = $("#tipo_venta").val();
  datos.total = costo;
  datos.cambio = parseFloat($("#id_vuelto").text());
  datos.nombre = $("#nombre_input").val();
  datos.ci = $("#ci_input").val();
  datos.tipo_pago = $("#tipo_pago").val();
  datos.tipo_moneda = $("#tipo_moneda").val();
  datos.monto_tarjeta = $("#monto_tarjeta").val();
  datos.monto_giftcard = $("#gifcard").val();

  let numeroTarjeta =
    $("#tarjeta1").val() +
    $("#tarjeta2").val() +
    $("#tarjeta3").val() +
    $("#tarjeta4").val();
  if (numeroTarjeta.length < 16) {
    datos.tarjeta = 0;
  } else {
    datos.tarjeta = numeroTarjeta;
  }

  datos.estado = 1;
  if ($("#es_paquete").is(":checked")) {
    datos.es_paquete = 1;
  } else {
    datos.es_paquete = 0;
  }
  if (datos.tipo_venta == 1) {
    datos.saldo = 0;
  } else {
    datos.saldo = datos.total;
  }

  datos.nota = $("#nota").val();

  /* console.log(datos); */
  if (
    productos.length > 0 &&
    $("#id_cliente").val() > 0 &&
    $("#id_sucursales").val() > 0 &&
    $("#id_almacenes").val() > 0
  ) {
    /* insertar_venta(datos); */
    /* enviarFactura(datos); */
    if (estadoCheckFactura) {
      console.log("ingreso a check true")
      enviarFactura(datos);
    } else {
      console.log("ingreso a check false")
      globalEnviarFactura(datos);
    }
  } else {
    Snackbar.show({
      text: "Debe agregar un producto, debe seleccionar un cliente, debe seleccionar un almacen.",
      pos: "top-center",
    });
  }
}

function insertar_venta(datos) {
  var enviar = JSON.stringify(datos);
  $(".caja_loader").show();
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "API_REST/Offline/EmitirOffLine.php",
    type: "POST",
    dataType: "json",
    data: {
      metodo: "insertar_venta",
      enviar: enviar,
    },
    success: function (d) {
      if (d.transaccion) {
        Snackbar.show({ text: "Se inserto correctamente.", pos: "top-center" });
        if (datos.tipo_venta == 1) {
          location.href = "lista_ventas.html";
        } else {
          location.href = "lista_ventas_credito.html";
        }
        setTimeout(() => {
          location.href = "lista_ventas.html";
        }, 1000);
        $(".caja_loader").hide();
      } else {
        Snackbar.show({ text: d.msg, pos: "top-center" });
      }
    },
    error: error,
  });
}

function enviarFactura(enviar) {
  let data = enviar;
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "API_REST/enviarFacturaSiat",
    type: "POST",
    data: JSON.stringify({
      metodo: "enviarFactura",
      dataFactura: data,
      checkNormal: estadoCheckFactura,
    }),
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function (response) {
      if (typeof response.res.RespuestaServicioFacturacion !== "undefined") {
        const responseSiat = response.res.RespuestaServicioFacturacion;
        if (responseSiat.codigoEstado === 908) {
          Snackbar.show({
            text: "Validada, Se inserto correctamente.",
            pos: "top-center",
          });
          window.open(
            "imprimir_venta_cinta_jspdf.html?v=" + response.venta.id,
            "_blank"
          );
          setTimeout(function () {
            location.href = "lista_ventas.html";
          }, 3000);
        } else if (responseSiat.codigoEstado === 902) {
          Snackbar.show({
            text: responseSiat.mensajesList.descripcion,
            pos: "top-center",
          });
          setTimeout(function () {
            window.location.href = "ventas.html";
          }, 3000);
        } else {
          Snackbar.show({
            text: "Error al emitir Factura-Rechazada.",
            pos: "top-center",
          });
        }
      } else {
        Snackbar.show({
          text: response.msg,
          pos: "top-center",
        });
        if (response.transaccion == 1) {
          setTimeout(function () {
            window.location.href = "lista_ventas.html";
          }, 3000);
        }
        if (response.transaccion == 5) {
          setTimeout(function () {
            window.location.href = "Impuestos_Cufd.html";
          }, 3000);
        }
      }
    },
    error: error,
  });
}

function globalEnviarFactura(datos) {
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/EventoSignificativoService.php",
    type: "GET",
    data: {
      metodo: "getExistsEventSin",
    },
    dataType: "json",
    success: function (res) {
      /* console.log(res.existe);
      console.log(res.evento); */
      if (res.transaccion) {
         if (res.msg.existe && (res.msg.evento.CodigoDesc == 2 || res.msg.evento.CodigoDesc == 5 || res.msg.evento.CodigoDesc == 6 || res.msg.evento.CodigoDesc == 7)) {
          enviarFactura(datos);
        } else {
          if (res.msg.existe) {
            insertar_venta(datos);
          } else {
            enviarFactura(datos);
          }
        }
      } else {
        Snackbar.show({
          text: res.msg,
          pos: "top-center",
        });
      }
    },
    error: function (data, textStatus, jqXHR) {
      console.log(data);
      console.log(textStatus);
      console.log(jqXHR);
    },
  });
}

// ? Obtiene el Evento Significativo
window.onload = function () {
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/EventoSignificativoService.php",
    type: "GET",
    data: {
      metodo: "getExistsEventSin",
    },
    dataType: "json",
    success: function (res) {
      if (res.msg.existe) {
        $("#fecha_venta").prop("readonly", false);
      } else {
        $("#fecha_venta").prop("readonly", true);
      }
    },
    error: function (data, textStatus, jqXHR) {
      console.log(data);
      console.log(textStatus);
      console.log(jqXHR);
    },
  });
};

function limpiar() {}