let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;
let productos = [];
let detalle_productos = [];
let contador = 0;
let id_tratamiento = 0;
let id_cliente_tratamiento = 0;
let params = new URLSearchParams(location.search);
let total_venta = 0;
let id_empresa = 1
let id_caja = 0;
let fecha_apertura = '';
let usuarios_venta = [];
$("#fecha_venta").val(moment().format('YYYY-MM-DD'));
$(".fecha_modal").text(moment().format('YYYY-MM-DD'));
$("#fecha_apertura").val(moment().format('YYYY-MM-DD'));
// $(document).ready(function() {

//     cargar_tabla();


// });
$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});
$("#fecha_venta").change(function() {
    $(".fecha_modal").text(this.value);
});
$("#id_sucursales").change(function() {
    $(".caja_loader").show();
    id_sucursal = this.value;
    let almacen_cargar = sucursales.findIndex(x => x.id == id_sucursal);
    detalle_productos = [];
    $("#tabla").html('');
    cargar_almacen(sucursales[almacen_cargar].almacenes);
});

$("#id_almacenes").change(function() {
    $(".caja_loader").show();

    detalle_productos = [];
    $("#tabla").html('');
    cargar_productos();
});
$("#tipo_pago").change(function() {
    if (this.value == 1) {
        $(".caja_tarjeta").hide();
    } else {
        $(".caja_tarjeta").show();
    }
});
$(".cargar_caja").click(function() {
    $(".caja_loader").show();
    $("#modal_caja").modal('show');
    cargar_caja();
});
$(".guardar_caja").click(function() {
    $(".caja_loader").show();
    if (id_caja == 0) {
        insertar_caja();
    } else {
        actualizar_caja();
    }

});

function cargar_tabla() {
    id_empresa = usuario.id_empresa;
    if (params.get('v')) id_tratamiento = params.get('v');
    if (params.get('c')) id_cliente_tratamiento = params.get('c');
    console.log(id_cliente_tratamiento);
    $.ajax({
        url: urlServicio + 'API_REST/cargar_funciones_ventas/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            var sucu = $("#id_sucursales").html('');

            if (d.errorCode == 0) {
                let res = d.msg;
                sucursales = res.sucursal;
                for (let index = 0; index < res.sucursal.length; index++) {
                    const element = res.sucursal[index];
                    if (index == 0) {
                        sucu.append('<option selected value="' + element.id + '">' + element.nombre + '</option>');

                    } else {
                        sucu.append('<option value="' + element.id + '">' + element.nombre + '</option>');

                    }
                }
                $("#tc").val(res.sucursal[0].tc);
                cargar_almacen(res.sucursal[0].almacenes);
                cargar_clientes(res.cliente);
                if (id_cliente_tratamiento > 0) {
                    $("#id_cliente").val(id_cliente_tratamiento);
                    $("#id_cliente").attr('disabled', true);
                }
                usuarios_venta = res.usuarios;
            }
        },
        error: error


    });
}


function cargar_almacen(array) {

    let almacen = $("#id_almacenes").html('<option value="0">Seleccione una ubicacion</option>');
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        almacen.append('<option value="' + element.id + '">' + element.nombre + '</option>');
    }
    almacen.select2();
    cargar_productos();

}

function cargar_clientes(array) {

    let almacen = $("#id_cliente").html('');
    for (let index = 0; index < array.length; index++) {
        const element = array[index];
        almacen.append('<option value="' + element.id + '">' + element.nombre + '</option>');
    }
    almacen.select2();
}

function cargar_usuarios(id, css) {

    let cabecera = '<select class="form-control ' + css + '" id="u' + id + '">';
    let cuerpo = '';

    usuarios_venta.map((element) => {
        cuerpo += '<option value="' + element.id + '">' + element.nombre + '</option>';
    });
    return cabecera = cabecera + cuerpo + '</select>';

}

// modal de cierrre de caja
function cargar_caja() {
    let id_sucursal = $("#id_sucursales").val();
    $.ajax({
        url: urlServicio + 'API_REST/cargar_caja_id/' + usuario.id + '/' + id_sucursal,
        // data: datos,
        type: "GET",
        dataType: "json",
        success: function(d) {
            $(".caja_loader").hide();

            // console.log(d);
            if (d.errorCode == 0) {
                id_caja = d.msg.id;
                $("#id_monto").attr('disabled', true);
                $("#id_monto").val(d.msg.monto_apertura);
                fecha_apertura = (d.msg.fecha_reg);
                $("#fecha_apertura").val(fecha_apertura);
                $(".d_cierre").removeClass('d-none');
                $("#apertura").text('Cierre de caja');
                $("#id_monto_v").val(d.msg.monto_efectivo);
                $("#id_monto_t").val(d.msg.monto_tarjeta);
                $("#id_monto_q").val(d.msg.monto_qr);
                //
                $("#id_monto_transferencia_t").val(d.msg.monto_transferencia);
            } else {
                id_caja = 0;
                $("#id_monto").attr('disabled', false);
                $("#id_monto").val('0');
                $("#id_monto_v").val('0');
                $("#id_monto_t").val('0');
                $("#id_monto_q").val('0');
                //
                $("#id_monto_transferencia_t").val('0');
                //
                $("#descripcion_caja").val('');
                $("#fecha_apertura").val(moment().format('YYYY-MM-DD HH:mm:ss'));
                $(".d_cierre").addClass('d-none');
                $("#apertura").text('Apertura de caja');

            }
        },
        error: error
    });

}

function insertar_caja() {
    let id_sucursal = $("#id_sucursales").val();
    let id_usuario = usuario.id;
    let monto = $("#id_monto").val();
    let datos = {
        id_usuario: id_usuario,
        id_sucursal: id_sucursal,
        monto_apertura: monto,
    }
    let enviar = JSON.stringify(datos);
    $.ajax({
        url: urlServicio + 'API_REST/insertar_caja',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();
            if (d.errorCode == 0) {
                id_caja = d.msg.id;
                $("#id_monto").val(d.msg.monto);
                $("#modal_caja").modal('hide');
                Snackbar.show({
                    text: 'Caja abierta correctamente',
                    pos: 'bottom-center',
                    showAction: false,
                    actionText: 'Deshacer',
                    duration: 3000,
                    textColor: '#fff',
                    backgroundColor: '#4caf50'
                });
            } else {

            }
        },
        error: error
    });
}

function actualizar_caja() {
    // let fecha = moment($("#fecha_apertura").val()).format('YYYY-MM-DD');
    let datos = {
        id_usuario: usuario.id,
        id_sucursal: $("#id_sucursales").val(),
        fecha: fecha_apertura,
        monto_cierre: $("#id_monto_v").val(),
        monto_tarjeta: $("#id_monto_t").val(),
        monto_qr: $("#id_monto_q").val(),
        descripcion: $("#descripcion_caja").val(),
        monto_transferencia: $("#id_monto_transferencia_t").val(),
        id: id_caja
    }
    let enviar = JSON.stringify(datos);
    $.ajax({
        url: urlServicio + 'API_REST/actualizar_caja',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();
            if (d.errorCode == 0) {
                id_caja = 0;
                $("#modal_caja").modal('hide');
                Snackbar.show({
                    text: 'Caja cerrada correctamente',
                    pos: 'bottom-center',
                    showAction: false,
                    actionText: 'Deshacer',
                    duration: 3000,
                    textColor: '#fff',
                    backgroundColor: '#4caf50'
                });
            } else {

            }
        },
        error: error
    });
}

function cargar_productos() {
    let id_almacen = $("#id_almacenes").val();
    $.ajax({
        url: urlServicio + 'API_REST/cargar_productos_venta/' + id_almacen + '/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();
            cargar_servicios();

            if (d.errorCode == 0) {
                let res = d.msg;
                productos = res;
                $("#productos_").html('');

                res.map((element) => {
                    pintar_productos(element, 'productos_');
                });
            } else {
                $("#productos_").html('<h4 class="text-center">No existe productos</h4>');
            }


        },
        error: error


    });
}

function cargar_servicios() {

    $.ajax({
        url: urlServicio + 'API_REST/cargar_sevicios_venta/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {
            $(".caja_loader").hide();


            if (d.errorCode == 0) {
                let res = d.msg;
                res.map((element) => {
                    productos.push(element);
                    if (element.id_tipo == 2) {
                        pintar_productos(element, 'servicios_');
                    } else {
                        pintar_productos(element, 'tratamientos_');

                    }
                });
            }


        },
        error: error


    });
}

function pintar_productos(elemento, id_contenedor) {
    let img = 'img/subir.png';
    if (elemento.foto != 'sin_imagen') {
        img = 'img/' + id_empresa + '/' + elemento.foto;
    }
    let tipo = "";
    if (elemento.id_tipo == 1) {
        tipo = '<p class="product-category-addr"><span>Stock: </span>' + parseFloat(elemento.cantidad).toFixed(2) + '</p>'

    }
    let precios = '<select class="form-control" id="precio_' + elemento.id + '">' +
        '<option value="' + elemento.precio + '">' + elemento.precio + '</option>' +
        '<option value="' + elemento.precio_2 + '">' + elemento.precio_2 + '</option>' +
        '</select>';
    var cuerpo = '';
    cuerpo = ' <div class="items">' +
        '<div class="item-content">' +
        '<div class="product-info">' +
        ' <img src="' + img + '" onerror="img_error(this)" alt="avatar">' +
        '<div class="user-meta-info">' +
        '<a  class="btn btn-soft-success btn-rounded  ">' + elemento.codigo + '</a>' +
        '<a  class="btn btn-soft-success btn-rounded  ">' + elemento.nombre + '</a>' +
        tipo +
        ' </div>' +
        '</div>' +
        '<div class="product-price d-none">' +
        '<p class="product-category-addr"><span>precio: </span></p><br>' +

        ' </div>' +
        '<div class="d-none">' +
        precios +
        '</div>' +
        ' <div class="action-btn">' +
        ' <a data-producto="' + elemento.id + '" class="btn btn-success font-20 agregar"><i class="las la-check-double"></i></a>' +
        '</div>' +
        '</div>' +
        '</div>';
    $("#" + id_contenedor).append(cuerpo);
}

function pintar_paginador(id_contenedor) {
    let cuerpo = '';
    cuerpo = '<div class="pagination p13 text-center w-100 mt-4">' +
        ' <ul class="mx-auto">' +
        '<a href="#" class="prev">' +
        ' <li>Prev</li>' +
        ' </a>' +
        ' <a class="is-active" href="#">' +
        '  <li>1</li>' +
        '</a>' +
        '<a href="#">' +
        ' <li>2</li>' +
        '</a>' +
        '<a href="#">' +
        ' <li>3</li>' +
        ' </a>' +
        '<a href="#" class="next">' +
        ' <li>Next</li>' +
        ' </a>' +
        '</ul>' +
        '</div>';
    $("#" + id_contenedor).append(cuerpo);
}

$(document).on('click', '.agregar', function(e) {
    let t = this.dataset.producto
    let producto = productos.find(x => x.id == t);
    producto.contador = contador;
    cargar_detalle(producto); 
    sumar_total();


});

function agregar_por_codigo(cod_barra) {
    let producto = productos.find(x => x.cod_barra == cod_barra);
    producto.contador = contador;
    cargar_detalle(producto);
    sumar_total();
}


function cargar_detalle(elemento) {
    let cuerpo = '';
    let precio_seleccionado = $("#precio_" + elemento.id).val();
    let clase_tipo = 'd-none';
    if (elemento.id_tipo == 2 || elemento.id_tipo == 3) {
        clase_tipo = '';
    }
    cuerpo = '<tr id="t' + elemento.contador + '">' +
        '<td>' + elemento.nombre + '</td>' +
        '<td>' + cargar_usuarios(elemento.contador, clase_tipo) + '</td>' +
        '<td><input id="c' + elemento.contador + '" class="form-control cantidad " data-cantidad="' + elemento.contador + '" type="number" value=1></td>' +
        '<td><input disabled id="cu' + elemento.contador + '" class="form-control costo_un" data-costo_un="' + elemento.contador + '" type="number" value=' + precio_seleccionado + '></td>' +
        '<td><input disabled id="s' + elemento.contador + '" class="form-control subtotal" data-subtotal="' + elemento.contador + '" type="number" value=' + precio_seleccionado + '></td>' +
        '<td><a data-eliminar="' + elemento.contador + '" class="btn btn-danger eliminar"><i class="fa fa-trash"></i></a></td>' +
        '</tr>'
    $("#tabla").append(cuerpo);
    detalle_productos.push(elemento);
    contador++;
    console.log(detalle_productos);
}
$("#id_descuento").on('change keyup', function() {
    let total = total_venta;
    let descuento_ = $(this).val();
    let descuento = parseFloat(total) - parseFloat(descuento_);
    $(".tot_descuento").text(descuento);
    $("#id_cancelo").val(0);
    $("#id_cancelo_d").val(0);
    $("#id_vuelto").text(0);

});
$("#id_cancelo").keyup(function() {
    let total = $(".tot_descuento").text();
    let cancelo = $("#id_cancelo").val();
    let cancelo2 = $("#id_cancelo_d").val() * parseFloat($("#tc").val());
    let vuelto = parseFloat(cancelo) + parseFloat(cancelo2) - parseFloat(total);
    $("#id_vuelto").text(vuelto);
});
$("#id_cancelo_d").keyup(function() {
    let total = $(".tot_descuento").text();
    let cancelo = $("#id_cancelo").val();
    let cancelo2 = $("#id_cancelo_d").val() * parseFloat($("#tc").val());;
    let vuelto = parseFloat(cancelo) + parseFloat(cancelo2) - parseFloat(total);
    $("#id_vuelto").text(vuelto);
});
$(document).on('change keyup', '.cantidad', function(e) {
    let id = this.dataset.cantidad;
    let cantidad = this.value;
    let costo_un = $("#cu" + id).val();
    let subtotal = cantidad * costo_un;
    $("#s" + id).val(subtotal);
    sumar_total();


});
$(document).on('change keyup', '.costo_un', function(e) {
    let id = this.dataset.costo_un;
    let costo_un = this.value;
    let cantidad = $("#c" + id).val();
    let subtotal = costo_un * cantidad;
    $("#s" + id).val(subtotal);
    sumar_total();


});

$(document).on('change keyup', '.subtotal', function(e) {
    let id = this.dataset.subtotal;
    let subtotal = this.value;
    let cantidad = $("#c" + id).val();
    let costo_un = subtotal / cantidad;
    $("#cu" + id).val(costo_un);
    sumar_total();
});
$(document).on('click', '.eliminar', function(e) {
    let t = this.dataset.eliminar;
    let index = detalle_productos.findIndex(x => x.contador == t);
    detalle_productos.splice(index, 1);
    $('#t' + t).remove();
    sumar_total();
    console.log(detalle_productos)
});

function sumar_total() {
    var numbers = $('.subtotal')
    var total = 0;
    for (var i = 0; i < numbers.length; i++) {
        total = total + parseFloat(numbers.eq(i).val())
    }
    total_venta = total;
    $('.result').text(total);
    $(".tot_descuento").text(total);
}

$("#tipo_venta").change(function() {
    let tipo = $(this).val();
    if (tipo == 1) {
        $(".cambios").removeClass("d-none");
    } else {
        $(".cambios").addClass("d-none");
    }
});


$(".guardar").click(function() {
    if (detalle_productos.length > 0 && $("#id_cliente").val() != 0) {
        if ($("#id_vuelto").text() >= 0) {

            construir_json();
        } else {
            Snackbar.show({
                text: 'El vuelto debe ser mayor a cero',
                postion: 'top-center',
                backgroundColor: '#dc3545',
                textColor: '#fff',
                duration: 3000
            });
        }

    } else {
        Snackbar.show({ text: 'No existe productos, tiene que seleccionar un cliente, tiene q seleccionar un almacen', pos: 'top-center' });
    }

});
$(".cancelar").click(function() {
    location.href = "lista_ventas.html";
});

function construir_json() {
    let datos = {};
    var costo = 0;
    for (let index = 0; index < detalle_productos.length; index++) {
        const element = detalle_productos[index];
        element.id_usuario = $("#u" + element.contador).val();
        element.precio = $("#cu" + element.contador).val();
        element.costo = $("#s" + element.contador).val();
        element.cantidad = $("#c" + element.contador).val();
        element.id_almacen = element.id_almacen;
        element.id_producto = element.id;
        costo += parseFloat(element.costo);
    }
    datos.id_viaje = $("#id_viaje").val();
    datos.nombre = $("#nombre_input").val();

    datos.productos = detalle_productos;
    datos.id_empresa = id_empresa;
    datos.id_sucursal = $("#id_sucursales").val();
    datos.id_cliente = $("#id_cliente").val();
    datos.id_responsable = 0;
    datos.id_usuario = usuario.id;
    datos.descuento = $("#id_descuento").val();
    datos.fecha_venta = $("#fecha_venta").val();
    datos.tipo_venta = $("#tipo_venta").val();
    datos.total = costo;
    datos.cambio = parseFloat($("#id_vuelto").text());
    datos.ci = $("#ci_input").val();
    datos.tipo_pago = $("#tipo_pago").val();
    datos.tarjeta = $("#tarjeta").val();
    datos.estado = 1;
    datos.id_tratamiento = 0;
    if ($("#es_paquete").is(':checked')) {
        datos.es_paquete = 1;
    } else {
        datos.es_paquete = 0;
    }
    if (datos.tipo_venta == 1) {
        datos.saldo = 0;

    } else {
        datos.saldo = datos.total;
    }

    datos.nota = $("#nota").val();

    console.log(datos);
    if (productos.length > 0 && $("#id_cliente").val() > 0) {

        insertar_venta(datos);
    } else {
        Snackbar.show({ text: 'Debe seleccionar un producto y un cliente', pos: 'top-center' });
    }

}

function insertar_venta(datos) {
    var enviar = JSON.stringify(datos);
    $(".caja_loader").show();
    $.ajax({
        url: urlServicio + 'API_REST/insertar_venta',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                let url = 'imprimir_venta.html?v=' + d.msg;

                window.open(url);

                setTimeout(() => {
                    if (datos.tipo_venta == 1) {
                        location.href = "lista_ventas.html";
                    } else {
                        location.href = "lista_ventas_credito.html";
                    }
                    // window.location.href = "lista_ventas.html";
                }, 1000);
                $('.caja_loader').hide();

            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: error



    });
}

function openCity(evt, cityName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(cityName).style.display = "block";
    evt.currentTarget.className += " active";
}

function limpiar() {

}