const csrfToken = document.head.querySelector(
  "[name~=csrf-token][content]"
).content;
var fechaInicio = document.getElementById("fechaInicio");
var fechaFin = document.getElementById("fechaFin");
window.onload = function () {
  let fechaInicio = document.getElementById("fechaInicio");
  let fechaFin = document.getElementById("fechaFin");

  const date = new Date();

  let currentDay = String(date.getDate()).padStart(2, "0");
  let currentMonth = String(date.getMonth()).padStart(2, "0");
  let currentYear = date.getFullYear();

  let currentHour = String(date.getHours()).padStart(2, "0");
  let currentMins = String(date.getMinutes()).padStart(2, "0");
  let currentSeconds = String(date.getSeconds()).padStart(2, "0");
  let currentMiliseconds = String(date.getMilliseconds()).padStart(3, "0");

  let currentDate =
    currentYear +
    "-" +
    currentMonth +
    "-" +
    currentDay +
    "T" +
    currentHour +
    ":" +
    currentMins +
    ":" +
    currentSeconds;

  fechaInicio.value = currentDate;
  fechaFin.value = currentDate;

  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/EventoSignificativoService.php",
    type: "GET",
    data: {
      metodo: "obtenerParametricasEventos",
    },
    dataType: "json",
    success: function (d) {
      var selectEventos = $("#eventos").html("");
      let eventos = d.content;
      for (let index = 0; index < d.content.length; index++) {
        const element = eventos[index];
        if (index == 0) {
          selectEventos.append(
            '<option selected value="' +
              element.codigoclasificador +
              '">' +
              element.descripcion +
              "</option>"
          );
        } else {
          selectEventos.append(
            '<option value="' +
              element.codigoclasificador +
              '">' +
              element.descripcion +
              "</option>"
          );
        }
      }
    },
    error: function (data, textStatus, jqXHR) {
      console.log(data);
      console.log(textStatus);
      console.log(jqXHR);
    },
  });
};

function getCufd() {
  const fechaInicioQuit = fechaInicio.value;
  const fechaFinQuit = fechaFin.value;

  const fechaInicioCufd = document.getElementById("fechaInicioCufd");
  const inputDireccion = document.getElementById("direccion");
  const inputCodigoControl = document.getElementById("codigoControl");
  const inputCodigoCufd = document.getElementById("codigoCufd");
  const inputCodigoCafc = document.getElementById("codigoCafc");
  let codigoEventoSignificativo = document.getElementById("eventos");

  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/ObtenerCufdPorFechas.php",
    type: "POST",
    data: {
      metodo: "obtenerCufdPorFechas",
      codigoEvento: codigoEventoSignificativo.value,
      fechaInicio:
        fechaInicioQuit,
      fechaFin: fechaFinQuit,
    },
    dataType: "json",
    success: function (d) {
      console.log("respuest: " + d.content.fechaInicioCufd);
      fechaInicioCufd.value = d.content.fechaInicioCufd;
      inputDireccion.value = d.content.Direccion;
      inputCodigoControl.value = d.content.CodigoControl;
      inputCodigoCufd.value = d.content.CodigoCufd;
      inputCodigoCafc.value = d.content.codigoCafc;
    },
    error: function (data, textStatus, jqXHR) {
      console.log(data);
      console.log(textStatus);
      console.log(jqXHR);
    },
  });
}

function saveEvento() {
  $.ajax({
    headers: {
      "X-CSRF-TOKEN": csrfToken,
    },
    url: "ServiciosSiat/EventoSignificativoService.php",
    type: "POST",
    data: {
      metodo: "registroEventoSignificativo",
      codigoDesc: document.getElementById("eventos").value,
      FechaInicio: document.getElementById("fechaInicio").value,
      FechaFinal: document.getElementById("fechaFin").value,
      cafc: document.getElementById("codigoCafc").value,
      cufdEvento: document.getElementById("codigoCufd").value,
      codigoControl: document.getElementById("codigoControl").value,
      direccion: document.getElementById("direccion").value,
      fechaInicioCufd: document.getElementById("fechaInicioCufd").value,
    },
    dataType: "json",
    success: function (d) {
      if (d.transaccion) {
        Snackbar.show({
          text: d.msg,
          pos: "top-right",
        });
      } else {
        Snackbar.show({
          text: d.msg,
          pos: "top-right",
        });
      }
      setTimeout(function () {
        location.href = "ventas.html";
      }, 3000);
    },
    error: function (data, textStatus, jqXHR) {
      console.log(data);
      console.log(textStatus);
      console.log(jqXHR);
    },
  });
}
