let sucursales = [];
var $table = $('#table');
let id_sucursal = 0;

$(function() {
    $table.bootstrapTable('refreshOptions', {
        locale: "es-AR"
    });
});

function cargar_tabla() {
    let id_empresa = usuario.id_empresa;
    $.ajax({
        url: urlServicio + 'API_REST/cargar_sucursal/' + id_empresa,
        //data: datos,
        type: "GET",
        dataType: "json",
        //contentType: "application/json; charset=utf-8",
        success: function(d) {

            if (d.errorCode == 0) {
                let res = d.msg;
                for (let index = 0; index < res.length; index++) {
                    const element = res[index];

                    element.editar = '<a data-edit="' + element.id + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                    element.eliminar = '<a data-delete="' + element.id + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';

                    sucursales.push(element);
                }

                data_table_cargar(sucursales);
            }
        },
        error: error


    });
}
$(document).on('click', '.edit', function(e) {
    var t = this.dataset.edit
    id_sucursal = t;
    agregar_tabla(t); 
});
$(document).on('click', '.delete', function(e) {
    let t = this.dataset.delete;
    Snackbar.show({
        text: 'Eliminar sucursal seguro?.',
        pos: 'top-center',
        actionText: 'Si',
        onActionClick: function(element) {
            eliminar_sucursal(t);
        }
    }); 
});
$(".delete").click(function() {

    //eliminar_sucursal(this.dataset.delete)
});

function agregar_tabla(id) {
    let datos = $table.bootstrapTable('getRowByUniqueId', id);
    $("#nombre").val(datos.nombre);
    $("#direccion").val(datos.direccion);
    $("#telefono").val(datos.telefono);
    $("#ciudad").val(datos.ciudad);
    $("#codigosucursal").val(datos.codigosucursal);

    $('html, body').animate({
        scrollTop: $("#nombre").offset().top - 100
    }, 500);
}
$(".guardar").click(function() {
    if (id_sucursal > 0) {
        if (validar($("#nombre")) && validar($("#direccion"))&& validar($("#telefono"))&& validar($("#ciudad"))&& validar($("#codigosucursal"))) {

            actualizar_sucursal();

        }
    } else {
        if (validar($("#nombre")) && validar($("#direccion"))&& validar($("#telefono"))&& validar($("#ciudad"))&& validar($("#codigosucursal"))) {

            insertar_sucursal();
        }
    }
});
$(".cancelar").click(function() {
    limpiar();
});

function insertar_sucursal() {
    let aray = [];
    let datos = {};
    datos.nombre = $("#nombre").val();
    datos.direccion = $("#direccion").val();
    datos.id_empresa = usuario.id_empresa;
    datos.telefono=$("#telefono").val();
    datos.codigosucursal=$("#codigosucursal").val();
    datos.ciudad=$("#ciudad").val();

    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/insertar_sucursal',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se inserto correctamente.', pos: 'top-center' });
                datos.id = d.msg;
                datos.editar = '<a data-edit="' + d.msg + '" class="font-20 text-danger edit"><i class="las la-edit"></i></a>';
                datos.eliminar = '<a data-delete="' + d.msg + '" class="font-20 text-primary delete"><i class="las la-trash-alt"></i></a>';
                aray.push(datos)
                $table.bootstrapTable('append', aray);
                limpiar();
            } else {
                Snackbar.show({ text: 'Error al insertar.', pos: 'top-center' });


            }

        },
        error: error



    });
}

function actualizar_sucursal() {
    var datos = {};
    datos.id = id_sucursal;
    datos.nombre = $("#nombre").val();
    datos.direccion = $("#direccion").val();
    datos.telefono=$("#telefono").val();
    datos.codigosucursal=$("#codigosucursal").val();
    datos.ciudad=$("#ciudad").val();
    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/actualizar_sucursal',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });

                $table.bootstrapTable('updateByUniqueId', {
                    id: id_sucursal,
                    row: {

                        nombre: $("#nombre").val(),
                        direccion: $("#direccion").val()

                    }
                });
                limpiar();
            } else {
                limpiar();
                Snackbar.show({ text: 'Se actualizo correctamente.', pos: 'top-center' });


            }

        },
        error: error



    });


}

function eliminar_sucursal(id_) {
    var datos = {};
    datos.id = id_;


    var enviar = JSON.stringify(datos);

    $.ajax({
        url: urlServicio + 'API_REST/eliminar_sucursal',
        data: enviar,
        type: "POST",
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function(d) {
            $('.loader').toggle();
            if (d['errorCode'] == 0) {
                Snackbar.show({
                    text: 'Se elimino correctamente.',
                    pos: 'top-center',
                    actionText: 'cerrar'
                });

                $table.bootstrapTable('removeByUniqueId', id_);
                limpiar();
            }

        },
        error: error



    });


}

function limpiar() {
    id_sucursal = 0;
    $("#nombre").val('');
    $("#direccion").val('');
}
